/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.adde.GetAreaGUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JFileChooser;

class GetAreaFile
implements ActionListener {
    public static final int AD_DATAOFFSET = 33;
    public static final int AD_NAVOFFSET = 34;
    public static final int AD_AUXOFFSET = 59;
    public static final int AD_CALOFFSET = 62;
    public static final int AD_DATAWIDTH = 10;
    final String[] paramNames = new String[]{"host", "group", "descr", "user", "proj", "trace", "band", "mag", "linele", "place", "pos", "size", "unit", "spac", "doc", "latlon", "aux", "time", "day", "cal", "id"};
    String[] flags = new String[]{"h", "g", "d", "k", "j", "t", "b", "m", "l", "n", "p", "s", "u", "z", "o", "r", "a", "i", "y", "c", "e"};
    String[] paramValues;
    String[] serverNames;
    String paramFile = "params.properties";
    String outputFile;
    Properties pars;
    boolean verbose = false;
    boolean doGUI = false;
    GetAreaGUI gag = null;
    String gagRequest = null;

    public static void main(String[] stringArray) {
        GetAreaFile getAreaFile = new GetAreaFile(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("got action performed...");
        if (!actionEvent.getActionCommand().startsWith("adde://")) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object.equals(this.gag)) {
            Properties properties = new Properties();
            this.putProp(properties, "host", this.gag.getServer());
            this.putProp(properties, "group", this.gag.getGroup());
            this.putProp(properties, "descr", this.gag.getDescr());
            this.putProp(properties, "user", this.gag.getUserName());
            this.putProp(properties, "proj", this.gag.getProjectNumber());
            this.putProp(properties, "trace", null);
            this.putProp(properties, "band", this.gag.getBand());
            this.putProp(properties, "mag", this.gag.getMag());
            String string = this.gag.getCoordType();
            if (string.equals("E")) {
                this.putProp(properties, "latlon", this.gag.getLocationString());
            } else if (string.equals("I")) {
                this.putProp(properties, "linele", this.gag.getLocationString());
            } else if (string.equals("S")) {
                this.putProp(properties, "id", this.gag.getLocationString());
            }
            this.putProp(properties, "time", this.gag.getTime());
            this.putProp(properties, "day", this.gag.getDay());
            this.putProp(properties, "size", this.gag.getNumLinesEles());
            this.putProp(properties, "unit", this.gag.getUnit());
            this.putProp(properties, "doc", this.gag.getDoc());
            this.gagRequest = actionEvent.getActionCommand();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Name of AREA file to write into");
            int n = jFileChooser.showSaveDialog(this.gag);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.putProp(properties, "outfile", file.toString());
                this.doRequest(properties);
            } else {
                this.gag.status("File not saved!!!");
            }
            System.exit(0);
        }
    }

    void putProp(Properties properties, String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (string2.trim().length() < 1) {
            return;
        }
        ((Hashtable)properties).put(string, string2);
    }

    private void doGUI() {
        String string;
        String string2;
        this.gag = new GetAreaGUI("Select File", false);
        this.gag.addActionListener(this);
        this.gag.show();
        String string3 = this.pars.getProperty("user");
        if (string3 != null) {
            this.gag.setUserName(string3);
        }
        if ((string2 = this.pars.getProperty("proj")) != null) {
            this.gag.setProjectNumber(string2);
        }
        String string4 = this.pars.getProperty("pos");
        String string5 = this.pars.getProperty("day");
        String string6 = this.pars.getProperty("time");
        String string7 = this.pars.getProperty("latlon");
        String string8 = this.pars.getProperty("linele");
        String string9 = this.pars.getProperty("id");
        if (string7 != null) {
            this.gag.setCoordType("E");
            this.gag.setLocationString(string7);
        } else if (string8 != null) {
            this.gag.setCoordType("I");
            this.gag.setLocationString(string8);
        } else if (string9 != null) {
            this.gag.setCoordType("S");
            this.gag.setLocationString(string9);
        }
        String string10 = this.pars.getProperty("size");
        if (string10 != null) {
            this.gag.setNumLinesEles(string10);
        } else {
            this.gag.setNumLinesEles("480 640");
        }
        String string11 = this.pars.getProperty("mag");
        if (string11 != null) {
            this.gag.setMag(string11);
        }
        if ((string = this.pars.getProperty("band")) != null) {
            this.gag.setBand(string);
        }
        String string12 = this.pars.getProperty("spac");
        String string13 = this.pars.getProperty("unit");
        if (string13 != null) {
            this.gag.setUnit(string13);
        }
        String string14 = this.pars.getProperty("cal");
        String string15 = this.pars.getProperty("doc");
        if (string15 != null) {
            this.gag.setDoc(string15);
        }
        String string16 = this.pars.getProperty("aux");
    }

    public void doRequest(Properties properties) {
        int[][] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5;
        AreaFile areaFile;
        block53: {
            block52: {
                String string = this.makeADDEString(properties);
                if (this.gagRequest != null) {
                    string = this.gagRequest;
                }
                if (this.gag != null) {
                    this.outputFile = properties.getProperty("outfile");
                }
                System.out.println("Request sent: " + string);
                if (this.gag != null) {
                    this.gag.status("Request sent: " + string);
                }
                try {
                    areaFile = new AreaFile(string);
                }
                catch (AreaFileException areaFileException) {
                    String string2;
                    System.out.println("While getting AreaFile:" + areaFileException);
                    String string3 = string2 = areaFileException.toString();
                    int n = string2.lastIndexOf("Exception:");
                    if (n > 0) {
                        string2 = string3.substring(n + 11);
                    }
                    if (this.gag != null) {
                        this.gag.status("Error: " + string2);
                    }
                    return;
                }
                try {
                    nArray5 = areaFile.getDir();
                }
                catch (AreaFileException areaFileException) {
                    if (this.verbose) {
                        System.out.println("Getting dir:" + areaFileException);
                    }
                    return;
                }
                if (this.verbose) {
                    System.out.println("Length of directory = " + nArray5.length);
                }
                int n = 0;
                while (n < nArray5.length) {
                    if (this.verbose) {
                        System.out.println(" index " + n + " = " + nArray5[n]);
                    }
                    ++n;
                }
                nArray4 = null;
                try {
                    nArray4 = areaFile.getNav();
                    if (this.verbose) {
                        System.out.println("Length of nav block = " + nArray4.length);
                    }
                }
                catch (AreaFileException areaFileException) {
                    if (this.verbose) {
                        System.out.println("Getting nav:" + areaFileException);
                    }
                    return;
                }
                nArray3 = null;
                try {
                    nArray3 = areaFile.getCal();
                    if (this.verbose) {
                        System.out.println("Length of cal block = " + nArray3.length);
                    }
                }
                catch (AreaFileException areaFileException) {
                    if (!this.verbose) break block52;
                    System.out.println("Getting cal:" + areaFileException);
                }
            }
            nArray2 = null;
            try {
                nArray2 = areaFile.getAux();
                if (this.verbose) {
                    System.out.println("Length of aux block = " + nArray2.length);
                }
            }
            catch (AreaFileException areaFileException) {
                if (!this.verbose) break block53;
                System.out.println("Getting aux:" + areaFileException);
            }
        }
        int n = nArray5[8];
        int n2 = nArray5[9];
        if (this.verbose) {
            System.out.println("Start reading data, num points=" + n * n2);
        }
        if (this.gag != null) {
            this.gag.status("Start reading data, num points=" + n * n2);
        }
        try {
            nArray = areaFile.getData(0, 0, n, n2);
        }
        catch (AreaFileException areaFileException) {
            System.out.println(areaFileException);
            return;
        }
        if (this.verbose) {
            System.out.println("Finished reading data");
        }
        if (this.gag != null) {
            this.gag.status("Finished reading data");
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.outputFile, "rw");
            if (this.verbose) {
                System.out.println("Dir to word 0");
            }
            randomAccessFile.seek(0L);
            nArray5[0] = 0;
            int n3 = 0;
            while (n3 < nArray5.length) {
                randomAccessFile.writeInt(nArray5[n3]);
                ++n3;
            }
            if (this.verbose) {
                System.out.println("Nav to word " + nArray5[34]);
            }
            if (nArray4 != null && nArray5[34] > 0) {
                randomAccessFile.seek(nArray5[34]);
                n3 = 0;
                while (n3 < nArray4.length) {
                    randomAccessFile.writeInt(nArray4[n3]);
                    ++n3;
                }
            }
            if (this.verbose) {
                System.out.println("Cal to word " + nArray5[62]);
            }
            if (nArray3 != null && nArray5[34] > 0) {
                randomAccessFile.seek(nArray5[62]);
                n3 = 0;
                while (n3 < nArray3.length) {
                    randomAccessFile.writeInt(nArray3[n3]);
                    ++n3;
                }
            }
            if (this.verbose) {
                System.out.println("Aux to word " + nArray5[59]);
            }
            if (nArray2 != null && nArray5[34] > 0) {
                randomAccessFile.seek(nArray5[59]);
                n3 = 0;
                while (n3 < nArray2.length) {
                    randomAccessFile.writeInt(nArray2[n3]);
                    ++n3;
                }
            }
            if (this.verbose) {
                System.out.println("Data to word " + nArray5[33]);
            }
            if (nArray5[34] > 0) {
                randomAccessFile.seek(nArray5[33]);
                n3 = 0;
                while (n3 < nArray.length) {
                    int n4 = 0;
                    while (n4 < nArray[n3].length) {
                        if (nArray5[10] == 1) {
                            randomAccessFile.writeByte(nArray[n3][n4]);
                        } else if (nArray5[10] == 2) {
                            randomAccessFile.writeShort(nArray[n3][n4]);
                        } else if (nArray5[10] == 4) {
                            randomAccessFile.writeInt(nArray[n3][n4]);
                        }
                        ++n4;
                    }
                    ++n3;
                }
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        System.out.println("Completed. Data saved to: " + this.outputFile + "   Saving parameters to: " + this.paramFile);
        if (this.gag != null) {
            this.gag.status("Completed. Data saved to: " + this.outputFile + "   Saving parameters to: " + this.paramFile);
        }
        this.writeParams(this.paramFile, properties);
    }

    public String makeADDEString(Properties properties) {
        String string = properties.getProperty("host");
        if (string == null) {
            return null;
        }
        String string2 = properties.getProperty("group");
        if (string2 == null) {
            return null;
        }
        String string3 = properties.getProperty("descr");
        if (string3 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("adde://" + string + "/image?");
        int n = 0;
        while (n < this.paramNames.length) {
            if (this.paramNames[n] != "host" && properties.getProperty(this.paramNames[n]) != null) {
                stringBuffer.append(this.paramNames[n] + "=" + properties.getProperty(this.paramNames[n]) + "&");
            }
            ++n;
        }
        stringBuffer.append("version=1");
        return stringBuffer.toString();
    }

    String doArguments(String[] stringArray) {
        String string = stringArray[stringArray.length - 1];
        if (string.equalsIgnoreCase("-gui")) {
            this.doGUI = true;
            string = " ";
            return string;
        }
        int n = 0;
        while (n < stringArray.length - 1) {
            String string2 = stringArray[n];
            if (string2.length() > 1 && string2.startsWith("-")) {
                if (string2.equalsIgnoreCase("-gui")) {
                    this.doGUI = true;
                } else {
                    String string3 = string2.substring(1, 2);
                    if (string3.equals("f")) {
                        this.paramFile = string2.length() == 2 ? stringArray[++n] : string2.substring(2);
                    } else if (string3.equals("v")) {
                        this.verbose = true;
                    } else {
                        int n2 = 0;
                        while (n2 < this.paramNames.length) {
                            if (string3.equals(this.flags[n2])) {
                                this.paramValues[n2] = string2.length() == 2 ? stringArray[++n] : string2.substring(2);
                            }
                            ++n2;
                        }
                    }
                }
            } else {
                System.out.println("Problem with parameter: " + string2);
                return null;
            }
            ++n;
        }
        return string;
    }

    Properties fetchParams(String string) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        int n = 0;
        while (n < this.paramNames.length) {
            if (this.paramValues[n] != null) {
                ((Hashtable)properties).put(this.paramNames[n], this.paramValues[n]);
            }
            ++n;
        }
        return properties;
    }

    void writeParams(String string, Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.save(fileOutputStream, "GetAreaFile properties");
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public GetAreaFile(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            System.out.println("Usage:  java edu.wisc.ssec.mcidas.GetAreaFile [options] output_file");
            System.out.println("   Command line [options] are:");
            int n = 0;
            while (n < this.paramNames.length) {
                System.out.println("    -" + this.flags[n] + " = " + this.paramNames[n]);
                ++n;
            }
            System.out.println("    -f = parameter save filename (def=params.properties)");
            System.out.println("    -v  (verbose text output)");
            System.out.println("    -gui = use GUI interface (no other options should be used with this)");
            System.out.println(" Note: for multi-argument options (like -s), you need to enclose the values in quotes. e.g., -s \"200 200\"");
            System.exit(0);
        }
        this.paramValues = new String[this.paramNames.length];
        this.outputFile = this.doArguments(stringArray);
        if (this.outputFile == null) {
            System.exit(1);
        }
        this.pars = this.fetchParams(this.paramFile);
        if (this.doGUI) {
            this.doGUI();
        } else {
            this.doRequest(this.pars);
        }
    }
}

