/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class DataSetInfo {
    private int status = 0;
    private char[] data;
    private Hashtable descriptorTable;
    private boolean debug = false;

    public char[] getData() throws AddeURLException {
        if (this.status < 0) {
            throw new AddeURLException("No data available");
        }
        return this.data;
    }

    public Hashtable getDescriptionTable() throws AddeURLException {
        if (this.status < 0) {
            throw new AddeURLException("No data available");
        }
        return this.descriptorTable;
    }

    public String[] getDescriptors() throws AddeURLException {
        if (this.status < 0) {
            throw new AddeURLException("No data available");
        }
        Object[] objectArray = new String[this.descriptorTable.size()];
        Enumeration enumeration = this.descriptorTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String toString() {
        if (this.status < 0) {
            return new String("No data Available");
        }
        String string = new String("Name         NumPos   Content\n------------ ------   --------------------------------------\n");
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < this.data.length / 80) {
            StringBuffer stringBuffer2 = new StringBuffer("                                          ");
            String string2 = new String(this.data, n * 80, 80);
            stringBuffer2.insert(0, string2.substring(0, 12));
            int n2 = Integer.parseInt(string2.substring(12, 18).trim());
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string2.substring(18, 23).trim());
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 0;
            }
            if (n3 == 0) {
                n3 = n2;
            }
            int n4 = n3 - n2 + 1;
            int n5 = 17;
            if (n4 >= 10 && n4 < 100) {
                n5 = 16;
            } else if (n4 >= 100 && n4 < 1000) {
                n5 = 15;
            } else if (n4 > 1000) {
                n5 = 14;
            }
            stringBuffer2.insert(n5, String.valueOf(n4));
            int n6 = string2.indexOf(34);
            if (n6 >= 23) {
                stringBuffer2.insert(22, string2.substring(n6 + 1));
            }
            stringBuffer.append(stringBuffer2.toString().trim());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("\nDataset Names:\n");
        String string = stringArray.length == 0 ? "adde://adde.unidata.ucar.edu/datasetinfo?group=blizzard&type=image" : stringArray[0];
        DataSetInfo dataSetInfo = new DataSetInfo(string);
        System.out.println(dataSetInfo.toString());
        String[] stringArray2 = dataSetInfo.getDescriptors();
        System.out.println("Sorted list of Descriptors:");
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
    }

    public DataSetInfo(String string) throws AddeURLException {
        int n;
        int n2;
        BufferedReader bufferedReader;
        URLConnection uRLConnection;
        try {
            URL uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        }
        catch (AddeURLException addeURLException) {
            throw new AddeURLException("No datasets found");
        }
        catch (Exception exception) {
            throw new AddeURLException("Error opening connection: " + exception);
        }
        int n3 = ((AddeURLConnection)uRLConnection).getInitialRecordSize();
        if (this.debug) {
            System.out.println("DataSetInfo: numBytes = " + n3);
        }
        if (n3 == 0) {
            this.status = -1;
            throw new AddeURLException("No datasets found");
        }
        this.data = new char[n3];
        try {
            n2 = 0;
            while (n2 < n3) {
                n = bufferedReader.read(this.data, n2, n3 - n2);
                if (this.debug) {
                    System.out.println("bytes read = " + n);
                }
                n2 += n;
            }
        }
        catch (IOException iOException) {
            this.status = -1;
            throw new AddeURLException("Error reading dataset info:" + iOException);
        }
        n2 = this.data.length / 80;
        this.descriptorTable = new Hashtable(n2);
        if (this.debug) {
            System.out.println("Number of descriptors = " + n2);
        }
        n = 0;
        while (n < n2) {
            String string2 = new String(this.data, n * 80, 80);
            if (this.debug) {
                System.out.println("Parsing: >" + string2 + "<");
            }
            if (!string2.trim().equals("")) {
                String string3 = string2.substring(0, 12).trim();
                if (this.debug) {
                    System.out.println("Descriptor = " + string3);
                }
                String string4 = string3;
                int n4 = string2.indexOf(34);
                if (this.debug) {
                    System.out.println("Found quote at " + n4);
                }
                if (n4 >= 23 && (string4 = string2.substring(n4 + 1).trim()).equals("")) {
                    string4 = string3;
                }
                if (this.debug) {
                    System.out.println("Comment = " + string4);
                }
                this.descriptorTable.put(string4, string3);
            }
            ++n;
        }
    }

    static {
        try {
            String string = System.getProperty("java.protocol.handler.pkgs");
            String string2 = null;
            if (string == null) {
                string2 = "edu.wisc.ssec.mcidas";
            } else if (string.indexOf("edu.wisc.ssec.mcidas") < 0) {
                string2 = "edu.wisc.ssec.mcidas | " + string;
            }
            if (string2 != null) {
                System.setProperty("java.protocol.handler.pkgs", string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

