/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class AddeURLConnection
extends URLConnection {
    private static final int DEFAULT_LINES = 480;
    private static final int DEFAULT_ELEMS = 640;
    private static final int TRAILER_SIZE = 92;
    private static final int REQUEST_SIZE = 120;
    private static final int ERRMSG_SIZE = 72;
    private static final int ERRMSG_OFFS = 8;
    private static final int PORT = 500;
    public static final int AGET = 0;
    public static final int ADIR = 1;
    public static final int LWPR = 2;
    public static final int GDIR = 3;
    public static final int GGET = 4;
    public static final int MDKS = 5;
    public static final int TXTG = 6;
    private static final int IMAGE = 100;
    private static final int GRID = 101;
    private static final int POINT = 102;
    private static final int TEXT = 103;
    private InputStream is = null;
    private DataInputStream dis = null;
    private DataOutputStream dos = null;
    private URL url;
    private int numBytes = 0;
    private int dataType = 100;
    private byte[] binaryData = null;
    private int reqType = 0;
    private boolean debug = false;
    private int portToUse;

    public synchronized void connect() throws IOException, AddeURLException {
        int n;
        int n2;
        String string;
        String string2;
        int n3;
        int n4;
        String string3;
        String string4;
        Socket socket;
        try {
            socket = new Socket(this.url.getHost(), this.portToUse);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AddeURLException(unknownHostException.toString());
        }
        this.is = socket.getInputStream();
        this.dis = new DataInputStream(this.is);
        this.dos = new DataOutputStream(socket.getOutputStream());
        if (this.debug) {
            System.out.println("host from URL: " + this.url.getHost());
        }
        if (this.debug) {
            System.out.println("file from URL: " + this.url.getFile());
        }
        boolean bl = this.debug = (string4 = this.url.getFile().toLowerCase().substring(1)).indexOf("debug=true") >= 0;
        if (!(string4.startsWith("image") || string4.startsWith("datasetinfo") || string4.startsWith("text") || string4.startsWith("grid") || string4.startsWith("point"))) {
            throw new AddeURLException("Request for unknown data");
        }
        int n5 = 1;
        this.dos.writeInt(n5);
        byte[] byArray = new byte[4];
        InetAddress inetAddress = InetAddress.getByName(this.url.getHost());
        byArray = inetAddress.getAddress();
        this.dos.write(byArray, 0, byArray.length);
        this.dos.writeInt(this.portToUse);
        byte[] byArray2 = null;
        if (string4.startsWith("imagedir")) {
            byArray2 = new String("adir").getBytes();
            this.reqType = 1;
        } else if (string4.startsWith("datasetinfo")) {
            byArray2 = new String("lwpr").getBytes();
            this.reqType = 2;
        } else if (string4.startsWith("text")) {
            byArray2 = new String("txtg").getBytes();
            this.reqType = 6;
        } else if (string4.startsWith("image")) {
            byArray2 = new String("aget").getBytes();
            this.reqType = 0;
        } else if (string4.startsWith("griddir")) {
            byArray2 = new String("gdir").getBytes();
            this.reqType = 3;
        } else if (string4.startsWith("grid")) {
            byArray2 = new String("gget").getBytes();
            this.reqType = 4;
        } else if (string4.startsWith("point")) {
            byArray2 = new String("mdks").getBytes();
            this.reqType = 5;
        } else {
            throw new AddeURLException("Invalid ADDE service=" + byArray2.toString());
        }
        if (this.debug) {
            System.out.println("Service = " + byArray2.toString());
        }
        this.dos.write(byArray2, 0, byArray2.length);
        this.dos.write(byArray, 0, byArray.length);
        this.dos.writeInt(this.portToUse);
        InetAddress inetAddress2 = InetAddress.getLocalHost();
        byArray = inetAddress2.getAddress();
        this.dos.write(byArray, 0, byArray.length);
        int n6 = string4.indexOf("?");
        String string5 = string3 = n6 >= 0 ? string4.substring(n6 + 1) : string4;
        if (this.debug) {
            System.out.println("uCmd=" + string3);
        }
        if ((n4 = string3.indexOf("user=")) > 0) {
            n3 = string3.indexOf(38, n4);
            if (n3 == -1) {
                n3 = string3.length();
            }
            string2 = string3.substring(n4 + 5, n3);
        } else {
            string2 = "XXXX";
        }
        byte[] byArray3 = string2.getBytes();
        if (byArray3.length <= 4) {
            this.dos.write(byArray3, 0, byArray3.length);
            int n7 = 0;
            while (n7 < 4 - byArray3.length) {
                this.dos.writeByte(32);
                ++n7;
            }
        } else {
            throw new AddeURLException("Invalid user id: " + string2);
        }
        n4 = string3.indexOf("proj=");
        if (n4 > 0) {
            n3 = string3.indexOf(38, n4);
            if (n3 == -1) {
                n3 = string3.length();
            }
            string = string3.substring(n4 + 5, n3);
        } else {
            string = "0";
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AddeURLException("Invalid project number: " + string);
        }
        this.dos.writeInt(n2);
        byte[] byArray4 = new byte[12];
        this.dos.write(byArray4, 0, byArray4.length);
        this.dos.write(byArray2, 0, byArray2.length);
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.reqType) {
            case 0: {
                stringBuffer = this.decodeAGETString(string3);
                break;
            }
            case 1: {
                stringBuffer = this.decodeADIRString(string3);
                break;
            }
            case 2: {
                stringBuffer = this.decodeLWPRString(string3);
                break;
            }
            case 3: {
                stringBuffer = this.decodeGDIRString(string3);
                break;
            }
            case 4: {
                stringBuffer = this.decodeGDIRString(string3);
                break;
            }
            case 5: {
                stringBuffer = this.decodeMDKSString(string3);
                break;
            }
            case 6: {
                stringBuffer = this.decodeTXTGString(string3);
                break;
            }
        }
        stringBuffer.append(" version=");
        stringBuffer.append(this.reqType == 4 ? "A" : "1");
        String string6 = new String(stringBuffer);
        string6 = string6.toUpperCase();
        if (this.debug) {
            System.out.println(string6);
        }
        byte[] byArray5 = string6.getBytes();
        int n8 = 0;
        if (this.binaryData != null) {
            n8 = this.binaryData.length;
        }
        if (byArray5.length > 120) {
            this.dos.writeInt(byArray5.length + n8);
            this.dos.writeInt(byArray5.length);
            n = 0;
            while (n < 116) {
                this.dos.writeByte(0);
                ++n;
            }
            this.dos.write(byArray5, 0, byArray5.length);
        } else {
            if (this.debug) {
                System.out.println("numBinaryBytes= " + n8);
            }
            this.dos.writeInt(n8);
            this.dos.write(byArray5, 0, byArray5.length);
            n = 0;
            while (n < 120 - byArray5.length) {
                this.dos.writeByte(32);
                ++n;
            }
        }
        if (n8 > 0) {
            this.dos.write(this.binaryData, 0, n8);
        }
        this.numBytes = this.dis.readInt();
        if (this.numBytes == 0) {
            byte[] byArray6 = new byte[92];
            this.dis.readFully(byArray6, 0, byArray6.length);
            String string7 = new String(byArray6, 8, 72);
            throw new AddeURLException(string7);
        }
        if (this.debug) {
            System.out.println("server is sending: " + this.numBytes + " bytes");
        }
        this.connected = true;
    }

    public int getRequestType() {
        return this.reqType;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    public synchronized DataInputStream getDataInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.dis;
    }

    public int getInitialRecordSize() {
        return this.numBytes;
    }

    private StringBuffer decodeAGETString(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = "all";
        String string10 = "0";
        String string11 = Integer.toString(480);
        String string12 = Integer.toString(640);
        String string13 = "x";
        String string14 = "trace=0";
        String string15 = "spac=1";
        String string16 = "unit=brit";
        String string17 = "aux=yes";
        String string18 = "cal=x";
        String string19 = "doc=no";
        String string20 = "time=x x i";
        String string21 = "a";
        String string22 = "c";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            string7 = stringTokenizer.nextToken();
            if (string7.startsWith("grou")) {
                string8 = string7.substring(string7.indexOf("=") + 1);
                continue;
            }
            if (string7.startsWith("des")) {
                string9 = string7.substring(string7.indexOf("=") + 1);
                continue;
            }
            if (string7.startsWith("pos")) {
                string10 = string7.substring(string7.indexOf("=") + 1);
                continue;
            }
            if (string7.startsWith("lat")) {
                string2 = string7.substring(string7.indexOf("=") + 1).trim();
                bl = true;
                if (string2.indexOf(" ") <= 0) continue;
                object = new StringTokenizer(string2);
                if (((StringTokenizer)object).countTokens() < 2) break;
                n = 0;
                while (n < 2) {
                    string6 = ((StringTokenizer)object).nextToken();
                    if (n == 0) {
                        string2 = string6;
                    } else {
                        string3 = this.negateLongitude(string6);
                        bl2 = true;
                    }
                    ++n;
                }
                continue;
            }
            if (string7.startsWith("lon")) {
                bl2 = true;
                string3 = string7.substring(string7.indexOf("=") + 1);
                continue;
            }
            if (string7.startsWith("lin")) {
                string6 = string7.substring(string7.indexOf("=") + 1);
                if (string6.indexOf(" ") > 0) {
                    object = new StringTokenizer(string6);
                    if (((StringTokenizer)object).countTokens() < 2) break;
                    n = 0;
                    while (n < 2) {
                        string6 = ((StringTokenizer)object).nextToken();
                        if (n == 0) {
                            string4 = string6;
                            bl3 = true;
                        } else {
                            string5 = string6;
                            bl4 = true;
                        }
                        ++n;
                    }
                    if (!((StringTokenizer)object).hasMoreTokens() || !(string6 = ((StringTokenizer)object).nextToken().toLowerCase()).startsWith("i")) continue;
                    string21 = "i";
                    continue;
                }
                string11 = string6;
                continue;
            }
            if (string7.startsWith("ele")) {
                string12 = string7.substring(string7.indexOf("=") + 1);
                continue;
            }
            if (string7.startsWith("pla")) {
                if (!string7.substring(string7.indexOf("=") + 1).toLowerCase().startsWith("u")) continue;
                string22 = "u";
                continue;
            }
            if (string7.startsWith("mag")) {
                string6 = string7.substring(string7.indexOf("=") + 1);
                if (string6.indexOf(" ") > 0) {
                    object = new StringTokenizer(string6);
                    if (((StringTokenizer)object).countTokens() < 2) break;
                    n = 0;
                    while (n < 2) {
                        stringBuffer.append(" ");
                        string6 = ((StringTokenizer)object).nextToken();
                        if (n == 0) {
                            stringBuffer.append("lmag=" + string6);
                        } else {
                            stringBuffer.append("emag=" + string6);
                        }
                        ++n;
                    }
                    continue;
                }
                string13 = string6;
                continue;
            }
            if (string7.startsWith("size")) {
                string6 = string7.substring(string7.indexOf("=") + 1);
                if (string6.indexOf(" ") <= 0) continue;
                object = new StringTokenizer(string6);
                if (((StringTokenizer)object).countTokens() < 2) break;
                n = 0;
                while (n < 2) {
                    string6 = ((StringTokenizer)object).nextToken();
                    if (n == 0) {
                        string11 = string6;
                    } else {
                        string12 = string6;
                    }
                    ++n;
                }
                continue;
            }
            if (string7.startsWith("tra")) {
                string14 = string7;
                continue;
            }
            if (string7.startsWith("spa")) {
                string15 = string7;
                continue;
            }
            if (string7.startsWith("aux")) {
                string17 = string7;
                continue;
            }
            if (string7.startsWith("uni")) {
                string16 = string7;
                continue;
            }
            if (string7.startsWith("cal")) {
                string18 = string7;
                continue;
            }
            if (string7.startsWith("doc")) {
                string19 = string7;
                continue;
            }
            if (string7.startsWith("tim")) {
                string20 = string7;
                continue;
            }
            if (string7.startsWith("ban")) {
                stringBuffer.append(" ");
                stringBuffer.append(string7);
                continue;
            }
            if (string7.startsWith("day")) {
                stringBuffer.append(" ");
                stringBuffer.append(string7);
                continue;
            }
            if (string7.startsWith("id")) {
                stringBuffer.append(" ");
                stringBuffer.append(string7);
                continue;
            }
            if (string7.startsWith("lmag")) {
                stringBuffer.append(" ");
                stringBuffer.append(string7);
                continue;
            }
            if (!string7.startsWith("emag")) continue;
            stringBuffer.append(" ");
            stringBuffer.append(string7);
        }
        stringBuffer.append(" ");
        stringBuffer.append(string14);
        stringBuffer.append(" ");
        stringBuffer.append(string15);
        stringBuffer.append(" ");
        stringBuffer.append(string16);
        stringBuffer.append(" ");
        stringBuffer.append(string17);
        stringBuffer.append(" ");
        stringBuffer.append(string19);
        stringBuffer.append(" ");
        stringBuffer.append(string20);
        stringBuffer.append(" ");
        stringBuffer.append(string18);
        object = new StringBuffer(string8 + " " + string9 + " " + string10 + " ");
        if (bl && bl2) {
            ((StringBuffer)object).append("ec " + string2 + " " + string3 + " ");
        } else if (bl3 && bl4) {
            ((StringBuffer)object).append(string21 + string22 + "  " + string4 + " " + string5 + " ");
        } else {
            ((StringBuffer)object).append("x x x ");
        }
        ((StringBuffer)object).append(string13 + " " + string11 + " " + string12 + " ");
        try {
            stringBuffer.insert(0, object);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println(stringIndexOutOfBoundsException.toString());
            stringBuffer = new StringBuffer("");
        }
        return stringBuffer;
    }

    private StringBuffer decodeGDIRString(String string) {
        CharSequence charSequence;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = "all";
        String string4 = " 999999 ";
        String string5 = "trace=0";
        String string6 = "num=1";
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        Object var15_13 = null;
        String string12 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string13 = stringTokenizer.nextToken();
            if (string13.startsWith("grou")) {
                string2 = string13.substring(string13.indexOf("=") + 1);
                continue;
            }
            if (string13.startsWith("des")) {
                string3 = string13.substring(string13.indexOf("=") + 1);
                continue;
            }
            if (string13.startsWith("num")) {
                string6 = string13;
                continue;
            }
            if (string13.startsWith("tra")) {
                string5 = string13;
                continue;
            }
            if (string13.startsWith("pos")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("par")) {
                stringBuffer.append(" ");
                stringBuffer.append("parm=");
                stringBuffer.append(string13.substring(string13.indexOf("=") + 1));
                continue;
            }
            if (string13.startsWith("fho")) {
                stringBuffer.append(" ");
                stringBuffer.append("vt=");
                charSequence = string13.substring(string13.indexOf("=") + 1).trim();
                stringBuffer.append((String)charSequence);
                if (((String)charSequence).length() >= 5) continue;
                stringBuffer.append("0000");
                continue;
            }
            if (string13.startsWith("day")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("time")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("lev")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("fday")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("ftime")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("vt")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("lat")) {
                string8 = this.ensureTwoValues(string13.substring(string13.indexOf("=") + 1));
                continue;
            }
            if (string13.startsWith("lon")) {
                string9 = this.adjustLongitudes(this.ensureTwoValues(string13.substring(string13.indexOf("=") + 1)));
                continue;
            }
            if (string13.startsWith("row")) {
                string10 = this.ensureTwoValues(string13.substring(string13.indexOf("=") + 1));
                continue;
            }
            if (string13.startsWith("col")) {
                string11 = this.ensureTwoValues(string13.substring(string13.indexOf("=") + 1));
                continue;
            }
            if (string13.startsWith("skip")) {
                string12 = this.ensureTwoValues(string13.substring(string13.indexOf("=") + 1));
                continue;
            }
            if (string13.startsWith("src")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("gpro")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("trang")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (string13.startsWith("frang")) {
                stringBuffer.append(" ");
                stringBuffer.append(string13);
                continue;
            }
            if (!string13.startsWith("drang")) continue;
            stringBuffer.append(" ");
            stringBuffer.append(string13);
        }
        stringBuffer.append(" ");
        stringBuffer.append(string6);
        stringBuffer.append(" ");
        stringBuffer.append(string5);
        stringBuffer.append(" ");
        if (string8 != null && string9 != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("subset=");
            ((StringBuffer)charSequence).append(string8);
            ((StringBuffer)charSequence).append(" ");
            ((StringBuffer)charSequence).append(string9);
            ((StringBuffer)charSequence).append(" ");
            ((StringBuffer)charSequence).append(string12 == null ? "1 1" : string12);
            ((StringBuffer)charSequence).append(" LATLON");
            string7 = ((StringBuffer)charSequence).toString();
            if (this.debug) {
                System.out.println(string7);
            }
        } else if (string10 != null && string11 != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("subset=");
            ((StringBuffer)charSequence).append(string10);
            ((StringBuffer)charSequence).append(" ");
            ((StringBuffer)charSequence).append(string11);
            ((StringBuffer)charSequence).append(" ");
            ((StringBuffer)charSequence).append(string12 == null ? "1 1" : string12);
            ((StringBuffer)charSequence).append(" ROWCOL");
            string7 = ((StringBuffer)charSequence).toString();
            if (this.debug) {
                System.out.println(string7);
            }
        } else if (string12 != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("subset=1 99999 1 99999");
            ((StringBuffer)charSequence).append(" ");
            ((StringBuffer)charSequence).append(string12);
            ((StringBuffer)charSequence).append(" ROWCOL");
            string7 = ((StringBuffer)charSequence).toString();
            if (this.debug) {
                System.out.println(string7);
            }
        }
        if (string7 != null) {
            stringBuffer.append(string7);
        }
        charSequence = new String(string2 + " " + string3 + " " + string4 + " ");
        try {
            stringBuffer.insert(0, (String)charSequence);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println(stringIndexOutOfBoundsException);
            stringBuffer = new StringBuffer("");
        }
        return stringBuffer;
    }

    private StringBuffer decodeADIRString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = "all";
        String string4 = "0 0";
        String string5 = "trace=0";
        String string6 = "band=all x";
        String string7 = "aux=yes";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string8 = stringTokenizer.nextToken();
            if (string8.startsWith("grou")) {
                string2 = string8.substring(string8.indexOf("=") + 1);
                continue;
            }
            if (string8.startsWith("des")) {
                string3 = string8.substring(string8.indexOf("=") + 1);
                continue;
            }
            if (string8.startsWith("pos")) {
                String string9 = string8.substring(string8.indexOf("=") + 1);
                string4 = string9.equals("") ? "0 0" : (string9.equals("all") ? "1095519264" : string9 + " 0");
                continue;
            }
            if (string8.startsWith("tra")) {
                string5 = string8;
                continue;
            }
            if (string8.startsWith("aux")) {
                string7 = string8;
                continue;
            }
            if (string8.startsWith("ban")) {
                string6 = string8;
                continue;
            }
            if (string8.startsWith("tim")) {
                stringBuffer.append(" ");
                stringBuffer.append(string8);
                continue;
            }
            if (string8.startsWith("day")) {
                stringBuffer.append(" ");
                stringBuffer.append(string8);
                continue;
            }
            if (!string8.startsWith("id")) continue;
            stringBuffer.append(" ");
            stringBuffer.append(string8);
        }
        stringBuffer.append(" ");
        stringBuffer.append(string5);
        stringBuffer.append(" ");
        stringBuffer.append(string6);
        stringBuffer.append(" ");
        stringBuffer.append(string7);
        String string10 = new String(string2 + " " + string3 + " " + string4 + " ");
        try {
            stringBuffer.insert(0, string10);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println(stringIndexOutOfBoundsException.toString());
            stringBuffer = new StringBuffer("");
        }
        return stringBuffer;
    }

    public StringBuffer decodeTXTGString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string5.startsWith("desc")) {
                string4 = string5.substring(string5.indexOf("=") + 1);
            }
            if (string5.startsWith("file")) {
                string3 = "FILE=" + string5.substring(string5.indexOf("=") + 1);
            }
            if (!string5.startsWith("grou")) continue;
            string2 = string5.substring(string5.indexOf("=") + 1);
        }
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string4);
        stringBuffer.append(" ");
        stringBuffer.append(string3);
        return stringBuffer;
    }

    public StringBuffer decodeLWPRString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = "ala.";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("grou")) {
                string2 = string4.substring(string4.indexOf("=") + 1);
            }
            if (!string4.startsWith("type")) continue;
            String string5 = string4.substring(string4.indexOf("=") + 1);
            if (string5.startsWith("i")) {
                string3 = "ala.";
            }
            if (string5.startsWith("g")) {
                string3 = "alg.";
                continue;
            }
            if (string5.startsWith("p")) {
                string3 = "alm.";
                continue;
            }
            if (string5.startsWith("t")) {
                string3 = "alt.";
                continue;
            }
            if (string5.startsWith("n")) {
                string3 = "aln.";
                continue;
            }
            if (!string5.startsWith("s")) continue;
            string3 = "aln.";
        }
        stringBuffer.append(string3);
        stringBuffer.append(string2);
        return stringBuffer;
    }

    private StringBuffer decodeMDKSString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "max=1";
        String string6 = "";
        String string7 = "pos=0";
        String string8 = "trace=0";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith("grou")) {
                string3 = string2.substring(string2.indexOf("=") + 1);
                continue;
            }
            if (string2.startsWith("des")) {
                string4 = string2.substring(string2.indexOf("=") + 1);
                continue;
            }
            if (string2.startsWith("par")) {
                string11 = string2.substring(string2.indexOf("=") + 1);
                string10 = "parm=" + string11;
                if (this.debug) {
                    System.out.println("paramString = " + string10);
                }
                string13 = new String(this.decodePARAMString(string11));
                string13 = string13.toUpperCase();
                this.binaryData = string13.getBytes();
                continue;
            }
            if (string2.startsWith("select")) {
                string12 = string2.substring(string2.indexOf("=") + 1);
                string9 = "select=" + new String(this.decodeSELECTString(string12));
                if (!this.debug) continue;
                System.out.println("Server selectString = " + string9);
                continue;
            }
            if (string2.startsWith("num")) {
                string5 = "max=" + string2.substring(string2.indexOf("=") + 1);
                continue;
            }
            if (string2.startsWith("max")) {
                string5 = string2;
                continue;
            }
            if (string2.startsWith("tra")) {
                string8 = string2;
                continue;
            }
            if (!string2.startsWith("pos")) continue;
            string7 = string2;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string3 + " " + string4 + " " + string10 + " " + string9 + " " + string7 + " " + string8 + " " + string5);
        if (this.debug) {
            System.out.println("String passed to server = " + stringBuffer2);
        }
        try {
            stringBuffer.insert(0, (Object)stringBuffer2);
            if (this.debug) {
                System.out.println("buf = " + stringBuffer);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println(stringIndexOutOfBoundsException.toString());
            stringBuffer = new StringBuffer("");
        }
        return stringBuffer;
    }

    private String decodePARAMString(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "[]");
            string3 = new String(stringTokenizer2.nextToken().trim());
            stringBuffer.append(string3);
            int n = string3.length();
            while (n < 4) {
                stringBuffer.append(" ");
                ++n;
            }
            if (!stringTokenizer2.hasMoreTokens()) continue;
            string4 = stringTokenizer2.nextToken().trim();
            if (!this.debug) continue;
            System.out.println("This Unit = " + string4);
        }
        return stringBuffer.toString();
    }

    private String decodeSELECTString(String string) {
        Object var2_2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'");
        string2 = stringTokenizer.nextToken().trim();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ";");
        while (stringTokenizer2.hasMoreTokens()) {
            string3 = stringTokenizer2.nextToken().trim();
            if (this.debug) {
                System.out.println(" this Select = " + string3);
            }
            StringTokenizer stringTokenizer3 = new StringTokenizer(string3, " ");
            int n = stringTokenizer3.countTokens();
            string3 = new String(stringTokenizer3.nextToken());
            if (this.debug) {
                System.out.println("this Select = " + string3);
            }
            if (string3.indexOf("[") > 0) {
                StringTokenizer stringTokenizer4 = new StringTokenizer(string3, "[]");
                if (stringTokenizer4.hasMoreTokens()) {
                    string3 = new String(stringTokenizer4.nextToken().trim());
                    stringBuffer.append("'" + string3);
                    if (stringTokenizer4.hasMoreTokens()) {
                        string4 = new String(stringTokenizer4.nextToken().trim());
                    }
                }
            } else {
                stringBuffer.append("'" + string3);
            }
            if (stringTokenizer3.hasMoreTokens()) {
                string3 = stringTokenizer3.nextToken();
                if (this.debug) {
                    System.out.println("this Select = " + string3);
                }
                stringBuffer.append(" " + string3);
            }
            if (stringTokenizer3.hasMoreTokens()) {
                string3 = stringTokenizer3.nextToken();
                stringBuffer.append(" TO " + string3);
                if (this.debug) {
                    System.out.println("this Select = " + string3);
                }
            }
            if (string4 != null) {
                stringBuffer.append(" " + string4);
                string4 = null;
            }
            stringBuffer.append("' ");
        }
        return stringBuffer.toString();
    }

    private String ensureTwoValues(String string) {
        String string2 = null;
        if (string.trim().indexOf(" ") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() == 2) {
                string2 = string;
            }
        } else {
            string2 = new String(string + " " + string);
        }
        return string2;
    }

    private String adjustLongitudes(String string) {
        string = string.trim();
        String string2 = this.negateLongitude(string.substring(0, string.trim().indexOf(" ")).trim());
        String string3 = this.negateLongitude(string.substring(string.trim().indexOf(" ")).trim());
        return string3 + " " + string2;
    }

    private String negateLongitude(String string) {
        if (string.indexOf("-") >= 0) {
            return string.substring(string.indexOf("-") + 1);
        }
        return "-" + string;
    }

    AddeURLConnection(URL uRL) throws IOException {
        super(uRL);
        this.url = uRL;
        this.portToUse = uRL.getPort() == -1 ? 500 : uRL.getPort();
    }
}

