/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaDirectoryList;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.adde.ReadTextFile;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class AddeServerInfo {
    private String[] serverList;
    private String selectedServer = null;
    private boolean hasServers = false;
    private String dataType = null;
    private String[] bandNames;
    private boolean hasBandNames = false;
    private String[] groupsList;
    private String selectedGroup = null;
    private boolean hasGroup = false;
    private String[] datasetsList;
    private String selectedDataset = null;
    private boolean hasDataset = false;
    private AreaDirectory[][] dirs;
    private String[] dirsTimes;
    private Vector table;
    private Vector groups;
    private String status = "OK";
    private String userproj = null;
    private String DATEFORMAT = "yyyy-MM-dd / HH:mm:ss";
    private boolean debug = false;
    private boolean priv = false;

    public String[] getServerList() {
        if (this.hasServers) {
            return this.serverList;
        }
        return null;
    }

    public String getSelectedServer() {
        return this.selectedServer;
    }

    public int setSelectedServer(String string, String string2) {
        this.selectedServer = string.trim();
        int n = 0;
        this.dataType = string2.trim();
        this.groups = new Vector();
        this.status = "Failed to get PUBLIC.SRV file from from server " + string + ".";
        this.priv = false;
        try {
            int n2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5 = "adde://" + this.selectedServer + "/text?file=PUBLIC.SRV";
            if (this.userproj != null) {
                object5 = object4 = (String)object5 + "&" + this.userproj + "&version=1";
            }
            if (this.debug) {
                System.out.println("Req:" + (String)object5);
            }
            object4 = new ReadTextFile((String)object5);
            if (this.debug) {
                System.out.println("Status from RTF=" + ((ReadTextFile)object4).getStatus());
            }
            if (((ReadTextFile)object4).getStatusCode() == -3) {
                return -1;
            }
            if (!((ReadTextFile)object4).getStatus().equals("OK")) {
                object5 = "adde://" + this.selectedServer + "/text?file=RESOLV.SRV";
                if (this.userproj != null) {
                    object5 = object3 = (String)object5 + "&" + this.userproj + "&version=1";
                }
                if (this.debug) {
                    System.out.println("2ndReq:" + (String)object5);
                }
                this.priv = true;
                object4 = new ReadTextFile((String)object5);
                if (this.debug) {
                    System.out.println("Status from 2ndRTF=" + ((ReadTextFile)object4).getStatus());
                }
            }
            object3 = ((ReadTextFile)object4).getText();
            this.status = "Failed to locate required information on server " + string + ".";
            int n3 = 0;
            while (n3 < ((Vector)object3).size()) {
                object2 = (String)((Vector)object3).elementAt(n3);
                if (this.debug) {
                    System.out.println("table = " + (String)object2);
                }
                object = new StringTokenizer((String)object2, ",");
                n2 = ((StringTokenizer)object).countTokens();
                String[] stringArray = new String[n2];
                String[] stringArray2 = new String[n2];
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                int n7 = -1;
                int n8 = 0;
                while (n8 < n2) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    int n9 = string3.indexOf("=");
                    if (n9 >= 0) {
                        stringArray[n8] = string3.substring(0, n9);
                        stringArray2[n8] = string3.substring(n9 + 1).trim();
                        if (stringArray[n8].equalsIgnoreCase("type")) {
                            n4 = n8;
                        }
                        if (stringArray[n8].equalsIgnoreCase("N1")) {
                            n5 = n8;
                        }
                        if (stringArray[n8].equalsIgnoreCase("N2")) {
                            n6 = n8;
                        }
                        if (stringArray[n8].equalsIgnoreCase("C")) {
                            n7 = n8;
                        }
                    }
                    ++n8;
                }
                if (n4 >= 0 && stringArray2[n4].equalsIgnoreCase(this.dataType) && n5 >= 0 && n6 >= 0 && n7 >= 0) {
                    Object object6;
                    n8 = 0;
                    int n10 = 0;
                    while (n10 < this.groups.size()) {
                        Vector vector = (Vector)this.groups.elementAt(n10);
                        object6 = (String)vector.elementAt(0);
                        if (((String)object6).equalsIgnoreCase(stringArray2[n5])) {
                            n8 = 1;
                            Vector vector2 = (Vector)vector.elementAt(1);
                            vector2.addElement(stringArray2[n6]);
                            vector2 = (Vector)vector.elementAt(2);
                            vector2.addElement(stringArray2[n7]);
                        }
                        ++n10;
                    }
                    if (n8 == 0) {
                        Vector<Object> vector = new Vector<Object>();
                        vector.addElement(stringArray2[n5]);
                        Vector<String> vector3 = new Vector<String>();
                        vector3.addElement(stringArray2[n6]);
                        object6 = new Vector();
                        ((Vector)object6).addElement(stringArray2[n7]);
                        vector.addElement(vector3);
                        vector.addElement(object6);
                        this.groups.addElement(vector);
                    }
                }
                ++n3;
            }
            Object object7 = "adde://" + this.selectedServer + "/text?file=SATBAND";
            if (this.userproj != null) {
                object7 = object2 = (String)object7 + "&" + this.userproj + "&version=1";
            }
            if (this.debug) {
                System.out.println("ReqBand:" + (String)object7);
            }
            object2 = new ReadTextFile((String)object7);
            if (this.debug) {
                System.out.println("Status from RTFBand=" + ((ReadTextFile)object2).getStatus());
            }
            object = null;
            if (((ReadTextFile)object2).getStatus().equals("OK")) {
                object = ((ReadTextFile)object2).getText();
                n2 = ((Vector)object).size();
                this.bandNames = new String[n2];
                int n11 = 0;
                while (n11 < n2) {
                    this.bandNames[n11] = (String)((Vector)object).elementAt(n11);
                    if (this.debug) {
                        System.out.println("band = " + this.bandNames[n11]);
                    }
                    ++n11;
                }
                this.hasBandNames = true;
            }
            this.status = "ADDE group & dataset information retrieved from server " + string + ".";
            n = 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -2;
        }
        return n;
    }

    public String[] getGroupList() {
        if (this.priv) {
            return null;
        }
        int n = this.groups.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Vector vector = (Vector)this.groups.elementAt(n2);
            stringArray[n2] = (String)vector.elementAt(0);
            ++n2;
        }
        this.status = "List of groups on server " + this.selectedServer + " obtained.";
        return stringArray;
    }

    public String[] getDatasetList() {
        int n = this.groups.size();
        int n2 = 0;
        while (n2 < n) {
            Vector vector = (Vector)this.groups.elementAt(n2);
            String string = (String)vector.elementAt(0);
            if (string.equalsIgnoreCase(this.selectedGroup)) {
                Vector vector2 = (Vector)vector.elementAt(1);
                int n3 = vector2.size();
                String[] stringArray = new String[n3];
                int n4 = 0;
                while (n4 < n3) {
                    stringArray[n4] = (String)vector2.elementAt(n4);
                    ++n4;
                }
                this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " obtained.";
                return stringArray;
            }
            ++n2;
        }
        this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " not found.";
        return null;
    }

    public String[] getDatasetListDescriptions() {
        int n = this.groups.size();
        int n2 = 0;
        while (n2 < n) {
            Vector vector = (Vector)this.groups.elementAt(n2);
            String string = (String)vector.elementAt(0);
            if (string.equalsIgnoreCase(this.selectedGroup)) {
                Vector vector2 = (Vector)vector.elementAt(2);
                int n3 = vector2.size();
                String[] stringArray = new String[n3];
                int n4 = 0;
                while (n4 < n3) {
                    stringArray[n4] = (String)vector2.elementAt(n4);
                    ++n4;
                }
                this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " obtained.";
                return stringArray;
            }
            ++n2;
        }
        this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " not found.";
        return null;
    }

    public String[] getDateTimeList() {
        this.status = "Trying to get date-times for " + this.selectedGroup + " from server " + this.selectedServer;
        if (!this.hasGroup || !this.hasDataset) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("adde://" + this.selectedServer + "/imagedir?group=" + this.selectedGroup);
        stringBuffer.append("&descr=");
        stringBuffer.append(this.selectedDataset);
        if (this.userproj != null) {
            stringBuffer.append("&" + this.userproj);
        }
        stringBuffer.append("&pos=all&version=1");
        if (this.debug) {
            System.out.println("cmd:" + stringBuffer.toString());
        }
        String[] stringArray = new String[]{"No data available"};
        try {
            AreaDirectoryList areaDirectoryList = new AreaDirectoryList(stringBuffer.toString());
            this.dirs = areaDirectoryList.getSortedDirs();
            int n = this.dirs.length;
            stringArray = new String[n];
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            simpleDateFormat.applyPattern(this.DATEFORMAT);
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = simpleDateFormat.format(this.dirs[n2][0].getNominalTime(), new StringBuffer(), new FieldPosition(0)).toString();
                ++n2;
            }
            this.dirsTimes = stringArray;
        }
        catch (McIDASException mcIDASException) {
            this.status = "Error getting times";
        }
        return stringArray;
    }

    public AreaDirectory[][] getAreaDirectories() {
        return this.dirs;
    }

    public void setSelectedGroup(String string) {
        this.selectedGroup = string;
        this.hasGroup = true;
    }

    public void setSelectedDataset(String string) {
        this.selectedDataset = string;
        this.hasDataset = true;
    }

    public String[] getBandNames() {
        if (this.hasBandNames) {
            return this.bandNames;
        }
        return null;
    }

    public String getRequestString(int n) {
        return null;
    }

    public void setUserIDandProjString(String string) {
        this.userproj = string;
    }

    public String getStatus() {
        return this.status;
    }

    public static void main(String[] stringArray) {
        AddeServerInfo addeServerInfo = new AddeServerInfo();
        int n = addeServerInfo.setSelectedServer("suomi.ssec.wisc.edu", "image");
        System.out.println("Status = " + addeServerInfo.getStatus() + "  code=" + n);
        String[] stringArray2 = addeServerInfo.getGroupList();
        System.out.println("Status = " + addeServerInfo.getStatus());
        int n2 = 0;
        while (n2 < stringArray2.length) {
            System.out.println("group = " + stringArray2[n2]);
            addeServerInfo.setSelectedGroup(stringArray2[n2]);
            String[] stringArray3 = addeServerInfo.getDatasetList();
            String[] stringArray4 = addeServerInfo.getDatasetListDescriptions();
            int n3 = 0;
            while (n3 < stringArray3.length) {
                System.out.println("    " + stringArray3[n3] + " == " + stringArray4[n3]);
                if (n2 == 0 && n3 == 0) {
                    addeServerInfo.setSelectedDataset(stringArray3[n3]);
                    String[] stringArray5 = addeServerInfo.getDateTimeList();
                    int n4 = 0;
                    while (n4 < stringArray5.length) {
                        System.out.println("DateTime = " + stringArray5[n4]);
                        ++n4;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        System.out.println("Status = " + addeServerInfo.getStatus());
    }

    public AddeServerInfo() {
        this(null);
    }

    public AddeServerInfo(String[] stringArray) {
        String[] stringArray2 = stringArray;
        if (stringArray2 == null) {
            stringArray2 = new String[]{"adde.unidata.ucar.edu", "suomi.ssec.wisc.edu", "motherlode.ucar.edu", "uwamrc.ssec.wisc.edu"};
        }
        this.serverList = new String[stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            this.serverList[n] = stringArray2[n];
            ++n;
        }
        this.hasServers = true;
    }
}

