/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeException;
import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class AddePointDataReader {
    private int status = 0;
    private URLConnection urlc;
    private String[] params;
    private int[] ScalingFactors;
    private String[] units;
    private int[][] iData;
    private int numParams = 0;
    private boolean debug = false;

    public int[][] getData() throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return this.iData;
    }

    public String[] getParams() throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return this.params;
    }

    public String[] getUnits() throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return this.units;
    }

    public int[] getScales() throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return this.ScalingFactors;
    }

    public int getNumParams() throws AddeException {
        if (this.status < 0) {
            throw new AddeException("No data available");
        }
        return this.numParams;
    }

    public String toString() {
        if (this.status < 0) {
            return new String("No data Available");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.numParams) {
            stringBuffer.append(this.params[n]);
            stringBuffer.append("[");
            stringBuffer.append(this.units[n]);
            stringBuffer.append("] ");
            stringBuffer.append("\t");
            ++n;
        }
        stringBuffer.append("\n");
        n = 0;
        while (n < this.iData[0].length) {
            int n2 = 0;
            while (n2 < this.numParams) {
                if (this.units[n2].equalsIgnoreCase("CHAR")) {
                    stringBuffer.append(McIDASUtil.intBitsToString(this.iData[n2][n]));
                } else if (this.ScalingFactors[n2] != 0) {
                    stringBuffer.append(this.iData[n2][n] == -2139062144 ? "     " : Double.toString((double)this.iData[n2][n] / Math.pow(10.0, this.ScalingFactors[n2])));
                } else {
                    stringBuffer.append(this.iData[n2][n] == -2139062144 ? "     " : Integer.toString(this.iData[n2][n]));
                }
                stringBuffer.append("\t");
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("\nData Requested:");
        String string = stringArray.length == 0 ? "adde://adde.unidata.ucar.edu/point?group=rtptsrc&descr=sfchourly&num=2&select='id ypph'&parm=id dir spd t[c] td[c] psl&pos=0&version=1&trace=1" : stringArray[0];
        AddePointDataReader addePointDataReader = new AddePointDataReader(string);
        System.out.println(addePointDataReader.toString());
    }

    public AddePointDataReader(String string) throws AddeException {
        int n;
        Object object;
        DataInputStream dataInputStream;
        URLConnection uRLConnection;
        try {
            URL uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            dataInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
        }
        catch (AddeURLException addeURLException) {
            throw new AddeException("No datasets found " + addeURLException);
        }
        catch (Exception exception) {
            throw new AddeException("Error opening connection: " + exception);
        }
        int n2 = ((AddeURLConnection)uRLConnection).getInitialRecordSize();
        if (this.debug) {
            System.out.println("numParamBytes = " + n2);
        }
        if (n2 == 0) {
            this.status = -1;
            throw new AddeException("No data found");
        }
        byte[] byArray = new byte[n2];
        this.numParams = n2 / 4;
        this.params = new String[this.numParams];
        try {
            dataInputStream.readFully(byArray, 0, n2);
            object = new String(byArray);
            if (this.debug) {
                System.out.println(" sParamNames = " + (String)object);
            }
            int n3 = 0;
            while (n3 < this.numParams) {
                this.params[n3] = ((String)object).substring(n3 * 4, (n3 + 1) * 4).trim();
                ++n3;
            }
        }
        catch (IOException iOException) {
            this.status = -1;
            throw new AddeException("Error reading parameters:" + iOException);
        }
        try {
            n = dataInputStream.readInt();
            this.units = new String[n / 4];
            if (this.debug) {
                System.out.println("numUnitBytes = " + n);
            }
            object = new byte[n];
            dataInputStream.readFully((byte[])object, 0, n);
            String string2 = new String((byte[])object);
            if (this.debug) {
                System.out.println("sUnitNames = " + string2);
            }
            int n4 = 0;
            while (n4 < n / 4) {
                this.units[n4] = string2.substring(n4 * 4, (n4 + 1) * 4).trim();
                ++n4;
            }
        }
        catch (IOException iOException) {
            this.status = -1;
            throw new AddeException("Error reading units:" + iOException);
        }
        try {
            n = dataInputStream.readInt();
            if (this.debug) {
                System.out.println("numScalingBytes = " + n);
            }
            this.ScalingFactors = new int[n / 4];
            int n5 = 0;
            while (n5 < n / 4) {
                this.ScalingFactors[n5] = dataInputStream.readInt();
                ++n5;
            }
        }
        catch (IOException iOException) {
            this.status = -1;
            throw new AddeException("Error reading scaling factors:" + iOException);
        }
        Vector<int[]> vector = new Vector<int[]>();
        byte[] byArray2 = new byte[4];
        try {
            int n6 = dataInputStream.readInt();
            while (n6 != 0) {
                if (this.debug) {
                    System.out.println(" i, Param, Unit, Value ");
                }
                int[] nArray = new int[this.numParams];
                int n7 = 0;
                while (n7 < n6 / 4) {
                    nArray[n7] = dataInputStream.readInt();
                    ++n7;
                }
                vector.addElement(nArray);
                n6 = dataInputStream.readInt();
                if (!this.debug) continue;
                System.out.println("numDataBytes = " + n6);
            }
            this.iData = new int[this.numParams][vector.size()];
            if (this.debug) {
                System.out.println("number of data records = " + vector.size());
            }
            int n8 = 0;
            while (n8 < vector.size()) {
                int[] nArray = (int[])vector.get(n8);
                int n9 = 0;
                while (n9 < this.numParams) {
                    this.iData[n9][n8] = nArray[n9];
                    ++n9;
                }
                ++n8;
            }
        }
        catch (IOException iOException) {
            this.status = -1;
            throw new AddeException("Error reading data:" + iOException);
        }
    }

    static {
        try {
            String string = System.getProperty("java.protocol.handler.pkgs");
            String string2 = null;
            if (string == null) {
                string2 = "edu.wisc.ssec.mcidas";
            } else if (string.indexOf("edu.wisc.ssec.mcidas") < 0) {
                string2 = "edu.wisc.ssec.mcidas | " + string;
            }
            if (string2 != null) {
                System.setProperty("java.protocol.handler.pkgs", string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

