/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import visad.CoordinateSystem;
import visad.data.mcidas.McIDASGridDirectory;

public class AddeGridReader {
    private DataInputStream dis;
    private int status = 0;
    private URLConnection urlc;
    private char[] data;
    private final int HEARTBEAT;
    ArrayList fileHeaders;
    ArrayList gridHeaders;
    ArrayList gridData;

    public ArrayList getGridDirectory(String string) throws AddeURLException {
        this.gridHeaders = new ArrayList();
        this.fileHeaders = new ArrayList();
        try {
            URL uRL = new URL(string);
            this.urlc = uRL.openConnection();
            InputStream inputStream = this.urlc.getInputStream();
            this.dis = new DataInputStream(new BufferedInputStream(inputStream));
        }
        catch (AddeURLException addeURLException) {
            throw new AddeURLException("Dataset not found: " + addeURLException);
        }
        catch (Exception exception) {
            throw new AddeURLException("Error opening connection: " + exception);
        }
        int n = ((AddeURLConnection)this.urlc).getInitialRecordSize();
        if (n == 0) {
            this.status = -1;
            throw new AddeURLException("No datasets found");
        }
        try {
            int n2;
            byte[] byArray = new byte[256];
            while (n == 4) {
                n2 = this.dis.readInt();
                if (n2 != 11223344) {
                    System.out.println("problem...not heartbeat = " + n2);
                }
                n = this.dis.readInt();
            }
            while ((n2 = this.dis.readInt()) == 0) {
                int n3;
                this.dis.readFully(byArray, 0, 256);
                String string2 = new String(byArray, 0, 32);
                this.fileHeaders.add(string2);
                while ((n3 = this.dis.readInt()) == 0) {
                    this.dis.readFully(byArray, 0, 256);
                    String string3 = new String(byArray, 24, 4);
                    McIDASGridDirectory mcIDASGridDirectory = new McIDASGridDirectory(byArray);
                    this.gridHeaders.add(mcIDASGridDirectory);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return this.gridHeaders;
    }

    public ArrayList getGridHeaders() {
        return this.gridHeaders;
    }

    public ArrayList getFileHeaders() {
        return this.fileHeaders;
    }

    public ArrayList getGridData(String string) throws AddeURLException {
        this.gridHeaders = new ArrayList();
        this.gridData = new ArrayList();
        try {
            URL uRL = new URL(string);
            this.urlc = uRL.openConnection();
            InputStream inputStream = this.urlc.getInputStream();
            this.dis = new DataInputStream(new BufferedInputStream(inputStream));
        }
        catch (AddeURLException addeURLException) {
            throw new AddeURLException("Dataset not found: " + addeURLException);
        }
        catch (Exception exception) {
            throw new AddeURLException("Error opening connection: " + exception);
        }
        int n = ((AddeURLConnection)this.urlc).getInitialRecordSize();
        if (n == 0) {
            this.status = -1;
            throw new AddeURLException("No datasets found");
        }
        try {
            int n2;
            byte[] byArray = new byte[256];
            while (n == 4) {
                n2 = this.dis.readInt();
                if (n2 != 11223344) {
                    System.out.println("problem...not heartbeat = " + n2);
                }
                n = this.dis.readInt();
            }
            int n3 = this.dis.readInt();
            if (n3 != n) {
                throw new AddeURLException("Invalid number of bytes returned for grid.");
            }
            int n4 = this.dis.readInt();
            int n5 = 0;
            while (n5 < n4) {
                this.dis.readFully(byArray, 0, 256);
                String string2 = new String(byArray, 24, 4);
                McIDASGridDirectory mcIDASGridDirectory = new McIDASGridDirectory(byArray);
                System.out.println(mcIDASGridDirectory.toString());
                CoordinateSystem coordinateSystem = mcIDASGridDirectory.getCoordinateSystem();
                this.gridHeaders.add(mcIDASGridDirectory);
                int n6 = mcIDASGridDirectory.getRows();
                int n7 = mcIDASGridDirectory.getColumns();
                double d = mcIDASGridDirectory.getParamScale();
                double[] dArray = new double[n6 * n7];
                boolean bl = false;
                int n8 = 0;
                while (n8 < n7) {
                    int n9 = 0;
                    while (n9 < n6) {
                        int n10 = this.dis.readInt();
                        dArray[(n6 - n9 - 1) * n7 + n8] = n10 == -2139062144 ? Double.NaN : (double)n10 / d;
                        ++n9;
                    }
                    ++n8;
                }
                this.gridData.add(dArray);
                n2 = this.dis.readInt();
                if (n2 == 0) {
                    ++n5;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return this.gridData;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length == 0 ? "adde://sweetpea.ssec.wisc.edu/grid?group=ABOM&descr=GRIDS&pos=302&num=40&lev=500&proj=6999&user=tomw&" : stringArray[0];
        AddeGridReader addeGridReader = new AddeGridReader();
        ArrayList arrayList = addeGridReader.getGridData(string);
        ArrayList arrayList2 = addeGridReader.getGridHeaders();
    }

    public AddeGridReader() {
        this.HEARTBEAT = 11223344;
    }

    static {
        try {
            String string = System.getProperty("java.protocol.handler.pkgs");
            String string2 = null;
            if (string == null) {
                string2 = "edu.wisc.ssec.mcidas";
            } else if (string.indexOf("edu.wisc.ssec.mcidas") < 0) {
                string2 = "edu.wisc.ssec.mcidas | " + string;
            }
            if (string2 != null) {
                System.setProperty("java.protocol.handler.pkgs", string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

