/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;

public final class TANCnav
extends AREAnav {
    private static double Erad = 6371.2;
    private boolean isEastPositive = true;
    int iwest;
    int ihem;
    double lin0;
    double ele0;
    double scale;
    double lon0;
    double lat0;
    double coscl;
    double tancl;
    double tancl2;
    double mxtheta;

    public double[][] toLatLon(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = dArray3[1][n2] - this.lin0;
            double d6 = dArray3[0][n2] - this.ele0;
            if (Math.abs(d5) < 0.01 && Math.abs(d6) < 0.01) {
                d4 = 0.0;
                d3 = 0.0;
            } else {
                d2 = this.scale * d5;
                d = this.scale * d6;
                d4 = Math.sqrt(d2 * d2 + d * d);
                d3 = Math.atan2(d, d2);
            }
            d2 = this.lat0 < 0.0 ? (d3 <= 0.0 ? Math.PI - Math.abs(d3) : -1.0 * (Math.PI - Math.abs(d3))) : d3;
            if (d2 <= -this.mxtheta || d2 > this.mxtheta) {
                dArray2[0][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
            } else {
                double d7 = this.lon0 + d2 / this.coscl;
                if (d7 <= -Math.PI) {
                    d7 += Math.PI * 2;
                }
                if (d7 > Math.PI) {
                    d7 -= Math.PI * 2;
                }
                d = 2.0 * Math.atan(this.tancl2 * Math.pow(d4 / (Erad * this.tancl), 1.0 / this.coscl));
                double d8 = 90.0 - d / (Math.PI / 180);
                dArray2[0][n2] = this.lat0 < 0.0 ? -1.0 * d8 : d8;
                dArray2[1][n2] = d7 /= Math.PI / 180;
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] toLinEle(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[0][n2];
            double d2 = dArray[1][n2];
            if (d <= -90.0 || d >= 90.0 || d2 <= -360.0 || d2 > 360.0) {
                dArray2[1][n2] = Double.NaN;
                dArray2[0][n2] = Double.NaN;
            } else {
                double d3 = d < 0.0 ? 1.5707963267948966 + Math.PI / 180 * d : 1.5707963267948966 - Math.PI / 180 * d;
                double d4 = Math.PI / 180 * d2;
                if (d4 <= -Math.PI) {
                    d4 += Math.PI * 2;
                }
                if (d4 > Math.PI) {
                    d4 -= Math.PI * 2;
                }
                if (d3 == Math.PI) {
                    dArray2[1][n2] = Double.NaN;
                    dArray2[0][n2] = Double.NaN;
                } else {
                    double d5 = Erad * this.tancl * Math.pow(Math.tan(d3 / 2.0) / this.tancl2, this.coscl);
                    double d6 = d4 - this.lon0;
                    if (d6 <= -Math.PI) {
                        d6 += Math.PI * 2;
                    }
                    if (d6 > Math.PI) {
                        d6 -= Math.PI * 2;
                    }
                    d6 = this.coscl * d6;
                    if (this.lat0 < 0.0) {
                        d6 = Math.PI + d6;
                    }
                    dArray2[1][n2] = this.lin0 + d5 * Math.cos(d6) / this.scale;
                    dArray2[0][n2] = this.ele0 + d5 * Math.sin(d6) / this.scale;
                }
            }
            ++n2;
        }
        return this.imageCoordToAreaCoord(dArray2);
    }

    public TANCnav(int[] nArray) throws IllegalArgumentException {
        if (nArray[0] != 1413566019) {
            throw new IllegalArgumentException("Invalid navigation type" + nArray[0]);
        }
        this.lin0 = (double)nArray[1] / 10000.0;
        this.ele0 = (double)nArray[2] / 10000.0;
        this.scale = (double)nArray[3] / 10000.0;
        this.lat0 = (double)nArray[4] / 10000.0;
        this.lon0 = (double)nArray[5] / 10000.0;
        if (this.scale <= 0.0 || this.lat0 <= -90.0 || this.lat0 >= 90.0 || this.lat0 == 0.0 || this.lon0 <= -180.0 || this.lon0 >= 180.0) {
            throw new IllegalArgumentException("Invalid nav parameters");
        }
        this.lon0 = -this.lon0 * (Math.PI / 180);
        double d = this.lat0 < 0.0 ? 1.5707963267948966 + this.lat0 * (Math.PI / 180) : 1.5707963267948966 - this.lat0 * (Math.PI / 180);
        this.coscl = Math.cos(d);
        this.tancl = Math.tan(d);
        this.tancl2 = Math.tan(d / 2.0);
        this.mxtheta = Math.PI * this.coscl;
    }
}

