/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;

public final class RECTnav
extends AREAnav {
    private boolean isEastPositive = true;
    int itype;
    int iwest;
    double xrow;
    double xcol;
    double zslat;
    double zslon;
    double zdlat;
    double zdlon;
    double xlin;
    double xele;
    double xldif;
    double xedif;
    double xlat;
    double xlon;

    public double[][] toLatLon(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n2 = 0;
        while (n2 < n) {
            double d = this.xrow - dArray3[1][n2];
            double d2 = (double)this.iwest * (this.xcol - dArray3[0][n2]);
            double d3 = this.zslon + d2 * this.zdlon;
            double d4 = this.zslat + d * this.zdlat;
            if (d4 > 90.0 || d4 < -90.0) {
                d4 = Double.NaN;
            }
            if (d3 < -180.0 && (d3 += 360.0) < -180.0) {
                d3 = Double.NaN;
            }
            if (d3 > 180.0 && d3 != Double.NaN && (d3 -= 360.0) > 180.0) {
                d3 = Double.NaN;
            }
            if (d4 == Double.NaN || d3 == Double.NaN) {
                dArray2[0][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
            } else {
                dArray2[0][n2] = d4;
                dArray2[1][n2] = this.iwest == 1 ? -d3 : d3;
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] toLinEle(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2 = dArray[0][n2];
            double d3 = d = this.iwest == 1 ? -dArray[1][n2] : dArray[1][n2];
            if (this.iwest == -1 && d < this.zslon) {
                d += 360.0;
            }
            dArray2[1][n2] = this.xrow - (d2 - this.zslat) / this.zdlat;
            dArray2[0][n2] = this.xcol - (d - this.zslon) / (this.zdlon * (double)this.iwest);
            ++n2;
        }
        return this.imageCoordToAreaCoord(dArray2);
    }

    public RECTnav(int[] nArray) throws IllegalArgumentException {
        if (nArray[0] != 1380270932) {
            throw new IllegalArgumentException("Invalid navigation type" + nArray[0]);
        }
        this.itype = 2;
        this.xrow = nArray[1];
        int n = nArray[11];
        if (n == 0) {
            n = 4;
        }
        this.zslat = (double)nArray[2] / Math.pow(10.0, n);
        this.xcol = nArray[3];
        int n2 = nArray[12];
        if (n2 == 0) {
            n2 = 4;
        }
        this.zslon = (double)nArray[4] / Math.pow(10.0, n2);
        int n3 = nArray[13];
        if (n3 == 0) {
            n3 = 4;
        }
        this.zdlat = (double)nArray[5] / Math.pow(10.0, n3);
        int n4 = nArray[14];
        if (n4 == 0) {
            n4 = 4;
        }
        this.zdlon = (double)nArray[6] / Math.pow(10.0, n4);
        int n5 = nArray[15];
        if (n5 == 0) {
            n5 = 3;
        }
        double d = (double)nArray[7] / Math.pow(10.0, n5);
        int n6 = nArray[16];
        if (n6 == 0) {
            n6 = 6;
        }
        double d2 = (double)nArray[8] / Math.pow(10.0, n6);
        int n7 = this.iwest = nArray[10] >= 0 ? 1 : -1;
        if (this.iwest == 1) {
            this.isEastPositive = false;
        }
        this.xlin = 1.0;
        this.xele = 1.0;
        this.xldif = this.xrow - this.xlin;
        this.xedif = (double)this.iwest * (this.xcol - this.xele);
        this.xlon = this.zslon + this.xedif * this.zdlon;
        this.zslat = this.xlat = this.zslat + this.xldif * this.zdlat;
        this.zslon = this.xlon;
        this.xrow = 1.0;
        this.xcol = 1.0;
    }
}

