/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class RADRnav
extends AREAnav {
    private boolean isEastPositive = true;
    final double EARTH_RADIUS;
    final int MISS;
    int itype;
    double xrow;
    double xcol;
    double xlat;
    double xlon;
    double xrot;
    double xblat;
    double xblon;

    public double[][] toLatLon(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n2 = 0;
        while (n2 < n) {
            double d = this.xrow - dArray3[1][n2];
            double d2 = this.xcol - dArray3[0][n2];
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (d3 > 0.001) {
                double d4 = Math.atan2(d, d2) - 1.5707963267948966;
                double d5 = Math.atan2(d, d2) + 1.5707963267948966;
                d = d3 * Math.cos(this.xrot + d4);
                d2 = d3 * Math.sin(this.xrot + d5);
            }
            double d6 = this.xlat + d / this.xblat;
            double d7 = this.xlon + d2 / this.xblon / Math.cos(d6 * (Math.PI / 180));
            if (this.isEastPositive) {
                d7 = -d7;
            }
            dArray2[0][n2] = d6;
            dArray2[1][n2] = d7;
            ++n2;
        }
        return dArray2;
    }

    public double[][] toLinEle(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[0][n2];
            double d2 = d - this.xlat;
            double d3 = this.xblat * d2;
            double d4 = this.isEastPositive ? -dArray[1][n2] : dArray[1][n2];
            double d5 = d4 - this.xlon;
            double d6 = d5 * this.xblon * Math.cos(d * (Math.PI / 180));
            double d7 = Math.sqrt(d3 * d3 + d6 * d6);
            if (d7 > 0.001) {
                double d8 = Math.atan2(d3, d6) - 1.5707963267948966;
                double d9 = Math.atan2(d3, d6) + 1.5707963267948966;
                d3 = d7 * Math.cos(-this.xrot + d8);
                d6 = d7 * Math.sin(-this.xrot + d9);
            }
            dArray2[1][n2] = this.xrow - d3;
            dArray2[0][n2] = this.xcol - d6;
            ++n2;
        }
        return this.imageCoordToAreaCoord(dArray2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RADRnav)) {
            return false;
        }
        RADRnav rADRnav = (RADRnav)object;
        return super.equals(object) && rADRnav.xlat == this.xlat && rADRnav.xlon == this.xlon && rADRnav.xrow == this.xrow && rADRnav.xcol == this.xcol;
    }

    public RADRnav(int[] nArray) throws IllegalArgumentException {
        double d;
        this.EARTH_RADIUS = 6371.23;
        this.MISS = -2139062144;
        if (nArray[0] != 1380009042) {
            throw new IllegalArgumentException("Invalid navigation type" + nArray[0]);
        }
        this.itype = 2;
        this.xrow = nArray[1];
        this.xcol = nArray[2];
        this.xlat = McIDASUtil.integerLatLonToDouble(nArray[3]);
        this.xlon = McIDASUtil.integerLatLonToDouble(nArray[4]);
        double d2 = d = (double)nArray[5] / 1000.0;
        if (nArray[7] != 0 && nArray[7] != -2139062144) {
            d2 = (double)nArray[7] / 1000.0;
        }
        this.xrot = -Math.PI / 180 * (double)nArray[6] / 1000.0;
        this.xblat = 111.19894090183831 / d;
        this.xblon = 111.19894090183831 / d2;
    }
}

