/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class PSnav
extends AREAnav {
    private boolean isEastPositive = true;
    int iwest;
    int ihem;
    double xrow;
    double xcol;
    double xpole;
    double xlat1;
    double xspace;
    double xqlon;
    double xblat;
    double fac;

    public double[][] toLatLon(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2;
            double d3 = (double)this.ihem * (dArray3[1][n2] - this.xrow) / this.xblat;
            double d4 = (this.xcol - dArray3[0][n2]) / this.xblat;
            double d5 = 0.0;
            if (d3 != 0.0 || d4 != 0.0) {
                d5 = Math.atan2(d4, d3);
            }
            if ((d2 = (double)this.iwest * d5 / (Math.PI / 180) + this.xqlon) > 180.0) {
                d2 -= 360.0;
            }
            if (d2 < -180.0) {
                d2 += 360.0;
            }
            double d6 = Math.abs(d = Math.sqrt(d3 * d3 + d4 * d4)) < 1.0E-10 ? (double)(this.ihem * 90) : (double)this.ihem * (90.0 - 2.0 * Math.atan(Math.exp(Math.log(d / this.fac))) / (Math.PI / 180));
            dArray2[0][n2] = d6;
            dArray2[1][n2] = this.iwest == 1 ? -d2 : d2;
            ++n2;
        }
        return dArray2;
    }

    public double[][] toLinEle(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[0][n2];
            double d2 = this.iwest == 1 ? -dArray[1][n2] : dArray[1][n2];
            double d3 = (double)this.ihem * (d2 - this.xqlon);
            if (d3 > 180.0) {
                d3 -= 360.0;
            }
            if (d3 < -180.0) {
                d3 += 360.0;
            }
            d3 = (double)this.iwest * d3 * (Math.PI / 180);
            double d4 = (this.xpole - d) * (Math.PI / 180) * 0.5;
            double d5 = this.xblat * Math.tan(d4);
            dArray2[1][n2] = d5 * Math.cos(d3) + this.xrow;
            dArray2[0][n2] = -d5 * Math.sin(d3) + this.xcol;
            ++n2;
        }
        return this.imageCoordToAreaCoord(dArray2);
    }

    public PSnav(int[] nArray) throws IllegalArgumentException {
        if (nArray[0] != 1347624992) {
            throw new IllegalArgumentException("Invalid navigation type" + nArray[0]);
        }
        this.xrow = nArray[1];
        this.xcol = nArray[2];
        int n = nArray[10];
        if (n == 0) {
            n = 900000;
        }
        this.ihem = 1;
        if (n < 0) {
            this.ihem = -1;
        }
        this.xpole = McIDASUtil.integerLatLonToDouble(n);
        this.xlat1 = McIDASUtil.integerLatLonToDouble(n - nArray[3]) * (Math.PI / 180);
        this.xspace = (double)nArray[4] / 1000.0;
        this.xqlon = McIDASUtil.integerLatLonToDouble(nArray[5]);
        double d = (double)nArray[6] / 1000.0;
        this.iwest = nArray[9];
        if (this.iwest >= 0) {
            this.iwest = 1;
        }
        this.xblat = d * Math.sin(this.xlat1) / (this.xspace * Math.tan(this.xlat1 * 0.5));
        this.fac = 1.0;
    }
}

