/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class McIDASUtil {
    public static final int MCMISSING = -2139062144;

    public static double integerLatLonToDouble(int n) {
        return McIDASUtil.mcPackedIntegerToDouble(n);
    }

    public static int doubleLatLonToInteger(double d) {
        return McIDASUtil.mcDoubleToPackedInteger(d);
    }

    public static double mcPackedIntegerToDouble(int n) {
        int n2 = n < 0 ? -n : n;
        double d = (double)(n2 / 10000) + (double)(n2 / 100 % 100) / 60.0 + (double)(n2 % 100) / 3600.0;
        return n < 0 ? -d : d;
    }

    public static int mcDoubleToPackedInteger(double d) {
        double d2 = d < 0.0 ? -d : d;
        int n = (int)(3600.0 * d2 + 0.5);
        int n2 = 10000 * (n / 3600) + 100 * (n / 60 % 60) + n % 60;
        return d < 0.0 ? -n2 : n2;
    }

    public static double timdif(int n, int n2, int n3, int n4) {
        long l = McIDASUtil.mcDayTimeToSecs(n, n2);
        long l2 = McIDASUtil.mcDayTimeToSecs(n3, n4);
        return (double)(l2 - l) / 60.0;
    }

    public static long mcDayTimeToSecs(int n, int n2) {
        int n3 = n / 1000 % 1900 + 1900;
        int n4 = n % 1000;
        double d = McIDASUtil.mcPackedIntegerToDouble(n2) * 3600.0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.set(0, 1);
        gregorianCalendar.set(1, n3);
        gregorianCalendar.setLenient(true);
        gregorianCalendar.set(6, n4);
        int n5 = (int)Math.round(d * 1000.0) / 1000;
        gregorianCalendar.set(13, n5);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime().getTime() / 1000L;
    }

    public static int[] mcSecsToDayTime(long l) {
        int[] nArray = new int[2];
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTime(new Date(l * 1000L));
        nArray[0] = gregorianCalendar.get(Calendar.YEAR) * 1000 + gregorianCalendar.get(Calendar.DAY_OF_YEAR);
        nArray[1] = gregorianCalendar.get(Calendar.HOUR_OF_DAY) * 10000 + gregorianCalendar.get(Calendar.MINUTE) * 100 + gregorianCalendar.get(Calendar.SECOND);
        return nArray;
    }

    public static void flip(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            int n4 = nArray[n3];
            nArray[n3] = n4 >>> 24 & 0xFF | n4 >>> 8 & 0xFF00 | (n4 & 0xFF) << 24 | (n4 & 0xFF00) << 8;
            ++n3;
        }
    }

    public static int bytesToInteger(byte[] byArray, int n) {
        int n2 = (byArray[n] << 24) + (byArray[n + 1] << 16 & 0xFF0000) + (byArray[n + 2] << 8 & 0xFF00) + (byArray[n + 3] & 0xFF);
        return n2;
    }

    public static int[] bytesToIntegerArray(byte[] byArray, int n, int n2) {
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, n3 * 4, byArray2, 0, 4);
            nArray[n3] = McIDASUtil.bytesToInteger(byArray2, 0);
            ++n3;
        }
        return nArray;
    }

    public static String intBitsToString(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >>> 24), (byte)((n & 0xFF0000) >>> 16), (byte)((n & 0xFF00) >>> 8), (byte)(n & 0xFF)};
        return new String(byArray);
    }

    public static String intBitsToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(McIDASUtil.intBitsToString(nArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isChar(int n) {
        String string = McIDASUtil.intBitsToString(n);
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < 4) {
            if (!Character.UnicodeBlock.of(cArray[n2]).equals(Character.UnicodeBlock.BASIC_LATIN) || Character.isISOControl(cArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

