/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class MSATnav
extends AREAnav {
    private boolean isEastPositive = true;
    final double NOMORB;
    final double EARTH_RADIUS;
    int itype;
    double h;
    double a;
    double rp;
    double lpsi2;
    double deltax;
    double deltay;
    double rflon;
    double sublon;
    int[] ioff = new int[3];

    public double[][] toLatLon(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2;
            double d3;
            double d4 = dArray3[1][n2];
            double d5 = dArray3[0][n2];
            double d6 = d5 / 2.0;
            double d7 = d4 / 2.0;
            double d8 = 1250.5 - d6;
            double d9 = (double)this.ioff[2] - (d7 + (double)this.ioff[1] - (double)this.ioff[0]);
            double d10 = d8;
            double d11 = d9;
            d8 = d10 * this.lpsi2 * this.deltax * (Math.PI / 180);
            d9 = d11 * this.lpsi2 * this.deltay * (Math.PI / 180);
            double d12 = 6378.155 + this.h;
            double d13 = Math.tan(d8);
            double d14 = 1.0 + d13 * d13;
            if (d14 * (d3 = 1.0 + (d2 = Math.tan(d9)) * d2 * ((1.0 + this.a) * (1.0 + this.a))) > (d = d12 / 6378.155) * d / (d * d - 1.0)) {
                dArray2[0][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
            } else {
                double d15 = (d12 - 6378.155 * Math.sqrt(d * d - (d * d - 1.0) * d14 * d3)) / (d14 * d3);
                double d16 = Math.cos(this.rflon * (Math.PI / 180));
                double d17 = Math.sin(this.rflon * (Math.PI / 180));
                double d18 = d12 * d16 + d15 * (d13 * d17 - d16);
                double d19 = d12 * d17 - d15 * (d13 * d16 + d17);
                double d20 = d15 * d2 / Math.cos(d8);
                double d21 = Math.asin(d20 / this.rp);
                double d22 = Math.atan(Math.tan(d21) * 6378.155 / this.rp) * 57.29577951308232;
                double d23 = -Math.atan(d19 / d18) * 57.29577951308232;
                d23 += this.sublon;
                if (this.itype == 1) {
                    double d24 = d22;
                    double d25 = d23;
                }
                if (this.isEastPositive) {
                    d23 = -d23;
                }
                dArray2[0][n2] = d22;
                dArray2[1][n2] = d23;
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] toLinEle(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2;
            double d3;
            double d4 = dArray[0][n2];
            double d5 = d3 = this.isEastPositive ? dArray[1][n2] : -dArray[1][n2];
            if (this.itype == 1) {
                double d6 = dArray[0][n2];
                d2 = dArray[1][n2];
                d3 = -d3;
            }
            double d7 = d4 * (Math.PI / 180);
            double d8 = (d3 += this.sublon) * (Math.PI / 180);
            double d9 = 6378.155 * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(d7) * Math.cos(d7) + 4.0680861204025E7 * Math.sin(d7) * Math.sin(d7));
            d2 = Math.sqrt(this.h * this.h + d9 * d9 - 2.0 * this.h * d9 * Math.cos(d7) * Math.cos(d8));
            double d10 = d2 * d2 + d9 * d9;
            if (d10 > (d = this.h * this.h)) {
                dArray2[1][n2] = Double.NaN;
                dArray2[0][n2] = Double.NaN;
            } else {
                double d11 = 6378.155 + this.h;
                double d12 = 6378.155;
                double d13 = this.rp;
                double d14 = Math.cos(this.rflon * (Math.PI / 180));
                double d15 = Math.sin(this.rflon * (Math.PI / 180));
                double d16 = Math.atan(d13 / d12 * Math.tan(d7));
                double d17 = d12 * Math.cos(d16) * Math.cos(d8);
                double d18 = d12 * Math.cos(d16) * Math.sin(d8);
                double d19 = d13 * Math.sin(d16);
                double d20 = Math.atan((d14 * (d18 - d11 * d15) - (d17 - d11 * d14) * d15) / (d15 * (d18 - d11 * d15) + (d17 - d11 * d14) * d14));
                double d21 = Math.atan(d19 * ((Math.tan(d20) * d15 - d14) / (d17 - d11 * d14)) * Math.cos(d20));
                double d22 = (d20 *= 57.29577951308232) / (this.deltax * this.lpsi2);
                double d23 = (d21 *= 57.29577951308232) / (this.deltay * this.lpsi2);
                d22 = 1250.5 - d22;
                d23 = d23 + (double)this.ioff[2] + (double)this.ioff[1] - (double)this.ioff[0];
                dArray2[1][n2] = d23 = 5000.0 - d23 * 2.0;
                dArray2[0][n2] = d22 *= 2.0;
            }
            ++n2;
        }
        return this.imageCoordToAreaCoord(dArray2);
    }

    public MSATnav(int[] nArray) throws IllegalArgumentException {
        this.NOMORB = 42164.0;
        this.EARTH_RADIUS = 6378.155;
        if (nArray[0] != 1297301844) {
            throw new IllegalArgumentException("Invalid navigation type" + nArray[0]);
        }
        this.itype = 2;
        System.arraycopy(nArray, 3, this.ioff, 0, 3);
        this.h = 35785.845;
        this.a = 0.003367003367003367;
        this.rp = 6378.155 / (1.0 + this.a);
        this.lpsi2 = 1.0;
        this.deltax = 0.0072;
        this.deltay = 0.0072;
        this.rflon = 0.0;
        this.sublon = McIDASUtil.integerLatLonToDouble(nArray[6]);
    }
}

