/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;

public final class MOLLnav
extends AREAnav {
    private boolean isEastPositive = true;
    private final double EARTH_RADIUS;
    private double drad;
    private double decc;
    private double[] tlat = new double[101];
    private double[] t = new double[101];
    private double[][] coef = new double[4][101];
    private double[] lattbl = new double[91];
    private double xrow;
    private double xcol;
    private double rpix;
    private double xqlon;
    private int itype;
    private int ihem;
    private int iwest;
    private int icord;
    private double asq = 4.068383348E7;
    private double bsq = 4.041033018E7;
    private double ab = 4.054685122E7;
    private double ecc = 0.081992;
    private double eccsqr = 0.00672265;
    private int kwest = -1;
    private int kcord = 0;
    private final int KMPP;
    private final int PPMK;

    public double[][] toLatLon(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2;
            double d3 = dArray3[1][n2];
            double d4 = dArray3[0][n2];
            double d5 = Math.abs(d3 - this.xrow) / this.rpix;
            double d6 = (this.xcol - d4) / this.rpix;
            if (d3 != d3 || d4 != d4 || d5 > 1.0) {
                d2 = Double.NaN;
                d = Double.NaN;
            } else {
                double d7 = Math.sqrt(1.0 - d5 * d5);
                if (d7 == 0.0 || Math.abs(d6 / d7) > 2.0) {
                    d2 = Double.NaN;
                    d = Double.NaN;
                } else {
                    d2 = Math.asin((Math.asin(d5) + d5 * d7) / 1.5708) / (Math.PI / 180);
                    if (d3 > this.xrow) {
                        d2 = -d2;
                    }
                    d = -90.0 * (d6 / d7);
                    if ((d = this.xqlon - d) > 180.0) {
                        d -= 360.0;
                    }
                    if (d < -180.0) {
                        d += 360.0;
                    }
                    if (this.itype == 1) {
                        double d8 = Math.PI / 180 * d2;
                        if (this.kcord >= 0) {
                            d8 = Math.atan2(this.bsq * Math.sin(d8), this.asq * Math.cos(d8));
                        }
                        double d9 = (double)this.kwest * (Math.PI / 180) * d;
                        double d10 = Math.sin(d8);
                        double d11 = Math.cos(d8);
                        double d12 = Math.cos(d9);
                        double d13 = Math.sin(d9);
                        double d14 = Math.pow(d10 / d11, 2.0);
                        double d15 = this.ab * Math.sqrt((1.0 + d14) / (this.bsq + this.asq * d14));
                        d2 = d15 * d11 * d12;
                        d = d15 * d11 * d13;
                        double d16 = d15 * d10;
                    }
                }
            }
            if (this.isEastPositive) {
                d = -d;
            }
            dArray2[0][n2] = d2;
            dArray2[1][n2] = d;
            ++n2;
        }
        return dArray2;
    }

    public double[][] toLinEle(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2;
            double d3;
            double d4 = dArray[0][n2];
            double d5 = d3 = this.isEastPositive ? -dArray[1][n2] : dArray[1][n2];
            if (d4 != d4 || d3 != d3) {
                d2 = Double.NaN;
                d = Double.NaN;
            } else {
                double d6;
                if (this.itype == 1) {
                    double d7 = d4;
                    double d8 = d3;
                }
                int n3 = -1;
                if (d4 < 0.0) {
                    n3 = 1;
                }
                int n4 = (int)Math.abs(d4);
                double d9 = Math.abs(d4) - (double)n4;
                double d10 = this.lattbl[n4];
                if (n4 != 90) {
                    d10 += d9 * (this.lattbl[n4 + 1] - this.lattbl[n4]);
                }
                double d11 = Math.max(0.0, 1.0 - d10 * d10);
                double d12 = Math.sqrt(d11);
                double d13 = d3 - this.xqlon;
                if (d13 < -180.0) {
                    d13 += 360.0;
                }
                if (d13 > 180.0) {
                    d13 -= 360.0;
                }
                if (Math.abs(d6 = d12 * d13 / 90.0) > 2.0) {
                    d2 = Double.NaN;
                    d = Double.NaN;
                } else {
                    d2 = this.xcol - d6 * this.rpix;
                    d = (double)n3 * d10 * this.rpix + this.xrow;
                }
            }
            dArray2[1][n2] = d;
            dArray2[0][n2] = d2;
            ++n2;
        }
        return this.imageCoordToAreaCoord(dArray2);
    }

    public MOLLnav(int[] nArray) throws IllegalArgumentException {
        double d;
        this.EARTH_RADIUS = 6378.155;
        this.KMPP = 1263358032;
        this.PPMK = 1347439947;
        if (nArray[0] != 1297042508) {
            throw new IllegalArgumentException("Invalid navigation type" + nArray[0]);
        }
        this.itype = 2;
        this.xrow = nArray[1];
        this.xcol = nArray[2];
        this.xqlon = nArray[4];
        double d2 = this.drad = (double)nArray[6] / 1000.0;
        if (nArray[14] == 1263358032 || nArray[14] == 1347439947) {
            double d3 = nArray[3];
            this.rpix = 0.7071 * d2 / d3;
        } else {
            this.rpix = nArray[3];
        }
        this.decc = (double)nArray[7] / 1000000.0;
        this.iwest = nArray[9];
        if (this.iwest >= 0) {
            this.iwest = 1;
        }
        this.icord = nArray[8];
        this.asq = this.drad * this.drad;
        this.ecc = this.decc;
        this.eccsqr = this.ecc * this.ecc;
        double d4 = Math.sqrt(this.asq * (1.0 - this.eccsqr));
        this.bsq = d4 * d4;
        this.ab = this.drad * d4;
        if (this.iwest < 0) {
            this.kwest = 1;
        }
        if (this.icord < 0) {
            this.kcord = -1;
        }
        int n = 0;
        while (n < 101) {
            double d5 = (double)n / 100.0;
            if (d5 >= 1.0) {
                this.t[n] = 1.0;
                this.tlat[n] = 90.00021045914971;
            } else {
                this.t[n] = d5;
                this.tlat[n] = Math.asin((Math.asin(d5) + d5 * Math.sqrt(1.0 - d5 * d5)) / 1.5708) / (Math.PI / 180);
            }
            ++n;
        }
        int n2 = 100;
        int n3 = n2 - 1;
        n = 0;
        while (n < n2) {
            double d6;
            double d7;
            double d8;
            double d9;
            if (n != 0) {
                d9 = (this.t[n + 1] - this.t[n - 1]) / (this.tlat[n + 1] - this.tlat[n - 1]);
            } else {
                d8 = (this.t[1] + this.t[2]) / 2.0;
                d7 = (this.tlat[1] + this.tlat[2]) / 2.0;
                d9 = (d8 - this.t[0]) / (d7 - this.tlat[0]);
                d9 = 2.0 * (this.t[1] - this.t[0]) / (this.tlat[1] - this.tlat[0]) - d9;
            }
            if (n != n3) {
                d6 = (this.t[n + 2] - this.t[n]) / (this.tlat[n + 2] - this.tlat[n]);
            } else {
                d8 = (this.t[n2 - 1] + this.t[n2 - 2]) / 2.0;
                d7 = (this.tlat[n2 - 1] + this.tlat[n2 - 2]) / 2.0;
                d6 = (this.t[n2] - d8) / (this.tlat[n2] - d7);
                d6 = 2.0 * (this.t[n2] - this.t[n2 - 1]) / (this.tlat[n2] - this.tlat[n2 - 1]) - d6;
            }
            d = this.t[n + 1];
            double d10 = this.t[n];
            d8 = (this.tlat[n + 1] + this.tlat[n]) / 2.0;
            d7 = (this.tlat[n + 1] - this.tlat[n]) / 2.0;
            double d11 = d7 * d7;
            double d12 = d7 * d11;
            double d13 = d8 * d8;
            double d14 = d8 * d13;
            double d15 = 0.5 * (d + d10) - 0.25 * d7 * (d6 - d9);
            double d16 = 0.75 * (d - d10) / d7 - 0.25 * (d6 + d9);
            double d17 = 0.25 * (d6 - d9) / d7;
            double d18 = 0.25 * (d6 + d9) / d11 - 0.25 * (d - d10) / d12;
            this.coef[0][n] = d15 - d16 * d8 + d17 * d13 - d18 * d14;
            this.coef[1][n] = d16 - 2.0 * d17 * d8 + 3.0 * d18 * d13;
            this.coef[2][n] = d17 - 3.0 * d18 * d8;
            this.coef[3][n] = d18;
            ++n;
        }
        int n4 = 0;
        while (n4 < 4) {
            this.coef[n4][n2] = this.coef[n4][n2 - 1];
            ++n4;
        }
        n = 0;
        int n5 = 0;
        while (n5 < 91) {
            d = n5;
            if (n >= n2 - 1) {
                n = 0;
            }
            if (d < this.tlat[n] || d > this.tlat[n + 1]) {
                n = 0;
                n4 = n2;
                do {
                    int n6;
                    if (d < this.tlat[n6 = (n + n4) / 2]) {
                        n4 = n6;
                    }
                    if (!(d >= this.tlat[n6])) continue;
                    n = n6;
                } while (n4 > n + 1);
            }
            this.lattbl[n5] = this.coef[0][n] + d * (this.coef[1][n] + d * (this.coef[2][n] + d * this.coef[3][n]));
            ++n5;
        }
    }
}

