/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class MERCnav
extends AREAnav {
    private boolean isEastPositive = true;
    int iwest;
    int leftlon;
    double xrow;
    double xcol;
    double xlat1;
    double xspace;
    double xqlon;
    double xblat;
    double xblon;

    public double[][] toLatLon(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n2 = 0;
        while (n2 < n) {
            double d = this.xrow - dArray3[1][n2];
            double d2 = this.xcol - dArray3[0][n2];
            double d3 = (double)this.iwest * d2 / this.xblon;
            double d4 = d3 + this.xqlon;
            double d5 = Math.atan(Math.exp(d / this.xblat));
            double d6 = (d5 / (Math.PI / 180) - 45.0) * 2.0 + this.xlat1;
            if (d4 > 360.0 + (double)this.leftlon || d4 < (double)this.leftlon) {
                dArray2[0][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
            } else {
                dArray2[0][n2] = d6;
                dArray2[1][n2] = this.iwest == 1 ? -d4 : d4;
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] toLinEle(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d;
            double d2 = dArray[0][n2];
            double d3 = this.iwest == 1 ? -dArray[1][n2] : dArray[1][n2];
            double d4 = (double)this.iwest * (d3 - this.xqlon);
            if (d4 > 180.0) {
                d4 -= 360.0;
            }
            if (d4 < -180.0) {
                d4 += 360.0;
            }
            if (d2 >= 90.0) {
                d2 = 89.99;
            }
            if (d2 <= -90.0) {
                d2 = -89.99;
            }
            if ((d = ((d2 - this.xlat1) / 2.0 + 45.0) * (Math.PI / 180)) <= 0.0) {
                dArray2[1][n2] = Double.NaN;
                dArray2[0][n2] = Double.NaN;
            } else {
                dArray2[1][n2] = this.xrow - this.xblat * Math.log(Math.tan(d));
                dArray2[0][n2] = this.xcol - d4 * this.xblon;
            }
            ++n2;
        }
        return this.imageCoordToAreaCoord(dArray2);
    }

    public MERCnav(int[] nArray) throws IllegalArgumentException {
        if (nArray[0] != 1296388675) {
            throw new IllegalArgumentException("Invalid navigation type" + nArray[0]);
        }
        this.xrow = nArray[1];
        this.xcol = nArray[2];
        this.xlat1 = McIDASUtil.integerLatLonToDouble(nArray[3]);
        this.xspace = (double)nArray[4] / 1000.0;
        this.xqlon = McIDASUtil.integerLatLonToDouble(nArray[5]);
        double d = (double)nArray[6] / 1000.0;
        this.iwest = nArray[9];
        if (this.iwest >= 0) {
            this.iwest = 1;
        }
        this.xblat = d * Math.cos(this.xlat1 * (Math.PI / 180)) / this.xspace;
        this.xblon = Math.PI / 180 * d / this.xspace;
        this.leftlon = (int)this.xqlon - 180 * this.iwest;
    }
}

