/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class LAMBnav
extends AREAnav {
    private boolean isEastPositive = true;
    int iwest;
    int ihem;
    double xrow;
    double xcol;
    double xlat1;
    double xlat2;
    double xspace;
    double xqlon;
    double xblat;
    double xfac;
    double xpole;

    public double[][] toLatLon(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n2 = 0;
        while (n2 < n) {
            double d = (double)this.ihem * (dArray3[1][n2] - this.xrow) / this.xblat;
            double d2 = (double)(-this.ihem) * (dArray3[0][n2] - this.xcol) / this.xblat;
            double d3 = 0.0;
            if (d != 0.0 || d2 != 0.0) {
                d3 = Math.atan2(d2, d);
            }
            double d4 = (double)this.ihem * d3 / this.xfac / (Math.PI / 180) + this.xqlon;
            d4 = (d4 + 900.0) % 360.0 - 180.0;
            double d5 = Math.sqrt(d * d + d2 * d2);
            double d6 = Math.abs(d5) < 1.0E-10 ? (double)(this.ihem * 90) : (double)this.ihem * (90.0 - 2.0 * Math.atan(Math.exp(Math.log(d5) / this.xfac)) / (Math.PI / 180));
            dArray2[0][n2] = d6;
            dArray2[1][n2] = this.iwest == 1 ? -d4 : d4;
            ++n2;
        }
        return dArray2;
    }

    public double[][] toLinEle(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[0][n2];
            double d2 = this.iwest == 1 ? -dArray[1][n2] : dArray[1][n2];
            double d3 = (double)this.ihem * (d2 - this.xqlon);
            d3 = (d3 + 900.0) % 360.0 - 180.0;
            d3 = d3 * this.xfac * (Math.PI / 180);
            double d4 = (90.0 - (double)this.ihem * d) * (Math.PI / 180) * 0.5;
            double d5 = d4 == 0.0 ? 0.0 : this.xblat * Math.pow(Math.tan(Math.abs(d4)), this.xfac);
            dArray2[1][n2] = this.xrow + (double)this.ihem * (d5 * Math.cos(d3));
            dArray2[0][n2] = this.xcol - (double)this.ihem * (d5 * Math.sin(d3));
            ++n2;
        }
        return this.imageCoordToAreaCoord(dArray2);
    }

    public LAMBnav(int[] nArray) throws IllegalArgumentException {
        if (nArray[0] != 1279348034) {
            throw new IllegalArgumentException("Invalid navigation type" + nArray[0]);
        }
        this.xrow = nArray[1];
        this.xcol = nArray[2];
        int n = nArray[11];
        if (n == 0) {
            n = 900000;
        }
        this.ihem = 1;
        if (n < 0) {
            this.ihem = -1;
        }
        this.xpole = McIDASUtil.integerLatLonToDouble(n);
        this.xlat1 = McIDASUtil.integerLatLonToDouble(nArray[3]);
        this.xlat2 = McIDASUtil.integerLatLonToDouble(nArray[4]);
        this.xlat1 = (90.0 - (double)this.ihem * this.xlat1) * (Math.PI / 180);
        this.xlat2 = (90.0 - (double)this.ihem * this.xlat2) * (Math.PI / 180);
        this.xspace = (double)nArray[5] / 1000.0;
        this.xqlon = McIDASUtil.integerLatLonToDouble(nArray[6]);
        double d = (double)nArray[7] / 1000.0;
        this.iwest = nArray[10];
        if (this.iwest >= 0) {
            this.iwest = 1;
        }
        this.xfac = (Math.log(Math.sin(this.xlat1)) - Math.log(Math.sin(this.xlat2))) / (Math.log(Math.tan(0.5 * this.xlat1)) - Math.log(Math.tan(0.5 * this.xlat2)));
        this.xblat = d * Math.sin(this.xlat1) / (this.xspace * this.xfac * Math.pow(Math.tan(this.xlat1 * 0.5), this.xfac));
    }
}

