/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.GridDirectory;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class GridDirectoryList {
    private boolean flipwords = false;
    private DataInputStream inputStream;
    private int status = -1;
    private AddeURLConnection urlc;
    private ArrayList dirs;
    private ArrayList fileHeaders;
    private int numDirs = 0;
    private final int HEARTBEAT;

    private void readDirectory() throws McIDASException {
        if (this.urlc.getRequestType() != 3) {
            throw new McIDASException("Request must be of GDIR type");
        }
        this.dirs = new ArrayList();
        this.fileHeaders = new ArrayList();
        int n = this.urlc.getInitialRecordSize();
        if (n == 0) {
            throw new McIDASException("No datasets found");
        }
        byte[] byArray = new byte[256];
        try {
            int n2;
            while (n == 4) {
                n2 = this.inputStream.readInt();
                if (n2 != 11223344) {
                    System.out.println("problem...not heartbeat = " + n2);
                }
                n = this.inputStream.readInt();
            }
            while ((n2 = this.inputStream.readInt()) == 0) {
                int n3;
                this.inputStream.readFully(byArray, 0, 256);
                String string = new String(byArray, 0, 32);
                this.fileHeaders.add(string);
                while ((n3 = this.inputStream.readInt()) == 0) {
                    int[] nArray = new int[64];
                    int n4 = 0;
                    while (n4 < 64) {
                        nArray[n4] = this.inputStream.readInt();
                        ++n4;
                    }
                    GridDirectory gridDirectory = new GridDirectory(nArray);
                    System.out.println(gridDirectory);
                    this.dirs.add(gridDirectory);
                }
            }
        }
        catch (IOException iOException) {
            this.status = -1;
            throw new McIDASException("Error reading grid directory:" + iOException);
        }
        this.status = 1;
        ++this.numDirs;
    }

    public ArrayList getDirs() throws McIDASException {
        if (this.status <= 0 || this.dirs.size() <= 0) {
            throw new McIDASException("Error reading directory information");
        }
        return this.dirs;
    }

    public String toString() {
        if (this.status <= 0 || this.numDirs <= 0) {
            return new String("No directory information available");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.dirs.size()) {
            stringBuffer.append(((GridDirectory)this.dirs.get(n)).toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Must supply a ADDE request to grids");
            System.exit(1);
        }
        GridDirectoryList gridDirectoryList = new GridDirectoryList(stringArray[0]);
    }

    public GridDirectoryList(String string) throws McIDASException {
        this.HEARTBEAT = 11223344;
        try {
            URL uRL = new URL(string);
            this.urlc = (AddeURLConnection)uRL.openConnection();
            this.inputStream = new DataInputStream(new BufferedInputStream(this.urlc.getInputStream()));
        }
        catch (IOException iOException) {
            throw new McIDASException("Error opening URL for grids:" + iOException);
        }
        this.readDirectory();
    }

    public GridDirectoryList(URL uRL) throws McIDASException {
        this.HEARTBEAT = 11223344;
        try {
            this.urlc = (AddeURLConnection)uRL.openConnection();
            this.inputStream = new DataInputStream(new BufferedInputStream(this.urlc.getInputStream()));
        }
        catch (IOException iOException) {
            throw new McIDASException("Error opening URL for grids:" + iOException);
        }
        this.readDirectory();
    }

    static {
        try {
            String string = System.getProperty("java.protocol.handler.pkgs");
            String string2 = null;
            if (string == null) {
                string2 = "edu.wisc.ssec.mcidas";
            } else if (string.indexOf("edu.wisc.ssec.mcidas") < 0) {
                string2 = "edu.wisc.ssec.mcidas | " + string;
            }
            if (string2 != null) {
                System.setProperty("java.protocol.handler.pkgs", string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

