/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.GRIDnav;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import java.util.Date;

public class GridDirectory {
    public static final int DIRSIZE = 64;
    private static final int GRIDSIZE_INDEX = 0;
    public static final int ROWS_INDEX = 1;
    public static final int COLS_INDEX = 2;
    public static final int REFDATE_INDEX = 3;
    public static final int REFTIME_INDEX = 4;
    public static final int FTIME_INDEX = 5;
    public static final int PARAM_NAME_INDEX = 6;
    public static final int PARAM_SCALE_INDEX = 7;
    public static final int PARAM_UNITS_INDEX = 8;
    public static final int LEVEL_VALUE_INDEX = 9;
    public static final int LEVEL_SCALE_INDEX = 10;
    public static final int LEVEL_UNITS_INDEX = 11;
    public static final int PARAM_TYPE_INDEX = 12;
    public static final int SECOND_FTIME_INDEX = 13;
    public static final int SECOND_LEVEL_VALUE_INDEX = 14;
    public static final int NAV_BLOCK_INDEX = 33;
    public static final int NAV_BLOCK_LENGTH = 8;
    public static final int GRID_DESCR_INDEX = 52;
    public static final int GRID_DESCR_LENGTH = 12;
    private int[] dir = new int[64];
    private String paramName;
    private String gridDescription;
    private String paramUnitName;
    private int forecastHour;
    private Date referenceTime;
    private Date validTime;
    private Date secondTime = null;
    private double paramScale;
    private double levelValue;
    private String levelUnitName;
    private double secondLevelValue;
    private int rows;
    private int columns;
    private int paramType;
    private int[] navBlock;
    private GRIDnav gridNav = null;

    public int[] getDirBlock() {
        return this.dir;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getGridDescription() {
        return this.gridDescription;
    }

    public double getParamScale() {
        return this.paramScale;
    }

    public String getParamUnitName() {
        return this.paramUnitName;
    }

    public Date getReferenceTime() {
        return this.referenceTime;
    }

    public Date getValidTime() {
        return this.validTime;
    }

    public int getForecastHour() {
        return this.forecastHour;
    }

    public Date getSecondTime() {
        return this.secondTime;
    }

    public double getLevelValue() {
        return this.levelValue;
    }

    public String getLevelUnitName() {
        return this.levelUnitName;
    }

    public double getSecondLevelValue() {
        return this.secondLevelValue;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int[] getNavBlock() {
        return this.navBlock;
    }

    public GRIDnav getNavigation() {
        if (this.gridNav == null) {
            try {
                this.gridNav = new GRIDnav(this.getDirBlock());
            }
            catch (McIDASException mcIDASException) {
                this.gridNav = null;
            }
        }
        return this.gridNav;
    }

    public int getNavType() {
        return this.navBlock[0];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Grid Directory:");
        stringBuffer.append("\n");
        stringBuffer.append("\tParameter = ");
        stringBuffer.append(this.paramName + " [" + this.paramUnitName + "] (");
        stringBuffer.append(this.gridDescription + ")");
        stringBuffer.append("\n");
        stringBuffer.append("\trefTime: ");
        stringBuffer.append(this.referenceTime.toGMTString());
        stringBuffer.append(" valid: " + this.validTime.toGMTString());
        stringBuffer.append("\n");
        stringBuffer.append("\tsecond Time: ");
        stringBuffer.append(this.secondTime != null ? this.secondTime.toGMTString() : "none");
        stringBuffer.append("\n");
        stringBuffer.append("\tLevel: ");
        stringBuffer.append(this.levelValue + " [" + this.levelUnitName + "] second: " + this.secondLevelValue);
        stringBuffer.append("\n");
        stringBuffer.append("\tNav Type: ");
        stringBuffer.append(this.getNavType());
        stringBuffer.append(" rows: " + this.rows);
        stringBuffer.append(" cols: " + this.columns);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public GridDirectory(int[] nArray) throws McIDASException {
        if (nArray.length != 64) {
            throw new McIDASException("Directory is not the right size");
        }
        System.arraycopy(nArray, 0, this.dir, 0, 64);
        this.rows = nArray[1];
        this.columns = nArray[2];
        int n = nArray[3];
        int n2 = nArray[4];
        this.referenceTime = new Date(McIDASUtil.mcDayTimeToSecs(n, n2) * 1000L);
        this.forecastHour = nArray[5];
        this.validTime = new Date((McIDASUtil.mcDayTimeToSecs(n, n2) + (long)(this.forecastHour * 3600)) * 1000L);
        this.paramName = McIDASUtil.intBitsToString(nArray[6]).trim();
        this.paramScale = Math.pow(10.0, nArray[7]);
        this.paramUnitName = McIDASUtil.intBitsToString(nArray[8]).trim();
        this.paramType = nArray[12];
        this.levelValue = (double)nArray[9] * Math.pow(10.0, nArray[10]);
        this.levelUnitName = McIDASUtil.intBitsToString(nArray[11]).trim();
        if (Math.abs(this.levelValue) > 10000.0 && this.levelUnitName.equals("")) {
            this.levelUnitName = McIDASUtil.intBitsToString(nArray[9]).trim();
            this.levelValue = 999.0;
        }
        if (this.paramType == 4 || this.paramType == 8) {
            this.secondLevelValue = (double)nArray[14] * Math.pow(10.0, nArray[10]);
        }
        if (this.paramType == 1 || this.paramType == 2) {
            this.secondTime = new Date((McIDASUtil.mcDayTimeToSecs(n, n2) + (long)(nArray[13] / 10000 * 3600)) * 1000L);
        }
        this.navBlock = new int[8];
        System.arraycopy(nArray, 33, this.navBlock, 0, 8);
        int[] nArray2 = new int[12];
        System.arraycopy(nArray, 52, nArray2, 0, nArray2.length);
        this.gridDescription = McIDASUtil.intBitsToString(nArray2).trim();
    }
}

