/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.McIDASException;
import java.io.Serializable;

public class GRIDnav
implements Serializable {
    final int PSEUDO_MERCATOR;
    final int PS_OR_LAMBERT_CONIC;
    final int EQUIDISTANT;
    final int PSEUDO_MERCATOR_GENERAL;
    final int NO_NAV;
    final int LAMBERT_CONFORMAL_TANGENT;
    final double EARTH_RADIUS;
    final double xrad = Math.PI / 180;
    public final int indexRow;
    public final int indexCol;
    public final int indexLat;
    public final int indexLon;
    private int startRow = 1;
    private int startColumn = 1;
    private boolean isRowFlipped = false;
    private double rowOffset = 0.0;
    private int navType;
    private double xnr;
    private double xnc;
    private double xnrow;
    private double xncol;
    private boolean wierd = false;
    private double glamx;
    private double glomx;
    private double ginct;
    private double gincn;
    private double xrowi;
    private double xcoli;
    private double xqlon;
    private double xspace;
    private double xh;
    private double xfac;
    private double xblat;
    private double xrot;
    private double yspace;
    private double xblon;

    public double[][] toLatLon(double[][] dArray) {
        double[][] dArray2 = new double[2][dArray[0].length];
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = 0.0;
        int n = 0;
        while (n < dArray[0].length) {
            double d4 = this.isRowFlipped ? this.rowOffset - dArray[1][n] + 1.0 : dArray[1][n];
            double d5 = dArray[0][n] - (double)(this.startColumn - 1);
            if ((d4 += (double)(this.startRow - 1)) > this.xnrow || d4 < 1.0 || d5 > this.xncol || d5 < 1.0) {
                d = Double.NaN;
                d2 = Double.NaN;
            } else {
                switch (this.navType) {
                    case 1: 
                    case 4: {
                        double d6;
                        if (this.wierd) {
                            d6 = d4;
                            d5 = d4;
                            d4 = this.xnr - d6 + 1.0;
                        }
                        d = this.glamx - (d4 - 1.0) * this.ginct;
                        d2 = this.glomx - (d5 - 1.0) * this.gincn;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 2: 
                    case 6: {
                        double d6;
                        double d7 = this.xh * (d4 - this.xrowi) / this.xblat;
                        double d8 = (this.xcoli - d5) / this.xblat;
                        d3 = 0.0;
                        if (d7 != 0.0 || d8 != 0.0) {
                            d3 = Math.atan2(d8, d7);
                        }
                        if ((d2 = d3 / this.xfac / (Math.PI / 180) + this.xqlon) > 180.0) {
                            d2 -= 360.0;
                        }
                        if ((d6 = Math.sqrt(d7 * d7 + d8 * d8)) < 1.0E-5) {
                            d = this.xh * 90.0;
                            break;
                        }
                        d = this.xh * (90.0 - 2.0 * Math.atan(Math.exp(Math.log(d6) / this.xfac)) / (Math.PI / 180));
                        break;
                    }
                    default: {
                        d = 1.0 - (d4 - 1.0) / (this.xnr - 1.0);
                        d2 = 1.0 - (d5 - 1.0) / (this.xnc - 1.0);
                        break;
                    }
                }
            }
            dArray2[0][n] = d;
            dArray2[1][n] = -d2;
            ++n;
        }
        return dArray2;
    }

    public double[][] toRowCol(double[][] dArray) {
        double[][] dArray2 = new double[2][dArray[0].length];
        int n = 0;
        while (n < dArray[0].length) {
            double d = Double.NaN;
            double d2 = Double.NaN;
            double d3 = dArray[0][n];
            double d4 = -dArray[1][n];
            switch (this.navType) {
                case 1: 
                case 4: {
                    double d5 = this.glomx;
                    if (this.glomx < 0.0 && this.glomx * d4 < 0.0) {
                        d5 = this.glomx + 360.0;
                    }
                    d = (this.glamx - d3) / this.ginct + 1.0;
                    d2 = (d5 - d4) / this.gincn + 1.0;
                    break;
                }
                case 3: {
                    double d6 = d4 - this.glomx;
                    double d7 = d3 - this.glamx;
                    double d8 = this.xblat * d7;
                    double d9 = d6 * this.xblon * Math.cos(d3 * (Math.PI / 180));
                    double d10 = Math.sqrt(d8 * d8 + d9 * d9);
                    if (d10 > 0.001) {
                        double d11 = Math.atan2(d8, d9) - 1.5707963267948966;
                        double d12 = Math.atan2(d8, d9) + 1.5707963267948966;
                        d8 = d10 * Math.cos(-this.xrot + d11);
                        d9 = d10 * Math.sin(-this.xrot + d12);
                    }
                    d = this.xrowi - d8;
                    d2 = this.xcoli - d9;
                    break;
                }
                case 2: 
                case 6: {
                    double d6 = d4 - this.xqlon;
                    if (d6 > 180.0) {
                        d6 -= 360.0;
                    }
                    d6 = d6 * this.xfac * (Math.PI / 180);
                    double d13 = (90.0 - this.xh * d3) * (Math.PI / 180) * 0.5;
                    double d7 = this.xblat * Math.pow(Math.tan(d13), this.xfac);
                    d = this.xh * d7 * Math.cos(d6) + this.xrowi;
                    d2 = -d7 * Math.sin(d6) + this.xcoli;
                    break;
                }
                default: {
                    d = (1.0 - d3) * (this.xnr - 1.0) + 1.0;
                    d2 = (1.0 - d4) * (this.xnc - 1.0) + 1.0;
                    break;
                }
            }
            if (d > this.xnrow || d < 1.0 || d2 > this.xncol || d2 < 1.0) {
                d = Double.NaN;
                d2 = Double.NaN;
            } else {
                d -= (double)(this.startRow - 1);
                d2 += (double)(this.startColumn - 1);
                if (this.isRowFlipped) {
                    d = this.rowOffset - d + 1.0;
                }
            }
            dArray2[1][n] = d;
            dArray2[0][n] = d2;
            ++n;
        }
        return dArray2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GRIDnav)) {
            return false;
        }
        GRIDnav gRIDnav = (GRIDnav)object;
        return Double.doubleToLongBits(this.xnr) == Double.doubleToLongBits(gRIDnav.xnr) && Double.doubleToLongBits(this.xnc) == Double.doubleToLongBits(gRIDnav.xnc) && this.navType == gRIDnav.navType;
    }

    public void setStart(int n, int n2) {
        this.startRow = n;
        this.startColumn = n2;
    }

    public void setFlipRowCoordinates(int n) {
        this.isRowFlipped = true;
        this.rowOffset = n;
    }

    public boolean isFlippedRowCoordinates() {
        return this.isRowFlipped;
    }

    public double getRowOffset() {
        return this.rowOffset;
    }

    public int getRowIndex() {
        return 1;
    }

    public int getColumnIndex() {
        return 0;
    }

    public GRIDnav(int[] nArray) throws McIDASException {
        this.PSEUDO_MERCATOR = 1;
        this.PS_OR_LAMBERT_CONIC = 2;
        this.EQUIDISTANT = 3;
        this.PSEUDO_MERCATOR_GENERAL = 4;
        this.NO_NAV = 5;
        this.LAMBERT_CONFORMAL_TANGENT = 6;
        this.EARTH_RADIUS = 6371.23;
        this.indexRow = 1;
        this.indexCol = 0;
        this.indexLat = 0;
        this.indexLon = 1;
        if (nArray.length != 64) {
            throw new McIDASException("Directory is not the right size");
        }
        int n = nArray[33];
        this.navType = n % 10;
        this.wierd = n / 10 == 1;
        this.xnr = nArray[1];
        this.xnc = nArray[2];
        this.xnrow = this.xnr;
        this.xncol = this.xnc;
        switch (this.navType) {
            case 1: 
            case 4: {
                this.glamx = (double)nArray[34] / 10000.0;
                this.glomx = (double)nArray[35] / 10000.0;
                this.ginct = (double)nArray[38] / 10000.0;
                double d = this.gincn = this.navType == 4 ? (double)nArray[39] / 10000.0 : this.ginct;
                if (!this.wierd) break;
                double d2 = this.xnr;
                this.xnr = this.xnc;
                this.xnc = d2;
                break;
            }
            case 2: {
                this.xrowi = (double)nArray[34] / 10000.0;
                this.xcoli = (double)nArray[35] / 10000.0;
                this.xspace = (double)nArray[36] / 1000.0;
                this.xqlon = (double)nArray[37] / 10000.0;
                double d = (double)nArray[38] / 10000.0;
                double d3 = (double)nArray[39] / 10000.0;
                this.xh = d >= 0.0 ? 1.0 : -1.0;
                d = (90.0 - this.xh * d) * (Math.PI / 180);
                d3 = (90.0 - this.xh * d3) * (Math.PI / 180);
                this.xfac = 1.0;
                if (d != d3) {
                    this.xfac = (Math.log(Math.sin(d)) - Math.log(Math.sin(d3))) / (Math.log(Math.tan(0.5 * d)) - Math.log(Math.tan(0.5 * d3)));
                }
                this.xfac = 1.0 / this.xfac;
                this.xblat = 6370.0 * Math.sin(d) / (this.xspace * this.xfac * Math.pow(Math.tan(d * 0.5), this.xfac));
                if (!this.wierd) break;
                double d4 = this.xnr;
                this.xnr = this.xnc;
                this.xnc = d4;
                d4 = this.xcoli;
                this.xcoli = this.xrowi;
                this.xrowi = this.xnr - d4 + 1.0;
                this.xqlon += 90.0;
                break;
            }
            case 3: {
                this.xrowi = 1.0;
                this.xcoli = 1.0;
                this.glamx = (double)nArray[34] / 10000.0;
                this.glomx = (double)nArray[35] / 10000.0;
                this.xrot = -Math.PI / 180 * (double)nArray[36] / 10000.0;
                this.xspace = (double)nArray[37] / 1000.0;
                this.yspace = (double)nArray[38] / 1000.0;
                this.xblat = 111.19894090183831 / this.yspace;
                this.xblon = 111.19894090183831 / this.xspace;
                if (!this.wierd) break;
                double d = this.xnr;
                this.xnr = this.xnc;
                this.xnc = d;
                break;
            }
            case 6: {
                this.xrowi = (double)nArray[34] / 10000.0;
                this.xcoli = (double)nArray[35] / 10000.0;
                this.xspace = (double)nArray[36] / 1000.0;
                this.xqlon = (double)nArray[37] / 10000.0;
                double d = (double)nArray[38] / 10000.0;
                this.xh = d >= 0.0 ? 1.0 : -1.0;
                d = (90.0 - this.xh * d) * (Math.PI / 180);
                this.xfac = Math.cos(d);
                this.xblat = 6371.23 * Math.tan(d) / (this.xspace * Math.pow(Math.tan(d * 0.5), this.xfac));
                break;
            }
        }
    }
}

