/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class GOESnav
extends AREAnav {
    private boolean isEastPositive = true;
    private int navday;
    private int lintot;
    private double deglin;
    private int ieltot;
    private double degele;
    private double spinra;
    private int ietimy;
    private int ietimh;
    private double semima;
    private double oeccen;
    private double orbinc;
    private double perhel;
    private double asnode;
    private double nopcln;
    private double declin;
    private double rascen;
    private double piclin;
    private double prerat;
    private double predir;
    private double pitch;
    private double yaw;
    private double roll;
    private double skew;
    private int iajust;
    private int ibtcon;
    private int negbet;
    private int iseang;
    private double scan1;
    private double time1;
    private double scan2;
    private double time2;
    private double emega;
    private double ab;
    private double asq;
    private double bsq;
    private double r;
    private double rsq;
    private double rdpdg;
    private int numsen;
    private double totlin;
    private double radlin;
    private double totele;
    private double radele;
    private double picele;
    private double cpitch;
    private double cyaw;
    private double croll;
    private double pskew;
    private double rfact;
    private double roasin;
    private double tmpscl;
    private double b11;
    private double b12;
    private double b13;
    private double b21;
    private double b22;
    private double b23;
    private double b31;
    private double b32;
    private double b33;
    private double gamma;
    private double gamdot;
    private double rotm11;
    private double rotm13;
    private double rotm21;
    private double rotm23;
    private double rotm31;
    private double rotm33;
    private double pictim;
    private double xref;
    private int iold = 0;
    private double tdife;
    private double xmmc;
    private double epsiln;
    private double srome2;
    private double pz;
    private double py;
    private double px;
    private double qz;
    private double qy;
    private double qx;

    public double[][] toLatLon(double[][] dArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n2 = 0;
        while (n2 < n) {
            double d = dArray3[1][n2];
            double d2 = dArray3[0][n2];
            int n3 = Math.round((float)d);
            double d3 = (n3 - 1) / this.numsen + 1;
            double d4 = this.tmpscl * d3;
            double d5 = d4 + this.pictim;
            double[] dArray4 = this.satvec(d5);
            double d6 = (d - this.piclin) * this.radlin;
            double d7 = (d2 - this.picele + this.gamma + this.gamdot * d5) * this.radele;
            double d8 = this.b11 * dArray4[0] + this.b12 * dArray4[1] + this.b13 * dArray4[2];
            double d9 = this.b21 * dArray4[0] + this.b22 * dArray4[1] + this.b23 * dArray4[2];
            double d10 = Math.atan2(d9, d8) + Math.PI;
            double d11 = Math.cos(d6);
            double d12 = Math.sin(d6);
            double d13 = Math.sin(d7 -= d10);
            double d14 = Math.cos(d7);
            double d15 = this.rotm11 * d11 - this.rotm13 * d12;
            double d16 = this.rotm21 * d11 - this.rotm23 * d12;
            double d17 = this.rotm31 * d11 - this.rotm33 * d12;
            double d18 = d15;
            d15 = d14 * d15 + d13 * d16;
            d16 = -d13 * d18 + d14 * d16;
            double d19 = this.b11 * d15 + this.b21 * d16 + this.b31 * d17;
            double d20 = this.b12 * d15 + this.b22 * d16 + this.b32 * d17;
            double d21 = this.b13 * d15 + this.b23 * d16 + this.b33 * d17;
            double d22 = this.bsq / this.asq;
            double d23 = 1.0 - d22;
            double d24 = d22 + d23 * Math.pow(d21, 2.0);
            double d25 = 2.0 * ((d19 * dArray4[0] + d20 * dArray4[1]) * d22 + d21 * dArray4[2]);
            double d26 = (Math.pow(dArray4[0], 2.0) + Math.pow(dArray4[1], 2.0)) * d22 + Math.pow(dArray4[2], 2.0) - this.bsq;
            double d27 = Math.pow(d25, 2.0) - 4.0 * d24 * d26;
            if (d27 < 1.0) {
                dArray2[0][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
            } else {
                double d28 = -(d25 + Math.sqrt(d27)) / (2.0 * d24);
                double d29 = dArray4[0] + d19 * d28;
                double d30 = dArray4[1] + d20 * d28;
                double d31 = dArray4[2] + d21 * d28;
                double d32 = Math.cos(this.emega * d5 + this.xref);
                double d33 = Math.sin(this.emega * d5 + this.xref);
                double d34 = d32 * d29 + d33 * d30;
                double d35 = -d33 * d29 + d32 * d30;
                double[] dArray5 = this.nxyzll(d34, d35, d31);
                dArray2[0][n2] = dArray5[0];
                dArray2[1][n2] = this.isEastPositive ? -dArray5[1] : dArray5[1];
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] toLinEle(double[][] dArray) {
        double[] dArray2 = new double[3];
        int n = dArray[0].length;
        double[][] dArray3 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[0][n2];
            double d2 = this.isEastPositive ? -dArray[1][n2] : dArray[1][n2];
            double d3 = Double.NaN;
            double d4 = Double.NaN;
            if (Math.abs(d) <= 90.0) {
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                double d10;
                double d11;
                double d12;
                double d13;
                double d14 = 910.0;
                double d15 = -99999.0;
                double d16 = 0.0;
                double d17 = 0.0;
                double d18 = 0.0;
                double d19 = 0.0;
                double d20 = 0.0;
                double d21 = 0.0;
                double d22 = 0.0;
                double d23 = 0.0;
                double[] dArray4 = this.nllxyz(d, d2);
                double d24 = dArray4[0];
                double d25 = dArray4[1];
                d19 = dArray4[2];
                double d26 = 0.0;
                double d27 = this.time1;
                int n3 = 0;
                while (n3 < 2) {
                    if (Math.abs(d27 - d15) >= 5.0E-4) {
                        dArray2 = this.satvec(d27);
                        d18 = dArray2[0];
                        d17 = dArray2[1];
                        d16 = dArray2[2];
                        d15 = d27;
                        d23 = Math.sqrt(Math.pow(dArray2[0], 2.0) + Math.pow(dArray2[1], 2.0) + Math.pow(dArray2[2], 2.0));
                    }
                    d13 = Math.cos(this.emega * d27 + this.xref);
                    d12 = Math.sin(this.emega * d27 + this.xref);
                    d21 = d13 * d24 - d12 * d25;
                    d20 = d12 * d24 + d13 * d25;
                    d11 = d21 - d18;
                    d10 = d20 - d17;
                    d9 = d19 - d16;
                    d8 = this.b31 * d11 + this.b32 * d10 + this.b33 * d9;
                    d22 = Math.sqrt(Math.pow(d11, 2.0) + Math.pow(d10, 2.0) + Math.pow(d9, 2.0));
                    d7 = d8 / d22;
                    d6 = Math.atan2(d7, Math.sqrt(this.rfact - Math.pow(d7, 2.0))) - this.roasin;
                    d3 = this.piclin - d6 / this.radlin;
                    double d28 = (d3 - 1.0) / (double)this.numsen;
                    if (n3 == 0) {
                        d27 = this.time2;
                        d14 = d3;
                    }
                    ++n3;
                }
                double d29 = ((d14 + d3) / 2.0 - 1.0) / (double)this.numsen;
                double d30 = (d29 - this.scan1) / (this.scan2 - this.scan1);
                d3 = d14 + d30 * (d3 - d14);
                d27 = this.time1 + this.tmpscl * (d29 - this.scan1);
                dArray2 = this.satvec(d27);
                d18 = dArray2[0];
                double d31 = d21 * d18 + d20 * (d17 = dArray2[1]) + d19 * (d16 = dArray2[2]);
                if (d31 >= (d5 = 1.0E-4 * this.r * d23 + this.rsq)) {
                    double d32 = this.b11 * d18 + this.b12 * d17 + this.b13 * d16;
                    double d33 = this.b21 * d18 + this.b22 * d17 + this.b23 * d16;
                    d13 = Math.cos(this.emega * d27 + this.xref);
                    d12 = Math.sin(this.emega * d27 + this.xref);
                    d21 = d13 * d24 - d12 * d25;
                    d20 = d12 * d24 + d13 * d25;
                    d11 = d21 - d18;
                    d10 = d20 - d17;
                    d9 = d19 - d16;
                    double d34 = this.b11 * d11 + this.b12 * d10 + this.b13 * d9;
                    double d35 = this.b21 * d11 + this.b22 * d10 + this.b23 * d9;
                    d8 = this.b31 * d11 + this.b32 * d10 + this.b33 * d9;
                    double d36 = Math.sqrt(Math.pow(d22, 2.0) - Math.pow(d8, 2.0));
                    double d37 = Math.sqrt(Math.pow(d32, 2.0) + Math.pow(d33, 2.0));
                    d22 = Math.sqrt(Math.pow(d11, 2.0) + Math.pow(d10, 2.0) + Math.pow(d9, 2.0));
                    d7 = d8 / d22;
                    d6 = Math.atan2(d7, Math.sqrt(this.rfact - Math.pow(d7, 2.0))) - this.roasin;
                    double d38 = Math.sin(d6);
                    double d39 = Math.cos(d6);
                    double d40 = this.rotm11 * d39 + this.rotm13 * d38;
                    double d41 = this.rotm21 * d39 + this.rotm23 * d38;
                    d4 = this.picele + Math.asin((d32 * d35 - d33 * d34) / (d36 * d37)) / this.radele;
                    d4 += Math.atan2(d41, d40) / this.radele;
                    d4 = d4 - this.gamma - this.gamdot * d27;
                }
            }
            dArray3[1][n2] = d3;
            dArray3[0][n2] = d4;
            ++n2;
        }
        return this.imageCoordToAreaCoord(dArray3);
    }

    private int icon1(int n) {
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        int n2 = n / 10000 % 100;
        int n3 = n / 100 % 100;
        int n4 = n % 100;
        if (n3 < 0 || n3 > 12) {
            n3 = 1;
        }
        int n5 = n4 + nArray[n3 - 1];
        if (n2 % 4 == 0 && n3 > 2) {
            ++n5;
        }
        return 1000 * n2 + n5;
    }

    private void epoch(int n, int n2, double d, double d2, double d3) {
        double d4 = 3.14159265;
        double d5 = d4 / 180.0;
        double d6 = 6378.388;
        double d7 = 0.07436574;
        double d8 = d7 * Math.pow(Math.sqrt(d6 / d), 3.0);
        double d9 = d5 * d3;
        double d10 = (d9 - d2 * Math.sin(d9)) / (60.0 * d8);
        double d11 = McIDASUtil.mcPackedIntegerToDouble(n2);
        d10 = d11 - d10;
        int n3 = 0;
        if (d10 > 48.0) {
            d10 -= 48.0;
            n3 = 2;
        } else if (d10 > 24.0) {
            d10 -= 24.0;
            n3 = 1;
        } else if (d10 < -24.0) {
            d10 += 48.0;
            n3 = -2;
        } else if (d10 < 0.0) {
            d10 += 24.0;
            n3 = -1;
        }
        this.ietimh = McIDASUtil.mcDoubleToPackedInteger(d10);
        if (n3 != 0) {
            int n4 = n / 1000 % 100;
            n4 += 1000;
            int n5 = n % 1000;
            if ((n5 += n3) < 1) {
                n5 = this.leapyr(--n4) + n5;
            } else {
                int n6 = this.leapyr(n4);
                if (n5 > n6) {
                    ++n4;
                    n5 += n6;
                }
            }
            this.ietimy = 1000 * (n4 %= 100) + n5;
        }
    }

    private int leapyr(int n) {
        return 366 - (n % 4 + 3) / 4;
    }

    private double[] nllxyz(double d, double d2) {
        double d3 = this.rdpdg * d;
        d3 = Math.atan2(this.bsq * Math.sin(d3), this.asq * Math.cos(d3));
        double d4 = -this.rdpdg * d2;
        double d5 = Math.sin(d3);
        double d6 = Math.cos(d3);
        double d7 = Math.cos(d4);
        double d8 = Math.sin(d4);
        double d9 = Math.pow(d5 / d6, 2.0);
        double d10 = this.ab * Math.sqrt((1.0 + d9) / (this.bsq + this.asq * d9));
        double d11 = d10 * d6 * d7;
        double d12 = d10 * d6 * d8;
        double d13 = d10 * d5;
        return new double[]{d11, d12, d13};
    }

    private double[] nxyzll(double d, double d2, double d3) {
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        if (d != 0.0 && d2 != 0.0 && d3 != 0.0) {
            double d6 = Math.atan(d3 / Math.sqrt(d * d + d2 * d2));
            d4 = Math.atan2(this.asq * Math.sin(d6), this.bsq * Math.cos(d6)) / this.rdpdg;
            d5 = -Math.atan2(d2, d) / this.rdpdg;
        }
        return new double[]{d4, d5};
    }

    private double[] satvec(double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (this.iold != 1) {
            this.iold = 1;
            d6 = 3.14159265;
            d5 = d6 / 180.0;
            d4 = 6378.388;
            d3 = 0.07436574;
            d2 = 1.00273791;
            double d7 = 100.26467;
            d7 = d5 * d7;
            int n = 74001;
            int n2 = 0;
            double d8 = d5 * this.orbinc;
            double d9 = d5 * this.perhel;
            double d10 = d5 * this.asnode;
            double d11 = Math.sin(d8);
            double d12 = Math.cos(d8);
            double d13 = Math.sin(d9) * this.semima;
            double d14 = Math.cos(d9) * this.semima;
            double d15 = Math.sin(d10);
            double d16 = Math.cos(d10);
            this.px = d14 * d16 - d13 * d15 * d12;
            this.py = d14 * d15 + d13 * d16 * d12;
            this.pz = d13 * d11;
            this.qx = -d13 * d16 - d14 * d15 * d12;
            this.qy = -d13 * d15 + d14 * d16 * d12;
            this.qz = d14 * d11;
            this.srome2 = Math.sqrt(1.0 - this.oeccen) * Math.sqrt(1.0 + this.oeccen);
            this.xmmc = d3 * d4 * Math.sqrt(d4 / this.semima) / this.semima;
            int n3 = this.ietimy / 1000 % 100;
            int n4 = this.ietimy % 1000;
            int n5 = (n3 - 1) / 4 + 1;
            double d17 = 365 * (n3 - 1) + n5 + n4 - 1;
            double d18 = 1440.0 * d17 + 60.0 * McIDASUtil.mcPackedIntegerToDouble(this.ietimh);
            int n6 = n / 1000;
            int n7 = n % 1000;
            int n8 = (n6 - 1) / 4 + 1;
            double d19 = 365 * (n6 - 1) + n8 + n7 - 1;
            double d20 = 1440.0 * d19 + 60.0 * McIDASUtil.mcPackedIntegerToDouble(n2);
            int n9 = this.navday / 1000 % 100;
            int n10 = this.navday % 1000;
            int n11 = (n9 - 1) / 4 + 1;
            double d21 = 365 * (n9 - 1) + n11 + n10 - 1;
            this.tdife = d21 * 1440.0 - d18;
            double d22 = d21 * 1440.0 - d20;
            this.epsiln = 1.0E-8;
        }
        d6 = d * 60.0;
        d5 = this.tdife + d6;
        d3 = d4 = this.xmmc * d5;
        d2 = 0.0;
        int n = 0;
        n = 0;
        while (n < 20) {
            d2 = d4 + this.oeccen * Math.sin(d3);
            if (Math.abs(d2 - d3) < this.epsiln) break;
            d3 = d2;
            ++n;
        }
        double d23 = Math.cos(d2) - this.oeccen;
        double d24 = this.srome2 * Math.sin(d2);
        double d25 = d23 * this.pz + d24 * this.qz;
        double d26 = d23 * this.py + d24 * this.qy;
        double d27 = d23 * this.px + d24 * this.qx;
        return new double[]{d27, d26, d25};
    }

    public GOESnav(int[] nArray) throws IllegalArgumentException {
        if (nArray[0] != 1196377427) {
            throw new IllegalArgumentException("Invalid navigation type" + nArray[0]);
        }
        int n = nArray[1];
        int n2 = nArray[2];
        this.navday = n % 100000;
        int n3 = 6;
        while (n3 < 12) {
            if (nArray[n3] <= 0) {
                throw new IllegalArgumentException("Invalid orbital parameters");
            }
            ++n3;
        }
        this.ietimy = this.icon1(nArray[4]);
        this.ietimh = 100 * (nArray[5] / 100) + Math.round(0.6f * (float)(nArray[5] % 100));
        this.semima = (double)nArray[6] / 100.0;
        this.oeccen = (double)nArray[7] / 1000000.0;
        this.orbinc = (double)nArray[8] / 1000.0;
        double d = (double)nArray[9] / 1000.0;
        this.perhel = (double)nArray[10] / 1000.0;
        this.asnode = (double)nArray[11] / 1000.0;
        if (nArray[4] == 0) {
            throw new IllegalArgumentException("Invalid orbit type");
        }
        this.epoch(this.ietimy, this.ietimh, this.semima, this.oeccen, d);
        this.declin = McIDASUtil.mcPackedIntegerToDouble(nArray[12]);
        this.rascen = McIDASUtil.mcPackedIntegerToDouble(nArray[13]);
        this.piclin = nArray[14];
        if (nArray[14] >= 1000000) {
            this.piclin /= 10000.0;
        }
        if (nArray[12] == 0 && nArray[13] == 0 && nArray[14] == 0) {
            throw new IllegalArgumentException("Invalid ascension/declination parameters");
        }
        if (nArray[15] == 0) {
            throw new IllegalArgumentException("Invalid spin period");
        }
        this.spinra = (double)nArray[15] / 1000.0;
        if (nArray[15] != 0 && this.spinra < 300.0) {
            this.spinra = 60000.0 / this.spinra;
        }
        this.deglin = McIDASUtil.mcPackedIntegerToDouble(nArray[16]);
        this.lintot = nArray[17];
        this.degele = McIDASUtil.mcPackedIntegerToDouble(nArray[18]);
        this.ieltot = nArray[19];
        this.pitch = McIDASUtil.mcPackedIntegerToDouble(nArray[20]);
        this.yaw = McIDASUtil.mcPackedIntegerToDouble(nArray[21]);
        this.roll = McIDASUtil.mcPackedIntegerToDouble(nArray[22]);
        this.skew = (double)nArray[28] / 100000.0;
        if (nArray[28] == -2139062144) {
            this.skew = 0.0;
        }
        this.iajust = nArray[24];
        this.iseang = nArray[27];
        this.ibtcon = 6289920;
        this.negbet = 3144960;
        this.emega = 0.26251617;
        this.ab = 4.054685122E7;
        this.asq = 4.068383348E7;
        this.bsq = 4.041033018E7;
        this.r = 6371.221;
        this.rsq = this.r * this.r;
        this.rdpdg = 0.01745329252;
        this.numsen = this.lintot / 100000 % 100;
        if (this.numsen < 1) {
            this.numsen = 1;
        }
        this.totlin = this.numsen * (this.lintot % 100000);
        this.radlin = this.rdpdg * this.deglin / (this.totlin - 1.0);
        this.totele = this.ieltot;
        this.radele = this.rdpdg * this.degele / (this.totele - 1.0);
        this.picele = (1.0 + this.totele) / 2.0;
        this.cpitch = this.rdpdg * this.pitch;
        this.cyaw = this.rdpdg * this.yaw;
        this.croll = this.rdpdg * this.roll;
        this.pskew = Math.atan2(this.skew, this.radlin / this.radele);
        double d2 = Math.sin(this.cpitch);
        double d3 = Math.cos(this.cpitch);
        double d4 = Math.sin(this.cyaw - this.pskew);
        double d5 = Math.cos(this.cyaw - this.pskew);
        double d6 = Math.sin(this.croll);
        double d7 = Math.cos(this.croll);
        this.rotm11 = d7 * d3;
        this.rotm13 = d4 * d6 * d3 + d5 * d2;
        this.rotm21 = -d6;
        this.rotm23 = d4 * d7;
        this.rotm31 = -d7 * d2;
        this.rotm33 = d5 * d3 - d4 * d6 * d2;
        this.rfact = Math.pow(this.rotm31, 2.0) + Math.pow(this.rotm33, 2.0);
        this.roasin = Math.atan2(this.rotm31, this.rotm33);
        this.tmpscl = this.spinra / 3600000.0;
        double d8 = this.declin * this.rdpdg;
        double d9 = Math.sin(d8);
        double d10 = Math.cos(d8);
        double d11 = this.rascen * this.rdpdg;
        double d12 = Math.sin(d11);
        double d13 = Math.cos(d11);
        this.b11 = -d12;
        this.b12 = d13;
        this.b13 = 0.0;
        this.b21 = -d9 * d13;
        this.b22 = -d9 * d12;
        this.b23 = d10;
        this.b31 = d10 * d13;
        this.b32 = d10 * d12;
        this.b33 = d9;
        double d14 = McIDASUtil.timdif(74001, 0, this.navday, 0) * 1.00273791 / 4.0 + 100.26467;
        double d15 = d14 % 360.0;
        if (d15 < 0.0) {
            d15 += 360.0;
        }
        this.xref = d15 * this.rdpdg;
        this.pictim = McIDASUtil.mcPackedIntegerToDouble(n2);
        this.gamma = (double)nArray[38] / 100.0;
        this.gamdot = (double)nArray[39] / 100.0;
        int n4 = n / 100000;
        if ((n4 > 25 || n4 == 12) && nArray[30] > 0) {
            this.scan1 = nArray[30];
            this.time1 = McIDASUtil.mcPackedIntegerToDouble(nArray[31]);
            this.scan2 = nArray[34];
            this.time2 = McIDASUtil.mcPackedIntegerToDouble(nArray[35]);
        } else {
            this.scan1 = 1.0;
            this.time1 = McIDASUtil.mcPackedIntegerToDouble(n2);
            this.scan2 = this.lintot % 100000;
            this.time2 = this.time1 + this.scan2 * this.tmpscl;
        }
        this.iold = 0;
    }
}

