/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class GMSXnav
extends AREAnav {
    private static String fileName = "GMSXAREA";
    private static final double cdr = Math.PI / 180;
    private static final double crd = 57.29577951308232;
    private static final double hpai = 1.5707963267948966;
    private static final double dpai = Math.PI * 2;
    private static final double ea = 6378136.0;
    private static final double ef = 0.0033528131778969143;
    private byte[] bParms = new byte[3200];
    private int navType = 0;
    private float subLat;
    private float subLon;
    private float[] resLin = new float[4];
    private float[] resEle = new float[4];
    private float[] rlic = new float[4];
    private float[] relmfc = new float[4];
    private float[] senssu = new float[4];
    private float[] rline = new float[4];
    private float[] relem = new float[4];
    private float[] vmis = new float[3];
    private float[][] elmis = new float[3][3];
    private double lineOffset;
    private double dtims = 0.0;
    private double dspin = 0.0;
    private double sitagt = 0.0;
    private double sunalp = 0.0;
    private double sundel = 0.0;
    private double[] sat = new double[3];
    private double[] sp = new double[3];
    private double[] ss = new double[3];
    private double[][] orbt1 = new double[35][8];
    private double[][] atit = new double[10][10];

    public static void main(String[] stringArray) {
        int[] nArray = new int[800];
        int[] nArray2 = new int[64];
        DataInputStream dataInputStream = null;
        GMSXnav gMSXnav = null;
        System.out.println("unit test of class GMSXnav begin...");
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName), 2048));
        }
        catch (Exception exception) {
            System.out.println("error creating DataInputStream: " + exception);
            System.exit(0);
        }
        System.out.println("reading in, discarding directory words...");
        try {
            int n = 0;
            while (n < 64) {
                nArray2[n] = dataInputStream.readInt();
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("error reading area file directory: " + iOException);
            System.exit(0);
        }
        System.out.println("reading in navigation words...");
        try {
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = dataInputStream.readInt();
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("error reading area file navigation data: " + iOException);
            System.exit(0);
        }
        if (nArray[0] != 1196249944) {
            System.out.println("error: not a GMS navigation block.");
            System.exit(0);
        }
        System.out.println("creating GMSXnav object...");
        gMSXnav = new GMSXnav(nArray);
        gMSXnav.setImageStart(nArray2[5], nArray2[6]);
        gMSXnav.setRes(nArray2[11], nArray2[12]);
        gMSXnav.setStart(1, 1);
        gMSXnav.setFlipLineCoordinates(nArray2[8]);
        System.out.println(" test of toLatLon...");
        System.out.println("  answer should be close to: -2.37, 133.31");
        double[][] dArray = new double[2][1];
        double[][] dArray2 = new double[2][1];
        dArray[gMSXnav.indexLine][0] = 471.0;
        dArray[gMSXnav.indexEle][0] = 323.0;
        dArray2 = gMSXnav.toLatLon(dArray);
        System.out.println("  answer is: " + dArray2[gMSXnav.indexLat][0] + ", " + dArray2[gMSXnav.indexLon][0]);
        System.out.println(" test of toLinEle...");
        System.out.println("  answer should be close to: 480.0, 1.0");
        dArray2[gMSXnav.indexLat][0] = -2.0;
        dArray2[gMSXnav.indexLon][0] = 118.0;
        dArray = gMSXnav.toLinEle(dArray2);
        System.out.println("  answer is: " + dArray[gMSXnav.indexLine][0] + ", " + dArray[gMSXnav.indexEle][0]);
        System.out.println("  answer should be close to: 16.0, 628.0");
        dArray2[gMSXnav.indexLat][0] = -24.0;
        dArray2[gMSXnav.indexLon][0] = 148.0;
        dArray = gMSXnav.toLinEle(dArray2);
        System.out.println("  answer is: " + dArray[gMSXnav.indexLine][0] + ", " + dArray[gMSXnav.indexEle][0]);
        System.out.println("unit test of class GMSXnav end...");
    }

    public double[][] toLinEle(double[][] dArray) {
        int n = 1;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[2][n2];
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            dArray2[1][n3] = Double.NaN;
            dArray2[0][n3] = Double.NaN;
            if (!(Math.abs(dArray[0][n3]) > 90.0) && !(Math.abs(dArray[1][n3]) > 180.0)) {
                float[] fArray = this.mgivsr(n, (float)d2, (float)d, (float)dArray[1][n3], (float)dArray[0][n3]);
                dArray2[1][n3] = fArray[0];
                dArray2[0][n3] = fArray[1];
            }
            ++n3;
        }
        return this.imageCoordToAreaCoord(dArray2);
    }

    public double[][] toLatLon(double[][] dArray) {
        int n = -1;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[2][n2];
        double d = 0.0;
        double d2 = 0.0;
        double[][] dArray3 = this.areaCoordToImageCoord(dArray);
        int n3 = 0;
        while (n3 < n2) {
            dArray2[0][n3] = Double.NaN;
            dArray2[1][n3] = Double.NaN;
            float[] fArray = this.mgivsr(n, (float)dArray3[0][n3], (float)dArray3[1][n3], (float)d2, (float)d);
            if (fArray[1] < 0.0f) {
                fArray[1] = (float)((double)fArray[1] + 360.0);
            }
            dArray2[0][n3] = fArray[0];
            dArray2[1][n3] = fArray[1];
            ++n3;
        }
        return dArray2;
    }

    private double sv0100(int n, int n2, byte[] byArray, int n3) {
        int n4;
        boolean bl = false;
        int[] nArray = new int[6];
        double d = 0.0;
        if (byArray[n3] < 0) {
            bl = true;
        }
        if (n == 4) {
            n4 = 1;
            while (n4 < 4) {
                nArray[n4] = byArray[n4 + n3] < 0 ? (byArray[n4 + n3] & 0x7F) + 128 : byArray[n4 + n3];
                ++n4;
            }
            d = (double)(byArray[n3] & 0x7F) * 1.6777216E7 + (double)nArray[1] * 65536.0 + (double)nArray[2] * 256.0 + (double)nArray[3];
        }
        if (n == 6) {
            n4 = 1;
            while (n4 < 6) {
                nArray[n4] = byArray[n4 + n3] < 0 ? (byArray[n4 + n3] & 0x7F) + 128 : byArray[n4 + n3];
                ++n4;
            }
            d = (double)(byArray[n3] & 0x7F) * Math.pow(2.0, 40.0) + (double)nArray[1] * Math.pow(2.0, 32.0) + (double)nArray[2] * 1.6777216E7 + (double)nArray[3] * 65536.0 + (double)nArray[4] * 256.0 + (double)nArray[5];
        }
        d /= Math.pow(10.0, n2);
        if (bl) {
            d = -d;
        }
        return d;
    }

    private void decOABlock(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        double d = 0.0;
        this.dtims = this.sv0100(6, 8, byArray, 0);
        this.dspin = this.sv0100(6, 8, byArray, 240);
        this.resLin[0] = (float)this.sv0100(4, 8, byArray, 6);
        this.resLin[1] = (float)this.sv0100(4, 8, byArray, 10);
        this.resLin[2] = (float)this.sv0100(4, 8, byArray, 10);
        this.resLin[3] = (float)this.sv0100(4, 8, byArray, 10);
        this.resEle[0] = (float)this.sv0100(4, 10, byArray, 14);
        this.resEle[1] = (float)this.sv0100(4, 10, byArray, 18);
        this.resEle[2] = (float)this.sv0100(4, 10, byArray, 18);
        this.resEle[3] = (float)this.sv0100(4, 10, byArray, 18);
        this.rlic[0] = (float)this.sv0100(4, 4, byArray, 22);
        this.rlic[1] = (float)this.sv0100(4, 4, byArray, 26);
        this.rlic[2] = (float)this.sv0100(4, 4, byArray, 110);
        this.rlic[3] = (float)this.sv0100(4, 4, byArray, 114);
        this.relmfc[0] = (float)this.sv0100(4, 4, byArray, 30);
        this.relmfc[1] = (float)this.sv0100(4, 4, byArray, 34);
        this.relmfc[2] = (float)this.sv0100(4, 4, byArray, 118);
        this.relmfc[3] = (float)this.sv0100(4, 4, byArray, 122);
        this.senssu[0] = (float)this.sv0100(4, 0, byArray, 38);
        this.senssu[1] = (float)this.sv0100(4, 0, byArray, 42);
        this.senssu[2] = (float)this.sv0100(4, 0, byArray, 42);
        this.senssu[3] = (float)this.sv0100(4, 0, byArray, 42);
        this.rline[0] = (float)this.sv0100(4, 0, byArray, 46);
        this.rline[1] = (float)this.sv0100(4, 0, byArray, 50);
        this.rline[2] = (float)this.sv0100(4, 0, byArray, 50);
        this.rline[3] = (float)this.sv0100(4, 0, byArray, 50);
        this.relem[0] = (float)this.sv0100(4, 0, byArray, 54);
        this.relem[1] = (float)this.sv0100(4, 0, byArray, 58);
        this.relem[2] = (float)this.sv0100(4, 0, byArray, 58);
        this.relem[3] = (float)this.sv0100(4, 0, byArray, 58);
        this.vmis[0] = (float)this.sv0100(4, 10, byArray, 62);
        this.vmis[1] = (float)this.sv0100(4, 10, byArray, 66);
        this.vmis[2] = (float)this.sv0100(4, 10, byArray, 70);
        this.elmis[0][0] = (float)this.sv0100(4, 7, byArray, 74);
        this.elmis[1][0] = (float)this.sv0100(4, 10, byArray, 78);
        this.elmis[2][0] = (float)this.sv0100(4, 10, byArray, 82);
        this.elmis[0][1] = (float)this.sv0100(4, 10, byArray, 86);
        this.elmis[1][1] = (float)this.sv0100(4, 7, byArray, 90);
        this.elmis[2][1] = (float)this.sv0100(4, 10, byArray, 94);
        this.elmis[0][2] = (float)this.sv0100(4, 10, byArray, 98);
        this.elmis[1][2] = (float)this.sv0100(4, 10, byArray, 102);
        this.elmis[2][2] = (float)this.sv0100(4, 7, byArray, 106);
        this.subLon = (float)this.sv0100(6, 6, byArray, 198);
        this.subLat = (float)this.sv0100(6, 6, byArray, 204);
        n2 = 0;
        while (n2 < 10) {
            if (n == 1) {
                n3 = (n2 - 1) * 64 + 256;
            }
            if (n == 0) {
                n3 = (n2 - 1) * 48 + 256;
            }
            this.atit[0][n2] = this.sv0100(6, 8, byArray, n3);
            this.atit[2][n2] = this.sv0100(6, 8, byArray, n3 + 12);
            this.atit[3][n2] = this.sv0100(6, 11, byArray, n3 + 18);
            this.atit[4][n2] = this.sv0100(6, 8, byArray, n3 + 24);
            this.atit[5][n2] = this.sv0100(6, 8, byArray, n3 + 30);
            ++n2;
        }
        n2 = 0;
        while (n2 < 8) {
            if (n == 1) {
                n3 = (n2 - 1) * 256 + 896;
            }
            if (n == 0) {
                n3 = (n2 - 1) * 200 + 736;
            }
            this.orbt1[0][n2] = this.sv0100(6, 8, byArray, n3);
            this.orbt1[8][n2] = this.sv0100(6, 6, byArray, n3 + 48);
            this.orbt1[9][n2] = this.sv0100(6, 6, byArray, n3 + 54);
            this.orbt1[10][n2] = this.sv0100(6, 6, byArray, n3 + 60);
            this.orbt1[14][n2] = this.sv0100(6, 8, byArray, n3 + 84);
            this.orbt1[17][n2] = this.sv0100(6, 8, byArray, n3 + 102);
            this.orbt1[18][n2] = this.sv0100(6, 8, byArray, n3 + 108);
            this.orbt1[19][n2] = this.sv0100(6, 12, byArray, n3 + 128);
            this.orbt1[20][n2] = this.sv0100(6, 14, byArray, n3 + 134);
            this.orbt1[21][n2] = this.sv0100(6, 14, byArray, n3 + 140);
            this.orbt1[22][n2] = this.sv0100(6, 14, byArray, n3 + 146);
            this.orbt1[23][n2] = this.sv0100(6, 12, byArray, n3 + 152);
            this.orbt1[24][n2] = this.sv0100(6, 16, byArray, n3 + 158);
            this.orbt1[25][n2] = this.sv0100(6, 12, byArray, n3 + 164);
            this.orbt1[26][n2] = this.sv0100(6, 16, byArray, n3 + 170);
            this.orbt1[27][n2] = this.sv0100(6, 12, byArray, n3 + 176);
            ++n2;
        }
    }

    private void subLatLon(float[] fArray) {
    }

    private float[] mgivsr(int n, float f, float f2, float f3, float f4) {
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        double d;
        double d2;
        double[] dArray4;
        double[] dArray5;
        int n2 = 0;
        float[] fArray = new float[2];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        fArray[0] = Float.NaN;
        fArray[1] = Float.NaN;
        if (Math.abs(n) > 4) {
            n2 = 1;
            return fArray;
        }
        if (Math.abs(f4) > 90.0f && n > 0) {
            n2 = 2;
            return fArray;
        }
        int n3 = Math.abs(n) - 1;
        float f5 = this.resLin[n3];
        float f6 = this.resEle[n3];
        float f7 = this.rlic[n3];
        float f8 = this.relmfc[n3];
        float f9 = this.senssu[n3];
        float f10 = (float)((double)this.rline[n3] + 0.5);
        float f11 = (float)((double)this.relem[n3] + 0.5);
        if (n > 0) {
            float f12;
            float f13;
            d4 = (double)f4 * (Math.PI / 180);
            d5 = (double)f3 * (Math.PI / 180);
            double d9 = 0.006694384999587949;
            double d10 = 6378136.0 / Math.sqrt(1.0 - d9 * Math.sin(d4) * Math.sin(d4));
            dArray6[0] = d10 * Math.cos(d4) * Math.cos(d5);
            dArray6[1] = d10 * Math.cos(d4) * Math.sin(d5);
            dArray6[2] = d10 * (1.0 - d9) * Math.sin(d4);
            float f14 = (float)((double)f7 - Math.atan(Math.sin(d4) / (6.610689 - Math.cos(d4))) / (double)f5);
            d6 = this.dtims + (double)(f14 / f9) / 1440.0 / this.dspin;
            while (true) {
                d3 = this.mg1100(d6);
                dArray5 = this.mg1220(this.sp, this.ss);
                dArray4 = this.mg1220(dArray5, this.sp);
                d2 = Math.cos(d3);
                d = Math.sin(d3);
                dArray8[0] = dArray5[0] * d + dArray4[0] * d2;
                dArray8[1] = dArray5[1] * d + dArray4[1] * d2;
                dArray8[2] = dArray5[2] * d + dArray4[2] * d2;
                dArray3 = this.mg1200(dArray8);
                dArray2 = this.mg1220(this.sp, dArray3);
                dArray7[0] = dArray6[0] - this.sat[0];
                dArray7[1] = dArray6[1] - this.sat[1];
                dArray7[2] = dArray6[2] - this.sat[2];
                dArray = this.mg1200(dArray7);
                dArray4 = this.mg1210(this.sp, dArray);
                dArray8 = this.mg1210(dArray2, dArray4);
                d8 = this.mg1230(dArray2, dArray4);
                double d11 = this.sp[0] * dArray8[0] + this.sp[1] * dArray8[1] + this.sp[2] * dArray8[2];
                if (d11 < 0.0) {
                    d8 = -d8;
                }
                d7 = this.mg1230(this.sp, dArray);
                f13 = (float)(1.5707963267948966 - d7) / f5 + f7 - this.vmis[1] / f5;
                f12 = (float)(d8 / (double)f6 + (double)f8 + (double)(this.vmis[2] / f6) - (1.5707963267948966 - d7) * Math.tan(this.vmis[0]) / (double)f6);
                if (!((double)Math.abs(f13 - f14) >= 1.0)) break;
                d6 = (Math.rint((f13 - 1.0f) / f9) + (double)(f12 * f6) / (Math.PI * 2)) / (this.dspin * 1440.0) + this.dtims;
                f14 = f13;
            }
            fArray[0] = f13;
            fArray[1] = f12;
            f2 = f13;
            f = f12;
            if (f2 < 0.0f || f2 > f10) {
                n2 = 4;
            }
            if (f < 0.0f || f > f10) {
                n2 = 5;
            }
        }
        if (n < 0) {
            double d12;
            double d13;
            d6 = (Math.rint((f2 - 1.0f) / f9) + (double)(f * f6) / (Math.PI * 2)) / (this.dspin * 1440.0) + this.dtims;
            d3 = this.mg1100(d6);
            dArray5 = this.mg1220(this.sp, this.ss);
            dArray4 = this.mg1220(dArray5, this.sp);
            d2 = Math.cos(d3);
            d = Math.sin(d3);
            dArray8[0] = dArray5[0] * d + dArray4[0] * d2;
            dArray8[1] = dArray5[1] * d + dArray4[1] * d2;
            dArray8[2] = dArray5[2] * d + dArray4[2] * d2;
            dArray3 = this.mg1200(dArray8);
            dArray2 = this.mg1220(this.sp, dArray3);
            double d14 = Math.cos(f5 * (f2 - f7));
            double d15 = Math.sin(f5 * (f2 - f7));
            double d16 = Math.cos(f6 * (f - f8));
            double d17 = Math.sin(f6 * (f - f8));
            dArray5[0] = (double)this.elmis[0][0] * d14 + (double)this.elmis[0][2] * d15;
            dArray5[1] = (double)this.elmis[1][0] * d14 + (double)this.elmis[1][2] * d15;
            dArray5[2] = (double)this.elmis[2][0] * d14 + (double)this.elmis[2][2] * d15;
            dArray4[0] = d16 * dArray5[0] - d17 * dArray5[1];
            dArray4[1] = d17 * dArray5[0] + d16 * dArray5[1];
            dArray4[2] = dArray5[2];
            dArray8[0] = dArray3[0] * dArray4[0] + dArray2[0] * dArray4[1] + this.sp[0] * dArray4[2];
            dArray8[1] = dArray3[1] * dArray4[0] + dArray2[1] * dArray4[1] + this.sp[1] * dArray4[2];
            dArray8[2] = dArray3[2] * dArray4[0] + dArray2[2] * dArray4[1] + this.sp[2] * dArray4[2];
            double d18 = 0.993305615000412;
            dArray = this.mg1200(dArray8);
            double d19 = d18 * (this.sat[0] * dArray[0] + this.sat[1] * dArray[1]) + this.sat[2] * dArray[2];
            double d20 = d19 * d19 - (d13 = d18 * (dArray[0] * dArray[0] + dArray[1] * dArray[1]) + dArray[2] * dArray[2]) * (d12 = d18 * (this.sat[0] * this.sat[0] + this.sat[1] * this.sat[1] - 4.0680618834496E13) + this.sat[2] * this.sat[2]);
            if (!(d20 >= 0.0) || d13 == 0.0) {
                n2 = 6;
                return fArray;
            }
            double d21 = (-d19 + Math.sqrt(d20)) / d13;
            double d22 = (-d19 - Math.sqrt(d20)) / d13;
            double d23 = Math.abs(d21) < Math.abs(d22) ? d21 : d22;
            dArray6[0] = this.sat[0] + d23 * dArray[0];
            dArray6[1] = this.sat[1] + d23 * dArray[1];
            dArray6[2] = this.sat[2] + d23 * dArray[2];
            d4 = Math.atan(dArray6[2] / (d18 * Math.sqrt(dArray6[0] * dArray6[0] + dArray6[1] * dArray6[1])));
            if (dArray6[0] != 0.0) {
                d5 = Math.atan(dArray6[1] / dArray6[0]);
                if (dArray6[0] < 0.0 && dArray6[1] >= 0.0) {
                    d5 += Math.PI;
                }
                if (dArray6[0] < 0.0 && dArray6[1] < 0.0) {
                    d5 -= Math.PI;
                }
            } else {
                d5 = dArray6[1] > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            }
            fArray[0] = (float)(d4 * 57.29577951308232);
            fArray[1] = (float)(d5 * 57.29577951308232);
        }
        return fArray;
    }

    private double mg1100(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[][] dArray4 = new double[3][3];
        int n = 0;
        while (n < 7) {
            if (d > this.orbt1[0][n] && d < this.orbt1[0][n + 1]) {
                dArray4 = this.mg1110(n, d, this.orbt1);
                break;
            }
            ++n;
        }
        n = 0;
        while (n < 9) {
            if (d >= this.atit[0][n] && d < this.atit[0][n + 1]) {
                d3 = (d - this.atit[0][n]) / (this.atit[0][n + 1] - this.atit[0][n]);
                d4 = this.atit[2][n] + (this.atit[2][n + 1] - this.atit[2][n]) * d3;
                d5 = this.atit[3][n] + (this.atit[3][n + 1] - this.atit[3][n]) * d3;
                d2 = this.atit[4][n] + (this.atit[4][n + 1] - this.atit[4][n]) * d3;
                if (!(this.atit[4][n + 1] - this.atit[4][n] > 0.0)) break;
                d2 = this.atit[4][n] + (this.atit[4][n + 1] - this.atit[4][n] - Math.PI * 2) * d3;
                break;
            }
            ++n;
        }
        d6 = Math.cos(d5);
        dArray[0] = Math.sin(d5);
        dArray[1] = d6 * -Math.sin(d4);
        dArray[2] = d6 * Math.cos(d4);
        dArray2[0] = dArray4[0][0] * dArray[0] + dArray4[0][1] * dArray[1] + dArray4[0][2] * dArray[2];
        dArray2[1] = dArray4[1][0] * dArray[0] + dArray4[1][1] * dArray[1] + dArray4[1][2] * dArray[2];
        dArray2[2] = dArray4[2][0] * dArray[0] + dArray4[2][1] * dArray[1] + dArray4[2][2] * dArray[2];
        d7 = Math.sin(this.sitagt);
        d6 = Math.cos(this.sitagt);
        dArray3[0] = d6 * dArray2[0] + d7 * dArray2[1];
        dArray3[1] = -d7 * dArray2[0] + d6 * dArray2[1];
        dArray3[2] = dArray2[2];
        this.sp = this.mg1200(dArray3);
        d6 = Math.cos(this.sundel);
        this.ss[0] = d6 * Math.cos(this.sunalp);
        this.ss[1] = d6 * Math.sin(this.sunalp);
        this.ss[2] = Math.sin(this.sundel);
        return d2;
    }

    private double[][] mg1110(int n, double d, double[][] dArray) {
        double[][] dArray2 = new double[3][3];
        if (n != 7) {
            double d2 = (d - dArray[0][n]) / (dArray[0][n + 1] - dArray[0][n]);
            this.sat[0] = dArray[8][n] + (dArray[8][n + 1] - dArray[8][n]) * d2;
            this.sat[1] = dArray[9][n] + (dArray[9][n + 1] - dArray[9][n]) * d2;
            this.sat[2] = dArray[10][n] + (dArray[10][n + 1] - dArray[10][n]) * d2;
            this.sitagt = (dArray[14][n] + (dArray[14][n + 1] - dArray[14][n]) * d2) * (Math.PI / 180);
            if (dArray[14][n + 1] - dArray[14][n] < 0.0) {
                this.sitagt = (dArray[14][n] + (dArray[14][n + 1] - dArray[14][n] + 360.0) * d2) * (Math.PI / 180);
            }
            this.sunalp = (dArray[17][n] + (dArray[17][n + 1] - dArray[17][n]) * d2) * (Math.PI / 180);
            if (dArray[17][n + 1] - dArray[17][n] > 0.0) {
                this.sunalp = (dArray[17][n] + (dArray[17][n + 1] - dArray[17][n] - 360.0) * d2) * (Math.PI / 180);
            }
            this.sundel = (dArray[18][n] + (dArray[18][n + 1] - dArray[18][n]) * d2) * (Math.PI / 180);
            dArray2[0][0] = dArray[19][n];
            dArray2[1][0] = dArray[20][n];
            dArray2[2][0] = dArray[21][n];
            dArray2[0][1] = dArray[22][n];
            dArray2[1][1] = dArray[23][n];
            dArray2[2][1] = dArray[24][n];
            dArray2[0][2] = dArray[25][n];
            dArray2[1][2] = dArray[26][n];
            dArray2[2][2] = dArray[27][n];
        }
        return dArray2;
    }

    private double[] mg1200(double[] dArray) {
        double[] dArray2 = new double[3];
        double d = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
        if (d == 0.0) {
            return dArray2;
        }
        double d2 = Math.sqrt(d);
        dArray2[0] = dArray[0] / d2;
        dArray2[1] = dArray[1] / d2;
        dArray2[2] = dArray[2] / d2;
        return dArray2;
    }

    private double[] mg1210(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        return dArray3;
    }

    private double[] mg1220(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        dArray3[0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
        dArray3[1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
        dArray3[2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
        dArray4 = this.mg1200(dArray3);
        return dArray4;
    }

    private double mg1230(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        double d3 = (dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]) * (dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
        if (d3 == 0.0) {
            return d;
        }
        d = Math.acos(d2 / Math.sqrt(d3));
        return d;
    }

    private double mg1240(double[] dArray, double[] dArray2, double[] dArray3, double d) {
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        dArray4 = this.mg1220(dArray3, dArray2);
        dArray5 = this.mg1220(dArray, dArray2);
        double d2 = this.mg1230(dArray4, dArray5);
        dArray6 = this.mg1220(dArray4, dArray5);
        double d3 = dArray6[0] * dArray2[0] + dArray6[1] * dArray2[1] + dArray6[2] * dArray2[2];
        if (d3 > 0.0) {
            d2 = d - d2;
        }
        return d2;
    }

    public static byte[] intToBytes(int n) {
        byte[] byArray = new byte[4];
        int n2 = 255;
        int n3 = 0;
        while (n3 < 4) {
            byArray[3 - n3] = (byte)((n & n2 << n3 * 8) >> n3 * 8);
            ++n3;
        }
        return byArray;
    }

    public GMSXnav(int[] nArray) {
        int n;
        byte[] byArray;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 126) {
            byArray = GMSXnav.intToBytes(nArray[n3 + 1]);
            n = 0;
            while (n < 4) {
                this.bParms[n2] = byArray[n];
                ++n2;
                ++n;
            }
            ++n3;
        }
        int n4 = 128;
        int n5 = 0;
        while (n5 < 4) {
            n3 = 0;
            while (n3 < 127) {
                byArray = GMSXnav.intToBytes(nArray[n3 + n4]);
                n = 0;
                while (n < 4) {
                    this.bParms[n2] = byArray[n];
                    ++n2;
                    ++n;
                }
                ++n3;
            }
            n4 += 128;
            ++n5;
        }
        this.decOABlock(this.bParms, 0);
    }
}

