/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.McIDASException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;

public class EnhancementTable {
    private int[][] rgbValues = null;
    private DataInputStream dataStream;

    private void readRGBValues() throws McIDASException {
        this.rgbValues = new int[3][256];
        try {
            int n = this.dataStream.readInt();
            int n2 = 0;
            while (n2 < 3) {
                int n3 = 0;
                while (n3 < 256) {
                    this.rgbValues[n2][n3] = this.dataStream.readInt();
                    ++n3;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new McIDASException("Invalid enhancement table");
        }
    }

    public int[][] getRGBValues() {
        return this.rgbValues;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Brightness  Red       Green      Blue ");
        stringBuffer.append("\n");
        stringBuffer.append("  min max   min max   min max   min max");
        stringBuffer.append("\n");
        stringBuffer.append("  --- ---   --- ---   --- ---   --- ---");
        stringBuffer.append("\n");
        int n = 0;
        while (n < 256) {
            stringBuffer.append(" " + n + "  " + this.rgbValues[0][n] + " " + this.rgbValues[1][n] + " " + this.rgbValues[2][n]);
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            EnhancementTable enhancementTable = stringArray.length == 0 ? new EnhancementTable() : new EnhancementTable(stringArray[0]);
            System.out.println(enhancementTable.toString());
        }
        catch (McIDASException mcIDASException) {
            System.out.println(mcIDASException.toString());
        }
    }

    public EnhancementTable() {
        this.rgbValues = new int[3][256];
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 256) {
                this.rgbValues[n][n2] = n2;
                ++n2;
            }
            ++n;
        }
    }

    public EnhancementTable(String string) throws McIDASException {
        try {
            this.dataStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        }
        catch (Exception exception) {
            try {
                this.dataStream = new DataInputStream(new BufferedInputStream(new URL(string).openStream()));
            }
            catch (Exception exception2) {
                throw new McIDASException("Unable to open enhancement table " + string);
            }
        }
        this.readRGBValues();
    }

    public EnhancementTable(File file) throws McIDASException {
        try {
            this.dataStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (Exception exception) {
            throw new McIDASException("Unable to open enhancement table " + file);
        }
        this.readRGBValues();
    }

    public EnhancementTable(URL uRL) throws McIDASException {
        try {
            this.dataStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
        }
        catch (Exception exception) {
            throw new McIDASException("Unable to open enhancement table at URL" + uRL);
        }
        this.readRGBValues();
    }
}

