/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.GetAreaGUI;
import java.applet.Applet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class AreaFile {
    public static final int AD_STATUS = 0;
    public static final int AD_VERSION = 1;
    public static final int AD_SENSORID = 2;
    public static final int AD_IMGDATE = 3;
    public static final int AD_IMGTIME = 4;
    public static final int AD_STLINE = 5;
    public static final int AD_STELEM = 6;
    public static final int AD_NUMLINES = 8;
    public static final int AD_NUMELEMS = 9;
    public static final int AD_DATAWIDTH = 10;
    public static final int AD_LINERES = 11;
    public static final int AD_ELEMRES = 12;
    public static final int AD_NUMBANDS = 13;
    public static final int AD_PFXSIZE = 14;
    public static final int AD_PROJNUM = 15;
    public static final int AD_CRDATE = 16;
    public static final int AD_CRTIME = 17;
    public static final int AD_BANDMAP = 18;
    public static final int AD_DATAOFFSET = 33;
    public static final int AD_NAVOFFSET = 34;
    public static final int AD_VALCODE = 35;
    public static final int AD_STARTDATE = 45;
    public static final int AD_STARTTIME = 46;
    public static final int AD_STARTSCAN = 47;
    public static final int AD_DOCLENGTH = 48;
    public static final int AD_CALLENGTH = 49;
    public static final int AD_LEVLENGTH = 50;
    public static final int AD_SRCTYPE = 51;
    public static final int AD_CALTYPE = 52;
    public static final int AD_AVGSMPFLAG = 53;
    public static final int AD_SRCTYPEORIG = 56;
    public static final int AD_AUXOFFSET = 59;
    public static final int AD_CALOFFSET = 62;
    public static final int AD_DIRSIZE = 64;
    public static final int VERSION_NUMBER = 4;
    private static boolean handlerLoaded = false;
    private boolean flipwords;
    private boolean fileok;
    private boolean hasReadData = false;
    private DataInputStream af;
    private int status = 0;
    private int navLoc;
    private int calLoc;
    private int auxLoc;
    private int datLoc;
    private int navbytes;
    private int calbytes;
    private int auxbytes;
    private int linePrefixLength;
    private int lineDataLength;
    private int lineLength;
    private int numberLines;
    private long position;
    private int skipByteCount;
    private long newPosition;
    private int numBands;
    int[] dir;
    int[] nav;
    int[] cal;
    int[] aux;
    int[][][] data;
    private AreaDirectory areaDirectory;
    private String imageSource;
    private AREAnav areaNav;

    public static boolean isURLHandlerLoaded() {
        return handlerLoaded;
    }

    private void readMetaData() throws AreaFileException {
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile directory");
        }
        this.dir = new int[64];
        int n = 0;
        while (n < 64) {
            try {
                this.dir[n] = this.af.readInt();
            }
            catch (IOException iOException) {
                this.status = -1;
                throw new AreaFileException("Error reading AreaFile directory:" + iOException);
            }
            ++n;
        }
        this.position += 256L;
        if (this.dir[1] != 4) {
            McIDASUtil.flip(this.dir, 0, 19);
            if (this.dir[1] != 4) {
                throw new AreaFileException("Invalid version number - probably not an AREA file");
            }
            if ((this.dir[20] & 0xFFFF) == 0) {
                McIDASUtil.flip(this.dir, 20, 20);
            }
            McIDASUtil.flip(this.dir, 21, 23);
            McIDASUtil.flip(this.dir, 32, 50);
            McIDASUtil.flip(this.dir, 53, 55);
            McIDASUtil.flip(this.dir, 57, 63);
            this.flipwords = true;
        }
        this.areaDirectory = new AreaDirectory(this.dir);
        this.navLoc = this.dir[34];
        this.calLoc = this.dir[62];
        this.auxLoc = this.dir[59];
        this.datLoc = this.dir[33];
        this.numBands = this.dir[13];
        this.linePrefixLength = this.dir[48] + this.dir[49] + this.dir[50];
        if (this.dir[35] != 0) {
            this.linePrefixLength += 4;
        }
        if (this.linePrefixLength != this.dir[14]) {
            throw new AreaFileException("Invalid line prefix length in AREA file.");
        }
        this.lineDataLength = this.numBands * this.dir[9] * this.dir[10];
        this.lineLength = this.linePrefixLength + this.lineDataLength;
        this.numberLines = this.dir[8];
        if (this.datLoc > 0 && this.datLoc != -2139062144) {
            this.navbytes = this.datLoc - this.navLoc;
            this.calbytes = this.datLoc - this.calLoc;
            this.auxbytes = this.datLoc - this.auxLoc;
        }
        if (this.auxLoc > 0 && this.auxLoc != -2139062144) {
            this.navbytes = this.auxLoc - this.navLoc;
            this.calbytes = this.auxLoc - this.calLoc;
        }
        if (this.calLoc > 0 && this.calLoc != -2139062144) {
            this.navbytes = this.calLoc - this.navLoc;
        }
        if (this.navLoc > 0 && this.navbytes > 0) {
            this.nav = new int[this.navbytes / 4];
            this.newPosition = this.navLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException iOException) {
                this.status = -1;
                throw new AreaFileException("Error skipping AreaFile bytes: " + iOException);
            }
            n = 0;
            while (n < this.navbytes / 4) {
                try {
                    this.nav[n] = this.af.readInt();
                }
                catch (IOException iOException) {
                    this.status = -1;
                    throw new AreaFileException("Error reading AreaFile navigation:" + iOException);
                }
                ++n;
            }
            if (this.flipwords) {
                this.flipnav(this.nav);
            }
            this.position = this.navLoc + this.navbytes;
        }
        if (this.calLoc > 0 && this.calbytes > 0) {
            this.cal = new int[this.calbytes / 4];
            this.newPosition = this.calLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException iOException) {
                this.status = -1;
                throw new AreaFileException("Error skipping AreaFile bytes: " + iOException);
            }
            n = 0;
            while (n < this.calbytes / 4) {
                try {
                    this.cal[n] = this.af.readInt();
                }
                catch (IOException iOException) {
                    this.status = -1;
                    throw new AreaFileException("Error reading AreaFile calibration:" + iOException);
                }
                ++n;
            }
            this.position = this.calLoc + this.calbytes;
        }
        if (this.auxLoc > 0 && this.auxbytes > 0) {
            this.aux = new int[this.auxbytes / 4];
            this.newPosition = this.auxLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException iOException) {
                this.status = -1;
                throw new AreaFileException("Error skipping AreaFile bytes: " + iOException);
            }
            n = 0;
            while (n < this.auxbytes / 4) {
                try {
                    this.aux[n] = this.af.readInt();
                }
                catch (IOException iOException) {
                    this.status = -1;
                    throw new AreaFileException("Error reading AreaFile aux block:" + iOException);
                }
                ++n;
            }
            this.position = this.auxLoc + this.auxbytes;
        }
        this.status = 1;
    }

    public int[] getDir() throws AreaFileException {
        if (this.status <= 0) {
            throw new AreaFileException("Error reading AreaFile directory");
        }
        return this.dir;
    }

    public AreaDirectory getAreaDirectory() throws AreaFileException {
        if (this.status <= 0) {
            throw new AreaFileException("Error reading AreaFile directory");
        }
        return this.areaDirectory;
    }

    public int[] getNav() throws AreaFileException {
        if (this.status <= 0) {
            throw new AreaFileException("Error reading AreaFile navigation");
        }
        if (this.navLoc <= 0 || this.navLoc == -2139062144) {
            throw new AreaFileException("Error reading AreaFile navigation");
        }
        return this.nav;
    }

    public AREAnav getNavigation() throws AreaFileException {
        if (this.areaNav == null) {
            try {
                this.areaNav = AREAnav.makeAreaNav(this.getNav());
            }
            catch (McIDASException mcIDASException) {
                this.areaNav = null;
            }
        }
        return this.areaNav;
    }

    public int[] getCal() throws AreaFileException {
        if (this.status <= 0) {
            throw new AreaFileException("Error reading AreaFile calibration");
        }
        if (this.calLoc <= 0 || this.calLoc == -2139062144) {
            throw new AreaFileException("Error reading AreaFile calibration");
        }
        return this.cal;
    }

    public int[] getAux() throws AreaFileException {
        if (this.status <= 0) {
            throw new AreaFileException("Error reading AreaFile aux block");
        }
        if (this.auxLoc <= 0 || this.auxLoc == -2139062144) {
            throw new AreaFileException("Error reading AreaFile AUX block");
        }
        return this.aux;
    }

    public int[][][] getData() throws AreaFileException {
        if (!this.hasReadData) {
            this.readData();
        }
        return this.data;
    }

    public int[][] getData(int n, int n2, int n3, int n4) throws AreaFileException {
        return this.getData(n, n2, n3, n4, 1);
    }

    public int[][] getData(int n, int n2, int n3, int n4, int n5) throws AreaFileException {
        if (!this.hasReadData) {
            this.readData();
        }
        int[][] nArray = new int[n3][n4];
        int n6 = 0;
        while (n6 < n3) {
            int n7 = n6 + n;
            int n8 = 0;
            while (n8 < n4) {
                int n9 = n8 + n2;
                nArray[n6][n8] = n7 < 0 || n7 > this.dir[8] - 1 || n9 < 0 || n9 > this.dir[9] - 1 ? 0 : this.data[n5 - 1][n7][n9];
                ++n8;
            }
            ++n6;
        }
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    private void readData() throws AreaFileException {
        var4_1 = this.dir[8];
        var5_2 = this.dir[9];
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile data");
        }
        this.data = new int[this.numBands][var4_1][var5_2];
        var1_3 = 0;
        block4: while (var1_3 < var4_1) {
            block16: {
                try {
                    this.newPosition = this.datLoc + this.linePrefixLength + var1_3 * this.lineLength;
                    this.skipByteCount = (int)(this.newPosition - this.position);
                    this.af.skipBytes(this.skipByteCount);
                    this.position = this.newPosition;
                    break block16;
                }
                catch (IOException var8_9) {
                    var2_4 = 0;
                    ** while (var2_4 < var5_2)
                }
lbl-1000:
                // 1 sources

                {
                    var3_5 = 0;
                    while (var3_5 < this.numBands) {
                        this.data[var3_5][var1_3][var2_4] = 0;
                        ++var3_5;
                    }
                    ++var2_4;
                    continue;
lbl25:
                    // 1 sources

                    break block4;
                }
            }
            var2_4 = 0;
            while (var2_4 < var5_2) {
                var3_5 = 0;
                while (var3_5 < this.numBands) {
                    if (var2_4 > this.lineDataLength) {
                        this.data[var3_5][var1_3][var2_4] = 0;
                    } else {
                        try {
                            if (this.dir[10] == 1) {
                                this.data[var3_5][var1_3][var2_4] = this.af.readByte();
                                if (this.data[var3_5][var1_3][var2_4] < 0) {
                                    v0 = this.data[var3_5][var1_3];
                                    v1 = var2_4;
                                    v0[v1] = v0[v1] + 256;
                                }
                                ++this.position;
                            }
                            if (this.dir[10] == 2) {
                                var6_6 = this.af.readShort();
                                this.data[var3_5][var1_3][var2_4] = this.flipwords != false ? var6_6 >> 8 & 255 | var6_6 << 8 & 65280 : (int)var6_6;
                                this.position += 2L;
                            }
                            if (this.dir[10] == 4) {
                                var7_7 = this.af.readInt();
                                this.data[var3_5][var1_3][var2_4] = this.flipwords != false ? var7_7 >>> 24 & 255 | var7_7 >>> 8 & 65280 | (var7_7 & 255) << 24 | (var7_7 & 65280) << 8 : var7_7;
                                this.position += 4L;
                            }
                        }
                        catch (IOException var8_8) {
                            this.data[var3_5][var1_3][var2_4] = 0;
                        }
                    }
                    ++var3_5;
                }
                ++var2_4;
            }
            ++var1_3;
        }
    }

    private void flipnav(int[] nArray) {
        if (nArray[0] == 1196835154) {
            McIDASUtil.flip(nArray, 2, 126);
            McIDASUtil.flip(nArray, 129, 254);
            McIDASUtil.flip(nArray, 257, 382);
            McIDASUtil.flip(nArray, 385, 510);
            McIDASUtil.flip(nArray, 513, 638);
        } else if (nArray[0] == 1145918032) {
            McIDASUtil.flip(nArray, 1, 43);
            McIDASUtil.flip(nArray, 45, 51);
        } else if (nArray[0] == 1414091343) {
            McIDASUtil.flip(nArray, 1, 119);
        } else {
            McIDASUtil.flip(nArray, 1, nArray.length - 1);
        }
    }

    static /* synthetic */ String access$0(AreaFile areaFile) {
        return areaFile.imageSource;
    }

    static /* synthetic */ void access$1(AreaFile areaFile, String string) {
        areaFile.imageSource = string;
    }

    public AreaFile(String string) throws AreaFileException {
        this.imageSource = string;
        if (this.imageSource.startsWith("adde://") && this.imageSource.endsWith("image?")) {
            GetAreaGUI getAreaGUI = new GetAreaGUI(null, true, "Get data", false, true);
            getAreaGUI.addActionListener(new ActionListener(this){
                private final /* synthetic */ AreaFile this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    AreaFile.access$1(this.this$0, actionEvent.getActionCommand());
                }
                {
                    this.this$0 = areaFile;
                    this.constructor$0(areaFile);
                }

                private final void constructor$0(AreaFile areaFile) {
                }
            });
            getAreaGUI.show();
        }
        try {
            this.af = new DataInputStream(new BufferedInputStream(new FileInputStream(this.imageSource), 2048));
        }
        catch (IOException iOException) {
            try {
                URL uRL = new URL(this.imageSource);
                URLConnection uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
                this.af = new DataInputStream(new BufferedInputStream(inputStream));
            }
            catch (Exception exception) {
                this.fileok = false;
                throw new AreaFileException("Error opening AreaFile: " + exception);
            }
        }
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    public AreaFile(String string, Applet applet) throws AreaFileException {
        URL uRL;
        try {
            uRL = new URL(applet.getDocumentBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            this.fileok = false;
            throw new AreaFileException("Error opening URL for AreaFile:" + malformedURLException);
        }
        try {
            this.af = new DataInputStream(new BufferedInputStream(uRL.openStream()));
        }
        catch (IOException iOException) {
            this.fileok = false;
            throw new AreaFileException("Error opening AreaFile:" + iOException);
        }
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    public AreaFile(URL uRL) throws AreaFileException {
        try {
            this.af = new DataInputStream(new BufferedInputStream(uRL.openStream()));
        }
        catch (IOException iOException) {
            this.fileok = false;
            throw new AreaFileException("Error opening URL for AreaFile:" + iOException);
        }
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    static {
        try {
            String string = System.getProperty("java.protocol.handler.pkgs");
            String string2 = null;
            if (string == null) {
                string2 = "edu.wisc.ssec.mcidas";
            } else if (string.indexOf("edu.wisc.ssec.mcidas") < 0) {
                string2 = "edu.wisc.ssec.mcidas | " + string;
            }
            if (string2 != null) {
                System.setProperty("java.protocol.handler.pkgs", string2);
            }
            handlerLoaded = true;
        }
        catch (Exception exception) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
        handlerLoaded = true;
    }
}

