/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class AreaDirectoryList {
    private boolean flipwords;
    private DataInputStream inputStream;
    private int status;
    private URLConnection urlc;
    private boolean isADDE;
    private int[] dir;
    private Date[] nominalTimes;
    private int[] bands;
    private int[] lines;
    private int[] elements;
    private ArrayList dirs;
    private int numDirs;
    private AreaDirectory ad;

    private void readDirectory() throws AreaFileException {
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        int n = 0;
        String string = " ";
        String string2 = " ";
        this.dirs = new ArrayList();
        int n2 = this.isADDE ? ((AddeURLConnection)this.urlc).getInitialRecordSize() : 64;
        while (n2 > 0) {
            try {
                int n3;
                this.dir = new int[64];
                if (this.isADDE && (n3 = this.inputStream.readInt()) == 0) break;
                n3 = 0;
                while (n3 < 64) {
                    this.dir[n3] = this.inputStream.readInt();
                    ++n3;
                }
                if (!this.isADDE) {
                    this.dir[0] = 0;
                }
                if (this.dir[1] > 255 || this.flipwords) {
                    this.flipwords = true;
                    McIDASUtil.flip(this.dir, 0, 19);
                    if ((this.dir[20] & 0xFFFF) == 0) {
                        McIDASUtil.flip(this.dir, 20, 20);
                    }
                    McIDASUtil.flip(this.dir, 21, 23);
                    McIDASUtil.flip(this.dir, 32, 50);
                    McIDASUtil.flip(this.dir, 53, 55);
                    McIDASUtil.flip(this.dir, 57, 63);
                }
                AreaDirectory areaDirectory = new AreaDirectory(this.dir);
                int[] nArray = areaDirectory.getBands();
                int n4 = areaDirectory.getNumberOfBands();
                Vector[] vectorArray = new Vector[n4];
                int n5 = 0;
                while (n5 < n4) {
                    vectorArray[n5] = new Vector();
                    ++n5;
                }
                if (!this.isADDE) {
                    n2 = 0;
                } else {
                    n5 = this.dir[63];
                    int n6 = 0;
                    while (n6 < n5) {
                        int n7;
                        byte[] byArray = new byte[80];
                        int n8 = 0;
                        boolean bl = true;
                        int n9 = 0;
                        while (n9 < 80) {
                            n7 = this.inputStream.readByte();
                            if (n7 == 32) {
                                if (!bl) {
                                    byArray[n8++] = n7;
                                    bl = false;
                                }
                                bl = true;
                            } else {
                                byArray[n8++] = n7;
                                bl = false;
                            }
                            ++n9;
                        }
                        String string3 = new String(byArray, 0, n8);
                        if (string3.indexOf("Center latitude") > -1) {
                            n7 = string3.indexOf("=");
                            d3 = n7 > 0 ? Double.valueOf(string3.substring(n7 + 1).trim()) : Double.NaN;
                        } else if (string3.indexOf("Center longitude") > -1) {
                            n7 = string3.indexOf("=");
                            d4 = n7 > 0 ? -Double.valueOf(string3.substring(n7 + 1).trim()).doubleValue() : Double.NaN;
                        } else if (string3.indexOf("Computed Latitude") > -1) {
                            n7 = string3.indexOf("=");
                            d = n7 > 0 ? Double.valueOf(string3.substring(n7 + 1).trim()) : Double.NaN;
                        } else if (string3.indexOf("Computed Longitude") > -1) {
                            n7 = string3.indexOf("=");
                            d2 = n7 > 0 ? Double.valueOf(string3.substring(n7 + 1).trim()) : Double.NaN;
                        } else if (string3.indexOf("Valid calibration unit") > -1 && (n7 = string3.indexOf("=")) > 0) {
                            String string4 = string3.replace('\"', ' ');
                            StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
                            int n10 = stringTokenizer.countTokens();
                            n = 0;
                            string = " ";
                            string2 = " ";
                            boolean bl2 = false;
                            int n11 = 0;
                            while (n11 < n10) {
                                if (stringTokenizer.nextToken().trim().equals("band")) {
                                    bl2 = true;
                                    break;
                                }
                                ++n11;
                            }
                            if (bl2) {
                                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                                stringTokenizer.nextToken();
                                string = stringTokenizer.nextToken();
                                string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : string;
                                n11 = 0;
                                while (n11 < n4) {
                                    if (n == nArray[n11]) {
                                        vectorArray[n11].addElement(string);
                                        vectorArray[n11].addElement(string2);
                                    }
                                    ++n11;
                                }
                            }
                        }
                        ++n6;
                    }
                    areaDirectory.setCenterLatitude(d3);
                    areaDirectory.setCenterLongitude(d4);
                    areaDirectory.setCenterLatitudeResolution(d);
                    areaDirectory.setCenterLongitudeResolution(d2);
                    areaDirectory.setCalInfo(vectorArray);
                    n2 = this.inputStream.readInt();
                }
                this.dirs.add(areaDirectory);
            }
            catch (IOException iOException) {
                this.status = -1;
                throw new AreaFileException("Error reading Area directory:" + iOException);
            }
            this.status = 1;
            ++this.numDirs;
        }
    }

    public AreaDirectory[][] getSortedDirs() throws AreaFileException {
        int n;
        if (this.status <= 0 || this.dirs.size() <= 0) {
            throw new AreaFileException("Error reading directory information");
        }
        Date[] dateArray = new Date[this.numDirs];
        int[] nArray = new int[this.numDirs];
        int[] nArray2 = new int[this.numDirs];
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = null;
        int n2 = 0;
        while (n2 < this.numDirs) {
            AreaDirectory areaDirectory = (AreaDirectory)this.dirs.get(n2);
            dateArray[n2] = areaDirectory.getNominalTime();
            nArray[n2] = areaDirectory.getValue(0);
            nArray2[n2] = n2;
            ++n2;
        }
        Date date = null;
        int n3 = 0;
        while (n3 < this.numDirs) {
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < this.numDirs) {
                if (dateArray[n4].compareTo(dateArray[n5]) > 0) {
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                Date date2 = dateArray[n3];
                dateArray[n3] = dateArray[n4];
                dateArray[n4] = date2;
                n = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n;
                n = nArray2[n3];
                nArray2[n3] = nArray2[n4];
                nArray2[n4] = n;
            }
            if (date == null || date.compareTo(dateArray[n3]) != 0) {
                if (date != null) {
                    arrayList.add(arrayList2);
                }
                date = dateArray[n3];
                arrayList2 = new ArrayList();
            }
            arrayList2.add(this.dirs.get(nArray2[n3]));
            ++n3;
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            arrayList.add(arrayList2);
        }
        if ((n3 = arrayList.size()) == 0) {
            return null;
        }
        AreaDirectory[][] areaDirectoryArray = new AreaDirectory[n3][];
        int n6 = 0;
        while (n6 < n3) {
            arrayList2 = (ArrayList)arrayList.get(n6);
            n = arrayList2.size();
            areaDirectoryArray[n6] = new AreaDirectory[n];
            int n7 = 0;
            while (n7 < n) {
                areaDirectoryArray[n6][n7] = (AreaDirectory)arrayList2.get(n7);
                ++n7;
            }
            ++n6;
        }
        return areaDirectoryArray;
    }

    public ArrayList getDirs() throws AreaFileException {
        if (this.status <= 0 || this.dirs.size() <= 0) {
            throw new AreaFileException("Error reading directory information");
        }
        return this.dirs;
    }

    public String toString() {
        if (this.status <= 0 || this.numDirs <= 0) {
            return new String("No directory information available");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    Date         Time    Lin  Ele  Bands \n");
        stringBuffer.append("  -------       -------  ---  ---  --------\n");
        int n = 0;
        while (n < this.dirs.size()) {
            stringBuffer.append(((AreaDirectory)this.dirs.get(n)).toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Must supply a path or ADDE request to images");
            System.exit(1);
        }
        AreaDirectoryList areaDirectoryList = new AreaDirectoryList(stringArray[0]);
        System.out.println(areaDirectoryList.toString());
    }

    public AreaDirectoryList(String string) throws AreaFileException {
        block4: {
            this.flipwords = false;
            this.status = 0;
            this.isADDE = false;
            this.numDirs = 0;
            try {
                this.inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 2048));
            }
            catch (IOException iOException) {
                URL uRL;
                try {
                    uRL = new URL(string);
                    this.urlc = uRL.openConnection();
                    InputStream inputStream = this.urlc.getInputStream();
                    this.inputStream = new DataInputStream(new BufferedInputStream(inputStream));
                }
                catch (Exception exception) {
                    throw new AreaFileException("Error opening AreaFile: " + exception);
                }
                if (!uRL.getProtocol().equalsIgnoreCase("adde")) break block4;
                this.isADDE = true;
            }
        }
        this.readDirectory();
    }

    public AreaDirectoryList(URL uRL) throws AreaFileException {
        this.flipwords = false;
        this.status = 0;
        this.isADDE = false;
        this.numDirs = 0;
        try {
            this.inputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
        }
        catch (IOException iOException) {
            throw new AreaFileException("Error opening URL for AreaFile:" + iOException);
        }
        this.readDirectory();
    }

    static {
        try {
            String string = System.getProperty("java.protocol.handler.pkgs");
            String string2 = null;
            if (string == null) {
                string2 = "edu.wisc.ssec.mcidas";
            } else if (string.indexOf("edu.wisc.ssec.mcidas") < 0) {
                string2 = "edu.wisc.ssec.mcidas | " + string;
            }
            if (string2 != null) {
                System.setProperty("java.protocol.handler.pkgs", string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

