/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.GMSXnav;
import edu.wisc.ssec.mcidas.GOESnav;
import edu.wisc.ssec.mcidas.GVARnav;
import edu.wisc.ssec.mcidas.LAMBnav;
import edu.wisc.ssec.mcidas.MERCnav;
import edu.wisc.ssec.mcidas.MOLLnav;
import edu.wisc.ssec.mcidas.MSATnav;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.PSnav;
import edu.wisc.ssec.mcidas.RADRnav;
import edu.wisc.ssec.mcidas.RECTnav;
import edu.wisc.ssec.mcidas.TANCnav;
import java.io.Serializable;

public abstract class AREAnav
implements Serializable {
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final int DMSP = 1145918032;
    public static final int GMSX = 1196249944;
    public static final int GOES = 1196377427;
    public static final int GVAR = 1196835154;
    public static final int MOLL = 1297042508;
    public static final int MSAT = 1297301844;
    public static final int POES = 1414091343;
    public static final int RADR = 1380009042;
    public static final int RECT = 1380270932;
    public static final int PS = 1347624992;
    public static final int MERC = 1296388675;
    public static final int TANC = 1413566019;
    public static final int LAMB = 1279348034;
    public static final int LL = 123;
    public static final int XY = 234;
    public final int indexLine;
    public final int indexEle;
    public final int indexLat;
    public final int indexLon;
    private boolean isLineFlipped = false;
    private double lineOffset = 0.0;
    private float resLine = 1.0f;
    private float resElement = 1.0f;
    private float magLine = 1.0f;
    private float magElement = 1.0f;
    private float startLine = 0.0f;
    private float startElement = 0.0f;
    private float startImageLine = 0.0f;
    private float startImageElement = 0.0f;

    public abstract double[][] toLatLon(double[][] var1);

    public abstract double[][] toLinEle(double[][] var1);

    public void setRes(int n, int n2) {
        this.resLine = n;
        this.resElement = n2;
    }

    public void setRes(float f, float f2) {
        this.resLine = f;
        this.resElement = f2;
    }

    public void setMag(int n, int n2) {
        this.magLine = n;
        this.magElement = n2;
    }

    public void setMag(float f, float f2) {
        this.magLine = f;
        this.magElement = f2;
    }

    public void setStart(int n, int n2) {
        this.startLine = n;
        this.startElement = n2;
    }

    public void setImageStart(int n, int n2) {
        this.startImageLine = n;
        this.startImageElement = n2;
    }

    public void setFlipLineCoordinates(int n) {
        this.isLineFlipped = true;
        this.lineOffset = n;
    }

    public boolean isFlippedLineCoordinates() {
        return this.isLineFlipped;
    }

    public double getLineOffset() {
        return this.lineOffset;
    }

    public double[][] areaCoordToImageCoord(double[][] dArray) {
        double[][] dArray2 = new double[2][dArray[0].length];
        int n = 0;
        while (n < dArray[0].length) {
            double d = this.isLineFlipped ? this.lineOffset - dArray[1][n] : dArray[1][n];
            dArray2[1][n] = (double)this.startImageLine + (double)this.resLine * (d - (double)this.startLine) / (double)this.magLine;
            dArray2[0][n] = (double)this.startImageElement + (double)this.resElement * (dArray[0][n] - (double)this.startElement) / (double)this.magElement;
            ++n;
        }
        return dArray2;
    }

    public double[][] imageCoordToAreaCoord(double[][] dArray) {
        double[][] dArray2 = new double[2][dArray[0].length];
        int n = 0;
        while (n < dArray[0].length) {
            dArray2[1][n] = (double)this.startLine + (double)this.magLine * (dArray[1][n] - (double)this.startImageLine) / (double)this.resLine;
            if (this.isLineFlipped) {
                dArray2[1][n] = this.lineOffset - dArray2[1][n];
            }
            dArray2[0][n] = (double)this.startElement + (double)this.magElement * (dArray[0][n] - (double)this.startImageElement) / (double)this.resElement;
            ++n;
        }
        return dArray2;
    }

    public static AREAnav makeAreaNav(int[] nArray) throws McIDASException {
        AREAnav aREAnav = null;
        try {
            switch (nArray[0]) {
                case 1196835154: {
                    aREAnav = new GVARnav(nArray);
                    break;
                }
                case 1297042508: {
                    aREAnav = new MOLLnav(nArray);
                    break;
                }
                case 1297301844: {
                    aREAnav = new MSATnav(nArray);
                    break;
                }
                case 1380009042: {
                    aREAnav = new RADRnav(nArray);
                    break;
                }
                case 1380270932: {
                    aREAnav = new RECTnav(nArray);
                    break;
                }
                case 1196249944: {
                    aREAnav = new GMSXnav(nArray);
                    break;
                }
                case 1196377427: {
                    aREAnav = new GOESnav(nArray);
                    break;
                }
                case 1347624992: {
                    aREAnav = new PSnav(nArray);
                    break;
                }
                case 1296388675: {
                    aREAnav = new MERCnav(nArray);
                    break;
                }
                case 1279348034: {
                    aREAnav = new LAMBnav(nArray);
                    break;
                }
                case 1413566019: {
                    aREAnav = new TANCnav(nArray);
                    break;
                }
                default: {
                    throw new McIDASException("makeAreaNav: Unknown navigation type" + nArray[0]);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new McIDASException("Wrong nav block passed to AREAnav module");
        }
        return aREAnav;
    }

    public boolean equals(Object object) {
        if (object instanceof AREAnav) {
            AREAnav aREAnav = (AREAnav)object;
            return this.resLine == aREAnav.resLine && this.resElement == aREAnav.resElement && this.magLine == aREAnav.magLine && this.magElement == aREAnav.magElement && this.startLine == aREAnav.startLine && this.startElement == aREAnav.startElement && this.startImageLine == aREAnav.startImageLine && this.startImageElement == aREAnav.startImageElement && this.isLineFlipped == aREAnav.isLineFlipped && this.lineOffset == aREAnav.lineOffset;
        }
        return false;
    }

    public AREAnav() {
        this.indexLine = 1;
        this.indexEle = 0;
        this.indexLat = 0;
        this.indexLon = 1;
    }
}

