/*
 * Decompiled with CFR 0.152.
 */
package dods.util;

import dods.dap.BaseType;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.DByte;
import dods.dap.DDS;
import dods.dap.DFloat32;
import dods.dap.DFloat64;
import dods.dap.DGrid;
import dods.dap.DInt16;
import dods.dap.DInt32;
import dods.dap.DList;
import dods.dap.DSequence;
import dods.dap.DString;
import dods.dap.DStructure;
import dods.dap.DUInt16;
import dods.dap.DUInt32;
import dods.dap.DURL;
import dods.dap.NoSuchVariableException;
import java.util.Enumeration;

public class dasTools {
    public static boolean nameInKillFile(String string) {
        return false;
    }

    public static boolean nameInDDS(String string, DDS dDS) {
        boolean bl = true;
        try {
            dDS.getVariable(string);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            bl = false;
        }
        return bl;
    }

    public static boolean nameIsGlobal(String string) {
        String string2 = string.toLowerCase();
        boolean bl = false;
        if (string2.indexOf("global") >= 0) {
            bl = true;
        }
        if (string2.indexOf("dods") >= 0) {
            bl = true;
        }
        return bl;
    }

    public static String fancyTypeName(BaseType baseType) {
        if (baseType instanceof DByte) {
            return "8 bit Byte";
        }
        if (baseType instanceof DUInt16) {
            return "16 bit Unsigned Integer";
        }
        if (baseType instanceof DInt16) {
            return "16 bit Integer";
        }
        if (baseType instanceof DUInt32) {
            return "32 bit Unsigned Integer";
        }
        if (baseType instanceof DInt32) {
            return "32 bit Integer";
        }
        if (baseType instanceof DFloat32) {
            return "32 bit Real";
        }
        if (baseType instanceof DFloat64) {
            return "64 bit Real";
        }
        if (baseType instanceof DURL) {
            return "URL";
        }
        if (baseType instanceof DString) {
            return "String";
        }
        if (baseType instanceof DArray) {
            DArray dArray = (DArray)baseType;
            String string = "Array of " + dasTools.fancyTypeName(dArray.getPrimitiveVector().getTemplate()) + "s ";
            Enumeration enumeration = dArray.getDimensions();
            while (enumeration.hasMoreElements()) {
                DArrayDimension dArrayDimension = (DArrayDimension)enumeration.nextElement();
                string = string + "[" + dArrayDimension.getName() + " = 0.." + (dArrayDimension.getSize() - 1) + "]";
            }
            string = string + "\n";
            return string;
        }
        if (baseType instanceof DList) {
            DList dList = (DList)baseType;
            String string = "List of " + dasTools.fancyTypeName(dList.getPrimitiveVector().getTemplate()) + "s\n";
            return string;
        }
        if (baseType instanceof DStructure) {
            return "Structure";
        }
        if (baseType instanceof DSequence) {
            return "Sequence";
        }
        if (baseType instanceof DGrid) {
            return "Grid";
        }
        return "UNKNOWN";
    }
}

