/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.parser;

import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.BaseTypeFactory;
import dods.dap.DArray;
import dods.dap.DConstructor;
import dods.dap.DDS;
import dods.dap.DDSException;
import dods.dap.DGrid;
import dods.dap.DVector;
import dods.dap.parser.ASCII_CharStream;
import dods.dap.parser.DDSParserConstants;
import dods.dap.parser.DDSParserTokenManager;
import dods.dap.parser.ParseException;
import dods.dap.parser.Token;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class DDSParser
implements DDSParserConstants {
    private static final String noDDSMsg = "The descriptor object returned from the dataset was null\nCheck that the URL is correct.";
    private DDS dds;
    private BaseTypeFactory factory;
    private Stack ctor;
    private BaseType current;
    private int part;
    private String id;
    public DDSParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[8];
    private final int[] jj_la1_0 = new int[]{64, 33536000, 33536000, 33533952, 0x1FF0000, 0x8000000, 0x8000000, 0};
    private final int[] jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 5};
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void addEntry() {
        if (!this.ctor.empty()) {
            if (this.ctor.peek() instanceof DVector) {
                DVector dVector = (DVector)this.ctor.peek();
                dVector.addVariable(this.current);
                this.current = (BaseType)this.ctor.pop();
            } else if (this.ctor.peek() instanceof DConstructor) {
                DConstructor dConstructor = (DConstructor)this.ctor.peek();
                if (dConstructor instanceof DGrid) {
                    dConstructor.addVariable(this.current, this.part);
                } else {
                    dConstructor.addVariable(this.current);
                }
            }
        } else {
            this.dds.addVariable(this.current);
        }
    }

    private void throwBad(String string) throws BadSemanticsException {
        throw new BadSemanticsException("In the dataset descriptor object:\n`" + string + "' is not a valid declaration.");
    }

    private void throwBad(String string, String string2) throws BadSemanticsException {
        throw new BadSemanticsException("In the dataset descriptor object:\n`" + string + " " + string2 + "' is not a valid declaration");
    }

    private void checkAdd(String string) throws BadSemanticsException {
        try {
            this.current.checkSemantics();
            this.addEntry();
        }
        catch (BadSemanticsException badSemanticsException) {
            this.throwBad(string);
        }
    }

    private void checkAdd(String string, String string2) throws BadSemanticsException {
        try {
            this.current.checkSemantics();
            this.addEntry();
        }
        catch (BadSemanticsException badSemanticsException) {
            this.throwBad(string, string2);
        }
    }

    public final void Dataset(DDS dDS, BaseTypeFactory baseTypeFactory) throws ParseException, DDSException {
        this.dds = dDS;
        this.factory = baseTypeFactory;
        this.ctor = new Stack();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                this.jj_consume_token(25);
                this.Declarations();
                this.jj_consume_token(26);
                this.Name();
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.error(noDDSMsg);
            }
        }
    }

    public final void Declarations() throws ParseException, DDSException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.Declaration();
        }
    }

    public final void Declaration() throws ParseException, DDSException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                String string = this.List();
                String string2 = this.NonListDecl();
                this.checkAdd(string, string2);
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                this.NonListDecl();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String NonListDecl() throws ParseException, DDSException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    String string = this.BaseType();
                    String string2 = this.Var();
                    this.jj_consume_token(30);
                    this.checkAdd(string, string2);
                    return string2;
                }
                case 13: {
                    this.Structure();
                    this.jj_consume_token(25);
                    this.Declarations();
                    this.jj_consume_token(26);
                    this.current = (BaseType)this.ctor.pop();
                    String string = this.Var();
                    this.jj_consume_token(30);
                    this.checkAdd(string);
                    return string;
                }
                case 12: {
                    this.Sequence();
                    this.jj_consume_token(25);
                    this.Declarations();
                    this.jj_consume_token(26);
                    this.current = (BaseType)this.ctor.pop();
                    String string = this.Var();
                    this.jj_consume_token(30);
                    this.checkAdd(string);
                    return string;
                }
                case 15: {
                    this.Grid();
                    this.jj_consume_token(25);
                    this.jj_consume_token(9);
                    this.jj_consume_token(29);
                    this.part = 1;
                    this.Declaration();
                    this.jj_consume_token(10);
                    this.jj_consume_token(29);
                    this.part = 2;
                    this.Declarations();
                    this.jj_consume_token(26);
                    this.current = (BaseType)this.ctor.pop();
                    String string = this.Var();
                    this.jj_consume_token(30);
                    this.checkAdd(string);
                    return string;
                }
            }
            this.jj_la1[3] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (ParseException parseException) {
            this.error("In the dataset descriptor object:\nExpected a variable declaration\n(e.g., Int32 i;). Make sure that the\nvariable name is not a reserved word\n(Byte, Int32, Float64, String, Url\nStructure, Sequence or Grid - all\nforms, byte, Byte and BYTE, are the same)");
            throw new Error("Missing return statement in function");
        }
    }

    public final String List() throws ParseException {
        Token token = this.jj_consume_token(11);
        this.ctor.push(this.factory.newDList());
        return token.image;
    }

    public final String Structure() throws ParseException {
        Token token = this.jj_consume_token(13);
        this.ctor.push(this.factory.newDStructure());
        return token.image;
    }

    public final String Sequence() throws ParseException {
        Token token = this.jj_consume_token(12);
        this.ctor.push(this.factory.newDSequence());
        return token.image;
    }

    public final String Grid() throws ParseException {
        Token token = this.jj_consume_token(15);
        this.ctor.push(this.factory.newDGrid());
        return token.image;
    }

    public final String BaseType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                Token token = this.jj_consume_token(16);
                this.current = this.factory.newDByte();
                return token.image;
            }
            case 17: {
                Token token = this.jj_consume_token(17);
                this.current = this.factory.newDInt16();
                return token.image;
            }
            case 18: {
                Token token = this.jj_consume_token(18);
                this.current = this.factory.newDUInt16();
                return token.image;
            }
            case 19: {
                Token token = this.jj_consume_token(19);
                this.current = this.factory.newDInt32();
                return token.image;
            }
            case 20: {
                Token token = this.jj_consume_token(20);
                this.current = this.factory.newDUInt32();
                return token.image;
            }
            case 22: {
                Token token = this.jj_consume_token(22);
                this.current = this.factory.newDFloat32();
                return token.image;
            }
            case 21: {
                Token token = this.jj_consume_token(21);
                this.current = this.factory.newDFloat64();
                return token.image;
            }
            case 23: {
                Token token = this.jj_consume_token(23);
                this.current = this.factory.newDString();
                return token.image;
            }
            case 24: {
                Token token = this.jj_consume_token(24);
                this.current = this.factory.newDURL();
                return token.image;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Var() throws ParseException, DDSException {
        Token token = this.jj_consume_token(32);
        this.current.setName(token.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.ArrayDecl();
        }
        return token.image;
    }

    public final void ArrayDecl() throws ParseException, DDSException {
        try {
            if (this.jj_2_1(2)) {
                this.jj_consume_token(27);
                Token token = this.jj_consume_token(33);
                this.jj_consume_token(28);
                if (this.current instanceof DArray) {
                    ((DArray)this.current).appendDim(Integer.parseInt(token.image));
                } else {
                    DArray dArray = this.factory.newDArray();
                    dArray.addVariable(this.current);
                    dArray.appendDim(Integer.parseInt(token.image));
                    this.current = dArray;
                }
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        Token token = this.jj_consume_token(32);
                        this.id = token.image;
                        this.jj_consume_token(31);
                        token = this.jj_consume_token(33);
                        if (this.current instanceof DArray) {
                            ((DArray)this.current).appendDim(Integer.parseInt(token.image), this.id);
                        } else {
                            DArray dArray = this.factory.newDArray();
                            dArray.addVariable(this.current);
                            dArray.appendDim(Integer.parseInt(token.image), this.id);
                            this.current = dArray;
                        }
                        this.jj_consume_token(28);
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        catch (ParseException parseException) {
            this.error("In the dataset descriptor object:\nExpected an array subscript.");
        }
    }

    public final void Name() throws ParseException, DDSException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: {
                    Token token = this.jj_consume_token(34);
                    this.dds.setName(token.image);
                    break;
                }
                case 32: {
                    Token token = this.jj_consume_token(32);
                    this.dds.setName(token.image);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException parseException) {
            this.error("Error parsing the dataset name.\nThe name may be missing or may contain an illegal character.");
        }
    }

    void error(String string) throws ParseException, DDSException {
        throw new DDSException(3, string);
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 8) {
            this.jj_la1[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.jj_2_rtns.length) {
            this.jj_2_rtns[n] = new JJCalls();
            ++n;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 8) {
            this.jj_la1[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.jj_2_rtns.length) {
            this.jj_2_rtns[n] = new JJCalls();
            ++n;
        }
    }

    public void ReInit(DDSParserTokenManager dDSParserTokenManager) {
        this.token_source = dDSParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 8) {
            this.jj_la1[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.jj_2_rtns.length) {
            this.jj_2_rtns[n] = new JJCalls();
            ++n;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int n2 = 0;
                while (n2 < this.jj_2_rtns.length) {
                    JJCalls jJCalls = this.jj_2_rtns[n2];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                    ++n2;
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int n3 = 0;
            while (n3 < this.jj_endpos) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
                ++n3;
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                int n4 = 0;
                while (n4 < this.jj_expentry.length) {
                    if (nArray[n4] != this.jj_expentry[n4]) {
                        n3 = 0;
                        break;
                    }
                    ++n4;
                }
                if (n3 != 0) break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[35];
        int n2 = 0;
        while (n2 < 35) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        n2 = 0;
        while (n2 < 8) {
            if (this.jj_la1[n2] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n2] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    if ((this.jj_la1_1[n2] & 1 << n) != 0) {
                        blArray[32 + n] = true;
                    }
                    ++n;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 35) {
            if (blArray[n2]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n2;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n2;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArray = new int[this.jj_expentries.size()][];
        n = 0;
        while (n < this.jj_expentries.size()) {
            nArray[n] = (int[])this.jj_expentries.elementAt(n);
            ++n;
        }
        return new ParseException(this.token, nArray, DDSParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int n = 0;
        while (n < 1) {
            JJCalls jJCalls = this.jj_2_rtns[n];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (n) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
            ++n;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    public DDSParser(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new DDSParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 8) {
            this.jj_la1[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.jj_2_rtns.length) {
            this.jj_2_rtns[n] = new JJCalls();
            ++n;
        }
    }

    public DDSParser(Reader reader) {
        this.jj_input_stream = new ASCII_CharStream(reader, 1, 1);
        this.token_source = new DDSParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 8) {
            this.jj_la1[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.jj_2_rtns.length) {
            this.jj_2_rtns[n] = new JJCalls();
            ++n;
        }
    }

    public DDSParser(DDSParserTokenManager dDSParserTokenManager) {
        this.token_source = dDSParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 8) {
            this.jj_la1[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.jj_2_rtns.length) {
            this.jj_2_rtns[n] = new JJCalls();
            ++n;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

