/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.Server;

import dods.dap.BaseType;
import dods.dap.DBoolean;
import dods.dap.DByte;
import dods.dap.DFloat32;
import dods.dap.DFloat64;
import dods.dap.DInt16;
import dods.dap.DInt32;
import dods.dap.DString;
import dods.dap.DUInt16;
import dods.dap.DUInt32;
import dods.dap.DURL;
import dods.dap.Server.InvalidOperatorException;
import dods.dap.Server.RegExpException;
import dods.dap.Server.SBHException;
import dods.dap.parser.ExprParserConstants;
import gnu.regexp.RE;
import gnu.regexp.REException;

public class Operator
implements ExprParserConstants {
    public static boolean op(int n, BaseType baseType, BaseType baseType2) throws InvalidOperatorException, RegExpException, SBHException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, (DBoolean)baseType, baseType2);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, (DByte)baseType, baseType2);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, (DFloat32)baseType, baseType2);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, (DFloat64)baseType, baseType2);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, (DInt16)baseType, baseType2);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, (DInt32)baseType, baseType2);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, (DString)baseType, baseType2);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, (DUInt16)baseType, baseType2);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, (DUInt32)baseType, baseType2);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, (DURL)baseType, baseType2);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + baseType.getClass());
    }

    private static boolean op(int n, DBoolean dBoolean, BaseType baseType) throws InvalidOperatorException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dBoolean, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dBoolean, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dBoolean, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dBoolean, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dBoolean, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dBoolean, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dBoolean, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dBoolean, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dBoolean, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dBoolean, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dBoolean.getClass());
    }

    private static boolean op(int n, DByte dByte, BaseType baseType) throws InvalidOperatorException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dByte, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dByte, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dByte, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dByte, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dByte, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dByte, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dByte, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dByte, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dByte, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dByte, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dByte.getClass());
    }

    private static boolean op(int n, DFloat32 dFloat32, BaseType baseType) throws InvalidOperatorException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dFloat32, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dFloat32, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dFloat32, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dFloat32, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dFloat32, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dFloat32, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dFloat32, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dFloat32, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dFloat32, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dFloat32, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dFloat32.getClass());
    }

    private static boolean op(int n, DFloat64 dFloat64, BaseType baseType) throws InvalidOperatorException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dFloat64, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dFloat64, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dFloat64, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dFloat64, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dFloat64, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dFloat64, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dFloat64, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dFloat64, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dFloat64, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dFloat64, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dFloat64.getClass());
    }

    private static boolean op(int n, DInt16 dInt16, BaseType baseType) throws InvalidOperatorException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dInt16, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dInt16, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dInt16, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dInt16, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dInt16, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dInt16, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dInt16, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dInt16, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dInt16, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dInt16, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dInt16.getClass());
    }

    private static boolean op(int n, DInt32 dInt32, BaseType baseType) throws InvalidOperatorException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dInt32, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dInt32, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dInt32, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dInt32, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dInt32, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dInt32, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dInt32, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dInt32, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dInt32, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dInt32, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dInt32.getClass());
    }

    private static boolean op(int n, DString dString, BaseType baseType) throws InvalidOperatorException, RegExpException, SBHException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dString, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dString, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dString, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dString, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dString, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dString, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dString, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dString, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dString, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dString, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dString.getClass());
    }

    private static boolean op(int n, DUInt16 dUInt16, BaseType baseType) throws InvalidOperatorException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dUInt16, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dUInt16, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dUInt16, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dUInt16, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dUInt16, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dUInt16, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dUInt16, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dUInt16, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dUInt16, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dUInt16, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dUInt16.getClass());
    }

    private static boolean op(int n, DUInt32 dUInt32, BaseType baseType) throws InvalidOperatorException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dUInt32, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dUInt32, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dUInt32, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dUInt32, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dUInt32, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dUInt32, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dUInt32, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dUInt32, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dUInt32, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dUInt32, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dUInt32.getClass());
    }

    private static boolean op(int n, DURL dURL, BaseType baseType) throws InvalidOperatorException, RegExpException, SBHException {
        if (baseType instanceof DBoolean) {
            return Operator.op(n, dURL, (DBoolean)baseType);
        }
        if (baseType instanceof DByte) {
            return Operator.op(n, dURL, (DByte)baseType);
        }
        if (baseType instanceof DFloat32) {
            return Operator.op(n, dURL, (DFloat32)baseType);
        }
        if (baseType instanceof DFloat64) {
            return Operator.op(n, dURL, (DFloat64)baseType);
        }
        if (baseType instanceof DInt16) {
            return Operator.op(n, dURL, (DInt16)baseType);
        }
        if (baseType instanceof DInt32) {
            return Operator.op(n, dURL, (DInt32)baseType);
        }
        if (baseType instanceof DString) {
            return Operator.op(n, dURL, (DString)baseType);
        }
        if (baseType instanceof DUInt16) {
            return Operator.op(n, dURL, (DUInt16)baseType);
        }
        if (baseType instanceof DUInt32) {
            return Operator.op(n, dURL, (DUInt32)baseType);
        }
        if (baseType instanceof DURL) {
            return Operator.op(n, dURL, (DURL)baseType);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + dURL.getClass());
    }

    private static String opErrorMsg(int n, String string, String string2) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return "Less Than (<) Operator not valid between types" + string + "and" + string2 + ".";
            }
            case 10: {
                return "Less Than Equal To (<=) Operator not valid between types" + string + "and" + string2 + ".";
            }
            case 7: {
                return "Greater Than (>) Operator not valid between types" + string + "and" + string2 + ".";
            }
            case 8: {
                return "Greater Than Equal To (>=) Operator not valid between types" + string + "and" + string2 + ".";
            }
            case 5: {
                return "Equal To (==) Operator not valid between types" + string + "and" + string2 + ".";
            }
            case 6: {
                return "Not Equal To (!=) Operator not valid between types" + string + "and" + string2 + ".";
            }
            case 11: {
                return "Regular Expression cannot beevaluated between types" + string + "and" + string2 + ".";
            }
        }
        return "Unknown Operator Requested! RTFM!";
    }

    private static boolean op(int n, DBoolean dBoolean, DBoolean dBoolean2) throws InvalidOperatorException {
        switch (n) {
            case 5: {
                return dBoolean.getValue() == dBoolean2.getValue();
            }
            case 6: {
                return dBoolean.getValue() != dBoolean2.getValue();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dBoolean2.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DBoolean dBoolean, DByte dByte) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dByte.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() == bl;
            }
            case 6: {
                if (dByte.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() != bl;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dByte.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DBoolean dBoolean, DFloat32 dFloat32) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dFloat32.getValue() != 0.0f) {
                    bl = true;
                }
                return dBoolean.getValue() == bl;
            }
            case 6: {
                if (dFloat32.getValue() != 0.0f) {
                    bl = true;
                }
                return dBoolean.getValue() != bl;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dFloat32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DBoolean dBoolean, DFloat64 dFloat64) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dFloat64.getValue() != 0.0) {
                    bl = true;
                }
                return dBoolean.getValue() == bl;
            }
            case 6: {
                if (dFloat64.getValue() != 0.0) {
                    bl = true;
                }
                return dBoolean.getValue() != bl;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dFloat64.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DBoolean dBoolean, DInt16 dInt16) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dInt16.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() == bl;
            }
            case 6: {
                if (dInt16.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() != bl;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DBoolean dBoolean, DInt32 dInt32) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dInt32.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() == bl;
            }
            case 6: {
                if (dInt32.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() != bl;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DBoolean dBoolean, DString dString) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dString.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DBoolean dBoolean, DUInt16 dUInt16) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dUInt16.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() == bl;
            }
            case 6: {
                if (dUInt16.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() != bl;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dUInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DBoolean dBoolean, DUInt32 dUInt32) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dUInt32.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() == bl;
            }
            case 6: {
                if (dUInt32.getValue() != 0) {
                    bl = true;
                }
                return dBoolean.getValue() != bl;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dUInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DBoolean dBoolean, DURL dURL) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dBoolean.getTypeName(), dURL.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DBoolean dBoolean) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dByte.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 6: {
                if (dByte.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dBoolean.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DByte dByte2) throws InvalidOperatorException {
        int n2 = dByte.getValue() & 0xFF;
        int n3 = dByte2.getValue() & 0xFF;
        switch (n) {
            case 9: {
                return n2 < n3;
            }
            case 10: {
                return n2 <= n3;
            }
            case 7: {
                return n2 > n3;
            }
            case 8: {
                return n2 >= n3;
            }
            case 5: {
                return n2 == n3;
            }
            case 6: {
                return n2 != n3;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dByte2.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DFloat32 dFloat32) throws InvalidOperatorException {
        int n2 = dByte.getValue() & 0xFF;
        switch (n) {
            case 9: {
                return (float)n2 < dFloat32.getValue();
            }
            case 10: {
                return (float)n2 <= dFloat32.getValue();
            }
            case 7: {
                return (float)n2 > dFloat32.getValue();
            }
            case 8: {
                return (float)n2 >= dFloat32.getValue();
            }
            case 5: {
                return (float)n2 == dFloat32.getValue();
            }
            case 6: {
                return (float)n2 != dFloat32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dFloat32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DFloat64 dFloat64) throws InvalidOperatorException {
        int n2 = dByte.getValue() & 0xFF;
        switch (n) {
            case 9: {
                return (double)n2 < dFloat64.getValue();
            }
            case 10: {
                return (double)n2 <= dFloat64.getValue();
            }
            case 7: {
                return (double)n2 > dFloat64.getValue();
            }
            case 8: {
                return (double)n2 >= dFloat64.getValue();
            }
            case 5: {
                return (double)n2 == dFloat64.getValue();
            }
            case 6: {
                return (double)n2 != dFloat64.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dFloat64.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DInt16 dInt16) throws InvalidOperatorException {
        int n2 = dByte.getValue() & 0xFF;
        switch (n) {
            case 9: {
                return n2 < dInt16.getValue();
            }
            case 10: {
                return n2 <= dInt16.getValue();
            }
            case 7: {
                return n2 > dInt16.getValue();
            }
            case 8: {
                return n2 >= dInt16.getValue();
            }
            case 5: {
                return n2 == dInt16.getValue();
            }
            case 6: {
                return n2 != dInt16.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DInt32 dInt32) throws InvalidOperatorException {
        int n2 = dByte.getValue() & 0xFF;
        switch (n) {
            case 9: {
                return n2 < dInt32.getValue();
            }
            case 10: {
                return n2 <= dInt32.getValue();
            }
            case 7: {
                return n2 > dInt32.getValue();
            }
            case 8: {
                return n2 >= dInt32.getValue();
            }
            case 5: {
                return n2 == dInt32.getValue();
            }
            case 6: {
                return n2 != dInt32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DString dString) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dString.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DUInt16 dUInt16) throws InvalidOperatorException {
        int n2 = dByte.getValue() & 0xFF;
        int n3 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return n2 < n3;
            }
            case 10: {
                return n2 <= n3;
            }
            case 7: {
                return n2 > n3;
            }
            case 8: {
                return n2 >= n3;
            }
            case 5: {
                return n2 == n3;
            }
            case 6: {
                return n2 != n3;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dUInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DUInt32 dUInt32) throws InvalidOperatorException {
        int n2 = dByte.getValue() & 0xFF;
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return (long)n2 < l;
            }
            case 10: {
                return (long)n2 <= l;
            }
            case 7: {
                return (long)n2 > l;
            }
            case 8: {
                return (long)n2 >= l;
            }
            case 5: {
                return (long)n2 == l;
            }
            case 6: {
                return (long)n2 != l;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dUInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DByte dByte, DURL dURL) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dByte.getTypeName(), dURL.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DBoolean dBoolean) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dFloat32.getValue() != 0.0f) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 6: {
                if (dFloat32.getValue() != 0.0f) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dBoolean.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DByte dByte) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dFloat32.getValue() < (float)dByte.getValue();
            }
            case 10: {
                return dFloat32.getValue() <= (float)dByte.getValue();
            }
            case 7: {
                return dFloat32.getValue() > (float)dByte.getValue();
            }
            case 8: {
                return dFloat32.getValue() >= (float)dByte.getValue();
            }
            case 5: {
                return dFloat32.getValue() == (float)dByte.getValue();
            }
            case 6: {
                return dFloat32.getValue() != (float)dByte.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dByte.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DFloat32 dFloat322) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dFloat32.getValue() < dFloat322.getValue();
            }
            case 10: {
                return dFloat32.getValue() <= dFloat322.getValue();
            }
            case 7: {
                return dFloat32.getValue() > dFloat322.getValue();
            }
            case 8: {
                return dFloat32.getValue() >= dFloat322.getValue();
            }
            case 5: {
                return dFloat32.getValue() == dFloat322.getValue();
            }
            case 6: {
                return dFloat32.getValue() != dFloat322.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dFloat322.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DFloat64 dFloat64) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return (double)dFloat32.getValue() < dFloat64.getValue();
            }
            case 10: {
                return (double)dFloat32.getValue() <= dFloat64.getValue();
            }
            case 7: {
                return (double)dFloat32.getValue() > dFloat64.getValue();
            }
            case 8: {
                return (double)dFloat32.getValue() >= dFloat64.getValue();
            }
            case 5: {
                return (double)dFloat32.getValue() == dFloat64.getValue();
            }
            case 6: {
                return (double)dFloat32.getValue() != dFloat64.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dFloat64.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DInt16 dInt16) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dFloat32.getValue() < (float)dInt16.getValue();
            }
            case 10: {
                return dFloat32.getValue() <= (float)dInt16.getValue();
            }
            case 7: {
                return dFloat32.getValue() > (float)dInt16.getValue();
            }
            case 8: {
                return dFloat32.getValue() >= (float)dInt16.getValue();
            }
            case 5: {
                return dFloat32.getValue() == (float)dInt16.getValue();
            }
            case 6: {
                return dFloat32.getValue() != (float)dInt16.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DInt32 dInt32) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dFloat32.getValue() < (float)dInt32.getValue();
            }
            case 10: {
                return dFloat32.getValue() <= (float)dInt32.getValue();
            }
            case 7: {
                return dFloat32.getValue() > (float)dInt32.getValue();
            }
            case 8: {
                return dFloat32.getValue() >= (float)dInt32.getValue();
            }
            case 5: {
                return dFloat32.getValue() == (float)dInt32.getValue();
            }
            case 6: {
                return dFloat32.getValue() != (float)dInt32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DString dString) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dString.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DUInt16 dUInt16) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return dFloat32.getValue() < (float)n2;
            }
            case 10: {
                return dFloat32.getValue() <= (float)n2;
            }
            case 7: {
                return dFloat32.getValue() > (float)n2;
            }
            case 8: {
                return dFloat32.getValue() >= (float)n2;
            }
            case 5: {
                return dFloat32.getValue() == (float)n2;
            }
            case 6: {
                return dFloat32.getValue() != (float)n2;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dUInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DUInt32 dUInt32) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return dFloat32.getValue() < (float)l;
            }
            case 10: {
                return dFloat32.getValue() <= (float)l;
            }
            case 7: {
                return dFloat32.getValue() > (float)l;
            }
            case 8: {
                return dFloat32.getValue() >= (float)l;
            }
            case 5: {
                return dFloat32.getValue() == (float)l;
            }
            case 6: {
                return dFloat32.getValue() != (float)l;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dUInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat32 dFloat32, DURL dURL) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat32.getTypeName(), dURL.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DBoolean dBoolean) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dFloat64.getValue() != 0.0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 6: {
                if (dFloat64.getValue() != 0.0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dBoolean.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DByte dByte) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dFloat64.getValue() < (double)dByte.getValue();
            }
            case 10: {
                return dFloat64.getValue() <= (double)dByte.getValue();
            }
            case 7: {
                return dFloat64.getValue() > (double)dByte.getValue();
            }
            case 8: {
                return dFloat64.getValue() >= (double)dByte.getValue();
            }
            case 5: {
                return dFloat64.getValue() == (double)dByte.getValue();
            }
            case 6: {
                return dFloat64.getValue() != (double)dByte.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dByte.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DFloat32 dFloat32) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dFloat64.getValue() < (double)dFloat32.getValue();
            }
            case 10: {
                return dFloat64.getValue() <= (double)dFloat32.getValue();
            }
            case 7: {
                return dFloat64.getValue() > (double)dFloat32.getValue();
            }
            case 8: {
                return dFloat64.getValue() >= (double)dFloat32.getValue();
            }
            case 5: {
                return dFloat64.getValue() == (double)dFloat32.getValue();
            }
            case 6: {
                return dFloat64.getValue() != (double)dFloat32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dFloat32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DFloat64 dFloat642) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dFloat64.getValue() < dFloat642.getValue();
            }
            case 10: {
                return dFloat64.getValue() <= dFloat642.getValue();
            }
            case 7: {
                return dFloat64.getValue() > dFloat642.getValue();
            }
            case 8: {
                return dFloat64.getValue() >= dFloat642.getValue();
            }
            case 5: {
                return dFloat64.getValue() == dFloat642.getValue();
            }
            case 6: {
                return dFloat64.getValue() != dFloat642.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dFloat642.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DInt16 dInt16) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dFloat64.getValue() < (double)dInt16.getValue();
            }
            case 10: {
                return dFloat64.getValue() <= (double)dInt16.getValue();
            }
            case 7: {
                return dFloat64.getValue() > (double)dInt16.getValue();
            }
            case 8: {
                return dFloat64.getValue() >= (double)dInt16.getValue();
            }
            case 5: {
                return dFloat64.getValue() == (double)dInt16.getValue();
            }
            case 6: {
                return dFloat64.getValue() != (double)dInt16.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DInt32 dInt32) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dFloat64.getValue() < (double)dInt32.getValue();
            }
            case 10: {
                return dFloat64.getValue() <= (double)dInt32.getValue();
            }
            case 7: {
                return dFloat64.getValue() > (double)dInt32.getValue();
            }
            case 8: {
                return dFloat64.getValue() >= (double)dInt32.getValue();
            }
            case 5: {
                return dFloat64.getValue() == (double)dInt32.getValue();
            }
            case 6: {
                return dFloat64.getValue() != (double)dInt32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DString dString) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dString.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DUInt16 dUInt16) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return dFloat64.getValue() < (double)n2;
            }
            case 10: {
                return dFloat64.getValue() <= (double)n2;
            }
            case 7: {
                return dFloat64.getValue() > (double)n2;
            }
            case 8: {
                return dFloat64.getValue() >= (double)n2;
            }
            case 5: {
                return dFloat64.getValue() == (double)n2;
            }
            case 6: {
                return dFloat64.getValue() != (double)n2;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dUInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DUInt32 dUInt32) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return dFloat64.getValue() < (double)l;
            }
            case 10: {
                return dFloat64.getValue() <= (double)l;
            }
            case 7: {
                return dFloat64.getValue() > (double)l;
            }
            case 8: {
                return dFloat64.getValue() >= (double)l;
            }
            case 5: {
                return dFloat64.getValue() == (double)l;
            }
            case 6: {
                return dFloat64.getValue() != (double)l;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dUInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DFloat64 dFloat64, DURL dURL) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dFloat64.getTypeName(), dURL.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DBoolean dBoolean) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dInt16.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 6: {
                if (dInt16.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dBoolean.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DByte dByte) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dInt16.getValue() < dByte.getValue();
            }
            case 10: {
                return dInt16.getValue() <= dByte.getValue();
            }
            case 7: {
                return dInt16.getValue() > dByte.getValue();
            }
            case 8: {
                return dInt16.getValue() >= dByte.getValue();
            }
            case 5: {
                return dInt16.getValue() == dByte.getValue();
            }
            case 6: {
                return dInt16.getValue() != dByte.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dByte.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DFloat32 dFloat32) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return (float)dInt16.getValue() < dFloat32.getValue();
            }
            case 10: {
                return (float)dInt16.getValue() <= dFloat32.getValue();
            }
            case 7: {
                return (float)dInt16.getValue() > dFloat32.getValue();
            }
            case 8: {
                return (float)dInt16.getValue() >= dFloat32.getValue();
            }
            case 5: {
                return (float)dInt16.getValue() == dFloat32.getValue();
            }
            case 6: {
                return (float)dInt16.getValue() != dFloat32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dFloat32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DFloat64 dFloat64) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return (double)dInt16.getValue() < dFloat64.getValue();
            }
            case 10: {
                return (double)dInt16.getValue() <= dFloat64.getValue();
            }
            case 7: {
                return (double)dInt16.getValue() > dFloat64.getValue();
            }
            case 8: {
                return (double)dInt16.getValue() >= dFloat64.getValue();
            }
            case 5: {
                return (double)dInt16.getValue() == dFloat64.getValue();
            }
            case 6: {
                return (double)dInt16.getValue() != dFloat64.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dFloat64.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DInt16 dInt162) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dInt16.getValue() < dInt162.getValue();
            }
            case 10: {
                return dInt16.getValue() <= dInt162.getValue();
            }
            case 7: {
                return dInt16.getValue() > dInt162.getValue();
            }
            case 8: {
                return dInt16.getValue() >= dInt162.getValue();
            }
            case 5: {
                return dInt16.getValue() == dInt162.getValue();
            }
            case 6: {
                return dInt16.getValue() != dInt162.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dInt162.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DInt32 dInt32) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dInt16.getValue() < dInt32.getValue();
            }
            case 10: {
                return dInt16.getValue() <= dInt32.getValue();
            }
            case 7: {
                return dInt16.getValue() > dInt32.getValue();
            }
            case 8: {
                return dInt16.getValue() >= dInt32.getValue();
            }
            case 5: {
                return dInt16.getValue() == dInt32.getValue();
            }
            case 6: {
                return dInt16.getValue() != dInt32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DString dString) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dString.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DUInt16 dUInt16) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return dInt16.getValue() < n2;
            }
            case 10: {
                return dInt16.getValue() <= n2;
            }
            case 7: {
                return dInt16.getValue() > n2;
            }
            case 8: {
                return dInt16.getValue() >= n2;
            }
            case 5: {
                return dInt16.getValue() == n2;
            }
            case 6: {
                return dInt16.getValue() != n2;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dUInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DUInt32 dUInt32) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return (long)dInt16.getValue() < l;
            }
            case 10: {
                return (long)dInt16.getValue() <= l;
            }
            case 7: {
                return (long)dInt16.getValue() > l;
            }
            case 8: {
                return (long)dInt16.getValue() >= l;
            }
            case 5: {
                return (long)dInt16.getValue() == l;
            }
            case 6: {
                return (long)dInt16.getValue() != l;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dUInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt16 dInt16, DURL dURL) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt16.getTypeName(), dURL.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DBoolean dBoolean) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dInt32.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 6: {
                if (dInt32.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dBoolean.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DByte dByte) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dInt32.getValue() < dByte.getValue();
            }
            case 10: {
                return dInt32.getValue() <= dByte.getValue();
            }
            case 7: {
                return dInt32.getValue() > dByte.getValue();
            }
            case 8: {
                return dInt32.getValue() >= dByte.getValue();
            }
            case 5: {
                return dInt32.getValue() == dByte.getValue();
            }
            case 6: {
                return dInt32.getValue() != dByte.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dByte.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DFloat32 dFloat32) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return (float)dInt32.getValue() < dFloat32.getValue();
            }
            case 10: {
                return (float)dInt32.getValue() <= dFloat32.getValue();
            }
            case 7: {
                return (float)dInt32.getValue() > dFloat32.getValue();
            }
            case 8: {
                return (float)dInt32.getValue() >= dFloat32.getValue();
            }
            case 5: {
                return (float)dInt32.getValue() == dFloat32.getValue();
            }
            case 6: {
                return (float)dInt32.getValue() != dFloat32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dFloat32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DFloat64 dFloat64) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return (double)dInt32.getValue() < dFloat64.getValue();
            }
            case 10: {
                return (double)dInt32.getValue() <= dFloat64.getValue();
            }
            case 7: {
                return (double)dInt32.getValue() > dFloat64.getValue();
            }
            case 8: {
                return (double)dInt32.getValue() >= dFloat64.getValue();
            }
            case 5: {
                return (double)dInt32.getValue() == dFloat64.getValue();
            }
            case 6: {
                return (double)dInt32.getValue() != dFloat64.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dFloat64.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DInt16 dInt16) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dInt32.getValue() < dInt16.getValue();
            }
            case 10: {
                return dInt32.getValue() <= dInt16.getValue();
            }
            case 7: {
                return dInt32.getValue() > dInt16.getValue();
            }
            case 8: {
                return dInt32.getValue() >= dInt16.getValue();
            }
            case 5: {
                return dInt32.getValue() == dInt16.getValue();
            }
            case 6: {
                return dInt32.getValue() != dInt16.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DInt32 dInt322) throws InvalidOperatorException {
        switch (n) {
            case 9: {
                return dInt32.getValue() < dInt322.getValue();
            }
            case 10: {
                return dInt32.getValue() <= dInt322.getValue();
            }
            case 7: {
                return dInt32.getValue() > dInt322.getValue();
            }
            case 8: {
                return dInt32.getValue() >= dInt322.getValue();
            }
            case 5: {
                return dInt32.getValue() == dInt322.getValue();
            }
            case 6: {
                return dInt32.getValue() != dInt322.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dInt322.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DString dString) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dString.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DUInt16 dUInt16) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return dInt32.getValue() < n2;
            }
            case 10: {
                return dInt32.getValue() <= n2;
            }
            case 7: {
                return dInt32.getValue() > n2;
            }
            case 8: {
                return dInt32.getValue() >= n2;
            }
            case 5: {
                return dInt32.getValue() == n2;
            }
            case 6: {
                return dInt32.getValue() != n2;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dUInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DUInt32 dUInt32) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return (long)dInt32.getValue() < l;
            }
            case 10: {
                return (long)dInt32.getValue() <= l;
            }
            case 7: {
                return (long)dInt32.getValue() > l;
            }
            case 8: {
                return (long)dInt32.getValue() >= l;
            }
            case 5: {
                return (long)dInt32.getValue() == l;
            }
            case 6: {
                return (long)dInt32.getValue() != l;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dUInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DInt32 dInt32, DURL dURL) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dInt32.getTypeName(), dURL.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DBoolean dBoolean) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dString.getTypeName(), dBoolean.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DByte dByte) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dString.getTypeName(), dByte.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DFloat32 dFloat32) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dString.getTypeName(), dFloat32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DFloat64 dFloat64) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dString.getTypeName(), dFloat64.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DInt16 dInt16) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dString.getTypeName(), dInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DInt32 dInt32) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dString.getTypeName(), dInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DString dString2) throws InvalidOperatorException, RegExpException, SBHException {
        switch (n) {
            case 9: {
                int n2 = dString.getValue().compareTo(dString2.getValue());
                return n2 < 0;
            }
            case 10: {
                int n3 = dString.getValue().compareTo(dString2.getValue());
                return n3 <= 0;
            }
            case 7: {
                int n4 = dString.getValue().compareTo(dString2.getValue());
                return n4 > 0;
            }
            case 8: {
                int n5 = dString.getValue().compareTo(dString2.getValue());
                return n5 >= 0;
            }
            case 5: {
                int n6 = dString.getValue().compareTo(dString2.getValue());
                return n6 == 0;
            }
            case 6: {
                int n7 = dString.getValue().compareTo(dString2.getValue());
                return n7 != 0;
            }
            case 11: {
                try {
                    RE rE = new RE(dString.getValue());
                    return rE.isMatch(dString2.getValue());
                }
                catch (REException rEException) {
                    throw new RegExpException(rEException.getMessage());
                }
                catch (Exception exception) {
                    throw new SBHException(exception.getMessage());
                }
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DUInt16 dUInt16) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dString.getTypeName(), dUInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DUInt32 dUInt32) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dString.getTypeName(), dUInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DString dString, DURL dURL) throws InvalidOperatorException, RegExpException, SBHException {
        switch (n) {
            case 9: {
                int n2 = dString.getValue().compareTo(dURL.getValue());
                return n2 < 0;
            }
            case 10: {
                int n3 = dString.getValue().compareTo(dURL.getValue());
                return n3 <= 0;
            }
            case 7: {
                int n4 = dString.getValue().compareTo(dURL.getValue());
                return n4 > 0;
            }
            case 8: {
                int n5 = dString.getValue().compareTo(dURL.getValue());
                return n5 >= 0;
            }
            case 5: {
                int n6 = dString.getValue().compareTo(dURL.getValue());
                return n6 == 0;
            }
            case 6: {
                int n7 = dString.getValue().compareTo(dURL.getValue());
                return n7 != 0;
            }
            case 11: {
                try {
                    RE rE = new RE(dString.getValue());
                    return rE.isMatch(dURL.getValue());
                }
                catch (REException rEException) {
                    throw new RegExpException(rEException.getMessage());
                }
                catch (Exception exception) {
                    throw new SBHException(exception.getMessage());
                }
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DBoolean dBoolean) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dUInt16.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 6: {
                if (dUInt16.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dBoolean.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DByte dByte) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return n2 < dByte.getValue();
            }
            case 10: {
                return n2 <= dByte.getValue();
            }
            case 7: {
                return n2 > dByte.getValue();
            }
            case 8: {
                return n2 >= dByte.getValue();
            }
            case 5: {
                return n2 == dByte.getValue();
            }
            case 6: {
                return n2 != dByte.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dByte.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DFloat32 dFloat32) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return (float)n2 < dFloat32.getValue();
            }
            case 10: {
                return (float)n2 <= dFloat32.getValue();
            }
            case 7: {
                return (float)n2 > dFloat32.getValue();
            }
            case 8: {
                return (float)n2 >= dFloat32.getValue();
            }
            case 5: {
                return (float)n2 == dFloat32.getValue();
            }
            case 6: {
                return (float)n2 != dFloat32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dFloat32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DFloat64 dFloat64) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return (double)n2 < dFloat64.getValue();
            }
            case 10: {
                return (double)n2 <= dFloat64.getValue();
            }
            case 7: {
                return (double)n2 > dFloat64.getValue();
            }
            case 8: {
                return (double)n2 >= dFloat64.getValue();
            }
            case 5: {
                return (double)n2 == dFloat64.getValue();
            }
            case 6: {
                return (double)n2 != dFloat64.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dFloat64.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DInt16 dInt16) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return n2 < dInt16.getValue();
            }
            case 10: {
                return n2 <= dInt16.getValue();
            }
            case 7: {
                return n2 > dInt16.getValue();
            }
            case 8: {
                return n2 >= dInt16.getValue();
            }
            case 5: {
                return n2 == dInt16.getValue();
            }
            case 6: {
                return n2 != dInt16.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DInt32 dInt32) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return n2 < dInt32.getValue();
            }
            case 10: {
                return n2 <= dInt32.getValue();
            }
            case 7: {
                return n2 > dInt32.getValue();
            }
            case 8: {
                return n2 >= dInt32.getValue();
            }
            case 5: {
                return n2 == dInt32.getValue();
            }
            case 6: {
                return n2 != dInt32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DString dString) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dString.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DUInt16 dUInt162) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        int n3 = dUInt162.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return n2 < n3;
            }
            case 10: {
                return n2 <= n3;
            }
            case 7: {
                return n2 > n3;
            }
            case 8: {
                return n2 >= n3;
            }
            case 5: {
                return n2 == n3;
            }
            case 6: {
                return n2 != n3;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dUInt162.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DUInt32 dUInt32) throws InvalidOperatorException {
        int n2 = dUInt16.getValue() & 0xFFFF;
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return (long)n2 < l;
            }
            case 10: {
                return (long)n2 <= l;
            }
            case 7: {
                return (long)n2 > l;
            }
            case 8: {
                return (long)n2 >= l;
            }
            case 5: {
                return (long)n2 == l;
            }
            case 6: {
                return (long)n2 != l;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dUInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt16 dUInt16, DURL dURL) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt16.getTypeName(), dURL.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DBoolean dBoolean) throws InvalidOperatorException {
        boolean bl = false;
        switch (n) {
            case 5: {
                if (dUInt32.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 6: {
                if (dUInt32.getValue() != 0) {
                    bl = true;
                }
                return bl == dBoolean.getValue();
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dBoolean.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DByte dByte) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return l < (long)dByte.getValue();
            }
            case 10: {
                return l <= (long)dByte.getValue();
            }
            case 7: {
                return l > (long)dByte.getValue();
            }
            case 8: {
                return l >= (long)dByte.getValue();
            }
            case 5: {
                return l == (long)dByte.getValue();
            }
            case 6: {
                return l != (long)dByte.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dByte.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DFloat32 dFloat32) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return (float)l < dFloat32.getValue();
            }
            case 10: {
                return (float)l <= dFloat32.getValue();
            }
            case 7: {
                return (float)l > dFloat32.getValue();
            }
            case 8: {
                return (float)l >= dFloat32.getValue();
            }
            case 5: {
                return (float)l == dFloat32.getValue();
            }
            case 6: {
                return (float)l != dFloat32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dFloat32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DFloat64 dFloat64) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return (double)l < dFloat64.getValue();
            }
            case 10: {
                return (double)l <= dFloat64.getValue();
            }
            case 7: {
                return (double)l > dFloat64.getValue();
            }
            case 8: {
                return (double)l >= dFloat64.getValue();
            }
            case 5: {
                return (double)l == dFloat64.getValue();
            }
            case 6: {
                return (double)l != dFloat64.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dFloat64.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DInt16 dInt16) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return l < (long)dInt16.getValue();
            }
            case 10: {
                return l <= (long)dInt16.getValue();
            }
            case 7: {
                return l > (long)dInt16.getValue();
            }
            case 8: {
                return l >= (long)dInt16.getValue();
            }
            case 5: {
                return l == (long)dInt16.getValue();
            }
            case 6: {
                return l != (long)dInt16.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DInt32 dInt32) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return l < (long)dInt32.getValue();
            }
            case 10: {
                return l <= (long)dInt32.getValue();
            }
            case 7: {
                return l > (long)dInt32.getValue();
            }
            case 8: {
                return l >= (long)dInt32.getValue();
            }
            case 5: {
                return l == (long)dInt32.getValue();
            }
            case 6: {
                return l != (long)dInt32.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DString dString) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dString.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DUInt16 dUInt16) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        int n2 = dUInt16.getValue() & 0xFFFF;
        switch (n) {
            case 9: {
                return l < (long)n2;
            }
            case 10: {
                return l <= (long)n2;
            }
            case 7: {
                return l > (long)n2;
            }
            case 8: {
                return l >= (long)n2;
            }
            case 5: {
                return l == (long)n2;
            }
            case 6: {
                return l != (long)n2;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dUInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DUInt32 dUInt322) throws InvalidOperatorException {
        long l = (long)dUInt32.getValue() & 0xFFFFFFFFL;
        long l2 = (long)dUInt322.getValue() & 0xFFFFFFFFL;
        switch (n) {
            case 9: {
                return l < l2;
            }
            case 10: {
                return l <= l2;
            }
            case 7: {
                return l > l2;
            }
            case 8: {
                return l >= l2;
            }
            case 5: {
                return l == l2;
            }
            case 6: {
                return l != l2;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dUInt322.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DUInt32 dUInt32, DURL dURL) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dUInt32.getTypeName(), dURL.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DBoolean dBoolean) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dURL.getTypeName(), dBoolean.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DByte dByte) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dURL.getTypeName(), dByte.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DFloat32 dFloat32) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dURL.getTypeName(), dFloat32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DFloat64 dFloat64) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dURL.getTypeName(), dFloat64.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DInt16 dInt16) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dURL.getTypeName(), dInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DInt32 dInt32) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dURL.getTypeName(), dInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DString dString) throws InvalidOperatorException, RegExpException, SBHException {
        switch (n) {
            case 9: {
                int n2 = dURL.getValue().compareTo(dString.getValue());
                return n2 < 0;
            }
            case 10: {
                int n3 = dURL.getValue().compareTo(dString.getValue());
                return n3 <= 0;
            }
            case 7: {
                int n4 = dURL.getValue().compareTo(dString.getValue());
                return n4 > 0;
            }
            case 8: {
                int n5 = dURL.getValue().compareTo(dString.getValue());
                return n5 >= 0;
            }
            case 5: {
                int n6 = dURL.getValue().compareTo(dString.getValue());
                return n6 == 0;
            }
            case 6: {
                int n7 = dURL.getValue().compareTo(dString.getValue());
                return n7 != 0;
            }
            case 11: {
                try {
                    RE rE = new RE(dURL.getValue());
                    return rE.isMatch(dString.getValue());
                }
                catch (REException rEException) {
                    throw new RegExpException(rEException.getMessage());
                }
                catch (Exception exception) {
                    throw new SBHException(exception.getMessage());
                }
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DUInt16 dUInt16) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dURL.getTypeName(), dUInt16.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DUInt32 dUInt32) throws InvalidOperatorException {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(n, dURL.getTypeName(), dUInt32.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int n, DURL dURL, DURL dURL2) throws InvalidOperatorException, RegExpException, SBHException {
        switch (n) {
            case 9: {
                int n2 = dURL.getValue().compareTo(dURL2.getValue());
                return n2 < 0;
            }
            case 10: {
                int n3 = dURL.getValue().compareTo(dURL2.getValue());
                return n3 <= 0;
            }
            case 7: {
                int n4 = dURL.getValue().compareTo(dURL2.getValue());
                return n4 > 0;
            }
            case 8: {
                int n5 = dURL.getValue().compareTo(dURL2.getValue());
                return n5 >= 0;
            }
            case 5: {
                int n6 = dURL.getValue().compareTo(dURL2.getValue());
                return n6 == 0;
            }
            case 6: {
                int n7 = dURL.getValue().compareTo(dURL2.getValue());
                return n7 != 0;
            }
            case 11: {
                try {
                    RE rE = new RE(dURL.getValue());
                    return rE.isMatch(dURL2.getValue());
                }
                catch (REException rEException) {
                    throw new RegExpException(rEException.getMessage());
                }
                catch (Exception exception) {
                    throw new SBHException(exception.getMessage());
                }
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }
}

