/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.DataReadException;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class Int16PrimitiveVector
extends PrimitiveVector
implements Cloneable {
    private short[] vals;

    public Object clone() {
        Int16PrimitiveVector int16PrimitiveVector = (Int16PrimitiveVector)super.clone();
        if (this.vals != null) {
            int16PrimitiveVector.vals = new short[this.vals.length];
            System.arraycopy(this.vals, 0, int16PrimitiveVector.vals, 0, this.vals.length);
        }
        return int16PrimitiveVector;
    }

    public int getLength() {
        return this.vals.length;
    }

    public void setLength(int n) {
        this.vals = new short[n];
    }

    public final short getValue(int n) {
        return this.vals[n];
    }

    public final void setValue(int n, short s) {
        this.vals[n] = s;
    }

    public void printVal(PrintWriter printWriter, String string) {
        int n = this.vals.length;
        int n2 = 0;
        while (n2 < n - 1) {
            printWriter.print(this.vals[n2]);
            printWriter.print(", ");
            ++n2;
        }
        if (n > 0) {
            printWriter.print(this.vals[n - 1]);
        }
    }

    public void printSingleVal(PrintWriter printWriter, int n) {
        printWriter.print(this.vals[n]);
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int n = 0;
        while (n < this.vals.length) {
            this.vals[n] = (short)dataInputStream.readInt();
            if (statusUI != null) {
                statusUI.incrementByteCount(4);
                if (statusUI.userCancelled()) {
                    throw new DataReadException("User cancelled");
                }
            }
            ++n;
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        while (n < this.vals.length) {
            dataOutputStream.writeInt(this.vals[n]);
            ++n;
        }
    }

    public Object getInternalStorage() {
        return this.vals;
    }

    public Int16PrimitiveVector(BaseType baseType) {
        super(baseType);
    }
}

