/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.DataReadException;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class Float32PrimitiveVector
extends PrimitiveVector
implements Cloneable {
    private float[] vals;

    public Object clone() {
        Float32PrimitiveVector float32PrimitiveVector = (Float32PrimitiveVector)super.clone();
        if (this.vals != null) {
            float32PrimitiveVector.vals = new float[this.vals.length];
            System.arraycopy(this.vals, 0, float32PrimitiveVector.vals, 0, this.vals.length);
        }
        return float32PrimitiveVector;
    }

    public int getLength() {
        return this.vals.length;
    }

    public void setLength(int n) {
        this.vals = new float[n];
    }

    public final float getValue(int n) {
        return this.vals[n];
    }

    public final void setValue(int n, float f) {
        this.vals[n] = f;
    }

    public void printVal(PrintWriter printWriter, String string) {
        int n = this.vals.length;
        int n2 = 0;
        while (n2 < n - 1) {
            printWriter.print(this.vals[n2]);
            printWriter.print(", ");
            ++n2;
        }
        if (n > 0) {
            printWriter.print(this.vals[n - 1]);
        }
    }

    public void printSingleVal(PrintWriter printWriter, int n) {
        printWriter.print(this.vals[n]);
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int n = 0;
        while (n < this.vals.length) {
            this.vals[n] = dataInputStream.readFloat();
            if (statusUI != null) {
                statusUI.incrementByteCount(8);
                if (statusUI.userCancelled()) {
                    throw new DataReadException("User cancelled");
                }
            }
            ++n;
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        while (n < this.vals.length) {
            dataOutputStream.writeFloat(this.vals[n]);
            ++n;
        }
    }

    public Object getInternalStorage() {
        return this.vals;
    }

    public Float32PrimitiveVector(BaseType baseType) {
        super(baseType);
    }
}

