/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.ClientIO;
import dods.dap.DataReadException;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class DVector
extends BaseType
implements ClientIO {
    private PrimitiveVector vals;

    public String getTypeName() {
        return "Vector";
    }

    public Object clone() {
        DVector dVector = (DVector)super.clone();
        dVector.vals = (PrimitiveVector)this.vals.clone();
        return dVector;
    }

    public int getLength() {
        if (this.vals == null) {
            return 0;
        }
        return this.vals.getLength();
    }

    public void setLength(int n) {
        this.vals.setLength(n);
    }

    public void addVariable(BaseType baseType) {
        this.vals = baseType.newPrimitiveVector();
        this.setName(baseType.getName());
    }

    public PrimitiveVector getPrimitiveVector() {
        return this.vals;
    }

    public void printDecl(PrintWriter printWriter, String string, boolean bl, boolean bl2) {
        printWriter.print(string + this.getTypeName());
        this.vals.printDecl(printWriter, " ", bl, bl2);
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.print(" = ");
        }
        printWriter.print("{ ");
        this.vals.printVal(printWriter, "");
        if (bl) {
            printWriter.println("};");
        } else {
            printWriter.print("}");
        }
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int n;
        int n2 = dataInputStream.readInt();
        if (!(this.vals instanceof BaseTypePrimitiveVector) && n2 != (n = dataInputStream.readInt())) {
            throw new DataReadException("Inconsistent array length read.");
        }
        if (n2 < 0) {
            throw new DataReadException("Negative array length read.");
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(8);
        }
        this.vals.setLength(n2);
        this.vals.deserialize(dataInputStream, serverVersion, statusUI);
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        int n = this.vals.getLength();
        dataOutputStream.writeInt(n);
        if (!(this.vals instanceof BaseTypePrimitiveVector)) {
            dataOutputStream.writeInt(n);
        }
        this.vals.externalize(dataOutputStream);
    }

    public DVector() {
    }

    public DVector(String string) {
        super(string);
    }
}

