/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.DConstructor;
import dods.dap.DataReadException;
import dods.dap.NoSuchVariableException;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DStructure
extends DConstructor
implements ClientIO {
    protected Vector vars = new Vector();

    public Object clone() {
        DStructure dStructure = (DStructure)super.clone();
        dStructure.vars = new Vector();
        int n = 0;
        while (n < this.vars.size()) {
            BaseType baseType = (BaseType)this.vars.elementAt(n);
            dStructure.vars.addElement(baseType.clone());
            ++n;
        }
        return dStructure;
    }

    public String getTypeName() {
        return "Structure";
    }

    public int elementCount(boolean bl) {
        if (!bl) {
            return this.vars.size();
        }
        int n = 0;
        Enumeration enumeration = this.vars.elements();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            n += baseType.elementCount(bl);
        }
        return n;
    }

    public void addVariable(BaseType baseType, int n) {
        this.vars.addElement(baseType);
    }

    public BaseType getVariable(String string) throws NoSuchVariableException {
        int n = string.indexOf(46);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            BaseType baseType = this.getVariable(string2);
            if (baseType instanceof DConstructor) {
                return ((DConstructor)baseType).getVariable(string3);
            }
        } else {
            Enumeration enumeration = this.vars.elements();
            while (enumeration.hasMoreElements()) {
                BaseType baseType = (BaseType)enumeration.nextElement();
                if (!baseType.getName().equals(string)) continue;
                return baseType;
            }
        }
        throw new NoSuchVariableException("DStructure: getVariable()");
    }

    public BaseType getVar(int n) throws NoSuchVariableException {
        if (n < this.vars.size()) {
            return (BaseType)this.vars.elementAt(n);
        }
        throw new NoSuchVariableException("DStructure.getVariable(" + n + " - 1)");
    }

    public Enumeration getVariables() {
        return this.vars.elements();
    }

    public void checkSemantics(boolean bl) throws BadSemanticsException {
        super.checkSemantics(bl);
        Util.uniqueNames(this.vars, this.getName(), this.getTypeName());
        if (bl) {
            Enumeration enumeration = this.vars.elements();
            while (enumeration.hasMoreElements()) {
                BaseType baseType = (BaseType)enumeration.nextElement();
                baseType.checkSemantics(true);
            }
        }
    }

    public void printDecl(PrintWriter printWriter, String string, boolean bl, boolean bl2) {
        printWriter.println(string + this.getTypeName() + " {");
        Enumeration enumeration = this.vars.elements();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            baseType.printDecl(printWriter, string + "    ", true, bl2);
        }
        printWriter.print(string + "} " + this.getName());
        if (bl) {
            printWriter.println(";");
        }
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.print(" = ");
        }
        printWriter.print("{ ");
        Enumeration enumeration = this.vars.elements();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            baseType.printVal(printWriter, "", false);
            if (!enumeration.hasMoreElements()) continue;
            printWriter.print(", ");
        }
        printWriter.print(" }");
        if (bl) {
            printWriter.println(";");
        }
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        Enumeration enumeration = this.vars.elements();
        while (enumeration.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            ClientIO clientIO = (ClientIO)enumeration.nextElement();
            clientIO.deserialize(dataInputStream, serverVersion, statusUI);
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        Enumeration enumeration = this.vars.elements();
        while (enumeration.hasMoreElements()) {
            ClientIO clientIO = (ClientIO)enumeration.nextElement();
            clientIO.externalize(dataOutputStream);
        }
    }

    public DStructure() {
        this(null);
    }

    public DStructure(String string) {
        super(string);
    }
}

