/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.DataReadException;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class DString
extends BaseType
implements ClientIO {
    private String val = "String value has not been set.";

    public final String getValue() {
        return this.val;
    }

    public final void setValue(String string) {
        this.val = string;
    }

    public String getTypeName() {
        return "String";
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.println(" = \"" + Util.escattr(this.val) + "\";");
        } else {
            printWriter.print("\"" + Util.escattr(this.val) + "\"");
        }
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int n = dataInputStream.readInt();
        if (n < 0) {
            throw new DataReadException("Negative string length read.");
        }
        int n2 = n % 4;
        int n3 = n2 != 0 ? 4 - n2 : 0;
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray, 0, n);
        int n4 = 0;
        while (n4 < n3) {
            byte by = dataInputStream.readByte();
            ++n4;
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(4 + n + n3);
        }
        try {
            this.val = new String(byArray, 0, n, "ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("ISO8859_1 encoding not supported by this VM!");
            System.exit(1);
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        try {
            byte[] byArray = this.val.getBytes("ISO8859_1");
            dataOutputStream.writeInt(byArray.length);
            int n = byArray.length % 4;
            int n2 = n != 0 ? 4 - n : 0;
            dataOutputStream.write(byArray, 0, byArray.length);
            int n3 = 0;
            while (n3 < n2) {
                dataOutputStream.writeByte(n2);
                ++n3;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("ISO8859_1 encoding not supported by this VM!");
            System.exit(1);
        }
    }

    public DString() {
    }

    public DString(String string) {
        super(string);
    }
}

