/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.DConstructor;
import dods.dap.DataReadException;
import dods.dap.NoSuchVariableException;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DSequence
extends DConstructor
implements ClientIO {
    protected static byte START_OF_INSTANCE = (byte)90;
    protected static byte END_OF_SEQUENCE = (byte)-91;
    protected Vector varTemplate = new Vector();
    protected Vector allValues = new Vector();
    private int level = 0;

    public Object clone() {
        Cloneable cloneable;
        DSequence dSequence = (DSequence)super.clone();
        dSequence.varTemplate = new Vector();
        int n = 0;
        while (n < this.varTemplate.size()) {
            cloneable = (BaseType)this.varTemplate.elementAt(n);
            dSequence.varTemplate.addElement(((BaseType)cloneable).clone());
            ++n;
        }
        dSequence.allValues = new Vector();
        n = 0;
        while (n < this.allValues.size()) {
            cloneable = (Vector)this.allValues.elementAt(n);
            Vector<Object> vector = new Vector<Object>();
            int n2 = 0;
            while (n2 < ((Vector)cloneable).size()) {
                BaseType baseType = (BaseType)((Vector)cloneable).elementAt(n2);
                vector.addElement(baseType.clone());
                ++n2;
            }
            dSequence.allValues.addElement(vector);
            ++n;
        }
        return dSequence;
    }

    public String getTypeName() {
        return "Sequence";
    }

    protected final void setLevel(int n) {
        this.level = n;
    }

    protected final int getLevel() {
        return this.level;
    }

    public int elementCount(boolean bl) {
        if (!bl) {
            return this.varTemplate.size();
        }
        int n = 0;
        Enumeration enumeration = this.varTemplate.elements();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            n += baseType.elementCount(bl);
        }
        return n;
    }

    public void addVariable(BaseType baseType, int n) {
        this.varTemplate.addElement(baseType);
        if (baseType instanceof DSequence) {
            ((DSequence)baseType).setLevel(this.getLevel() + 1);
        }
    }

    public final void addRow(Vector vector) {
        this.allValues.addElement(vector);
    }

    public final Vector getRow(int n) {
        return (Vector)this.allValues.elementAt(n);
    }

    public final void delRow(int n) {
        this.allValues.removeElementAt(n);
    }

    public int getRowCount() {
        return this.allValues.size();
    }

    public BaseType getVariable(String string) throws NoSuchVariableException {
        int n = string.indexOf(46);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            BaseType baseType = this.getVariable(string2);
            if (baseType instanceof DConstructor) {
                return ((DConstructor)baseType).getVariable(string3);
            }
        } else {
            Enumeration enumeration = this.varTemplate.elements();
            while (enumeration.hasMoreElements()) {
                BaseType baseType = (BaseType)enumeration.nextElement();
                if (!baseType.getName().equals(string)) continue;
                return baseType;
            }
        }
        throw new NoSuchVariableException("DSequence: getVariable()");
    }

    public BaseType getVar(int n) throws NoSuchVariableException {
        if (n < this.varTemplate.size()) {
            return (BaseType)this.varTemplate.elementAt(n);
        }
        throw new NoSuchVariableException("DSequence.getVariable(" + n + " - 1)");
    }

    public BaseType getVariable(int n, String string) throws NoSuchVariableException {
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            BaseType baseType = this.getVariable(string2);
            if (baseType instanceof DConstructor) {
                return ((DConstructor)baseType).getVariable(string3);
            }
        } else {
            Vector vector = (Vector)this.allValues.elementAt(n);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                BaseType baseType = (BaseType)enumeration.nextElement();
                if (!baseType.getName().equals(string)) continue;
                return baseType;
            }
        }
        throw new NoSuchVariableException("DSequence: getVariable()");
    }

    public Enumeration getVariables() {
        return this.varTemplate.elements();
    }

    public void checkSemantics(boolean bl) throws BadSemanticsException {
        super.checkSemantics(bl);
        Util.uniqueNames(this.varTemplate, this.getName(), this.getTypeName());
        if (bl) {
            Enumeration enumeration = this.varTemplate.elements();
            while (enumeration.hasMoreElements()) {
                BaseType baseType = (BaseType)enumeration.nextElement();
                baseType.checkSemantics(true);
            }
        }
    }

    public void printDecl(PrintWriter printWriter, String string, boolean bl, boolean bl2) {
        printWriter.println(string + this.getTypeName() + " {");
        Enumeration enumeration = this.varTemplate.elements();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            baseType.printDecl(printWriter, string + "    ", true, bl2);
        }
        printWriter.print(string + "} " + this.getName());
        if (bl) {
            printWriter.println(";");
        }
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.print(" = ");
        }
        printWriter.print("{ ");
        Enumeration enumeration = this.allValues.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.print("{ ");
            Vector vector = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                BaseType baseType = (BaseType)enumeration2.nextElement();
                baseType.printVal(printWriter, "", false);
                if (!enumeration2.hasMoreElements()) continue;
                printWriter.print(", ");
            }
            printWriter.print(" }");
            if (!enumeration.hasMoreElements()) continue;
            printWriter.print(", ");
        }
        printWriter.print(" }");
        if (bl) {
            printWriter.println(";");
        }
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        if (serverVersion.getMajor() < 2 || serverVersion.getMajor() == 2 && serverVersion.getMinor() < 15) {
            this.oldDeserialize(dataInputStream, serverVersion, statusUI);
        } else if (this.getLevel() == 0) {
            byte by;
            while (true) {
                by = this.readMarker(dataInputStream);
                if (statusUI != null) {
                    statusUI.incrementByteCount(4);
                }
                if (by != START_OF_INSTANCE) break;
                this.deserializeSingle(dataInputStream, serverVersion, statusUI);
            }
            if (by != END_OF_SEQUENCE) {
                throw new DataReadException("Sequence start marker not found");
            }
        } else {
            this.deserializeSingle(dataInputStream, serverVersion, statusUI);
        }
    }

    private void oldDeserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, DataReadException {
        try {
            while (true) {
                this.deserializeSingle(dataInputStream, serverVersion, statusUI);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void deserializeSingle(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.varTemplate.size()) {
            object = (BaseType)this.varTemplate.elementAt(n);
            vector.addElement(((BaseType)object).clone());
            ++n;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            object = (ClientIO)enumeration.nextElement();
            object.deserialize(dataInputStream, serverVersion, statusUI);
        }
        this.allValues.addElement(vector);
    }

    private byte readMarker(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        int n = 0;
        while (n < 3) {
            byte by2 = dataInputStream.readByte();
            ++n;
        }
        return by;
    }

    protected void writeMarker(DataOutputStream dataOutputStream, byte by) throws IOException {
        int n = 0;
        while (n < 4) {
            dataOutputStream.writeByte(by);
            ++n;
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        while (n < this.allValues.size()) {
            if (this.getLevel() == 0) {
                this.writeMarker(dataOutputStream, START_OF_INSTANCE);
            }
            Vector vector = (Vector)this.allValues.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                ClientIO clientIO = (ClientIO)vector.elementAt(n2);
                clientIO.externalize(dataOutputStream);
                ++n2;
            }
            ++n;
        }
        if (this.getLevel() == 0) {
            this.writeMarker(dataOutputStream, END_OF_SEQUENCE);
        }
    }

    public DSequence() {
        this(null);
    }

    public DSequence(String string) {
        super(string);
    }
}

