/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.parser.ErrorParser;
import dods.dap.parser.ParseException;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class DODSException
extends Exception {
    public static final int UNDEFINED_ERROR = -1;
    public static final int UNKNOWN_ERROR = 0;
    public static final int NO_SUCH_FILE = 1;
    public static final int NO_SUCH_VARIABLE = 2;
    public static final int MALFORMED_EXPR = 3;
    public static final int NO_AUTHORIZATION = 4;
    public static final int CANNOT_READ_FILE = 5;
    public static final int UNDEFINED_PROG_TYPE = -1;
    public static final int NO_PROGRAM = 0;
    public static final int JAVA_PROGRAM = 1;
    public static final int TCL_PROGRAM = 2;
    private int errorCode;
    private String errorMessage;
    private int programType;
    private String programSource;

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final int getProgramType() {
        return this.programType;
    }

    public final String getProgramSource() {
        return this.programSource;
    }

    public String getMessage() {
        return this.errorMessage;
    }

    public final void setErrorCode(int n) {
        this.errorCode = n;
    }

    public final void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public final void setProgramType(int n) {
        this.programType = n;
    }

    public final void setProgramSource(String string) {
        this.programSource = string;
    }

    public final void parse(InputStream inputStream) {
        ErrorParser errorParser = new ErrorParser(inputStream);
        try {
            errorParser.ErrorObject(this);
        }
        catch (ParseException parseException) {
            String string = parseException.getMessage();
            if (string != null) {
                string.replace('\"', '\'');
            }
            this.errorMessage = "Error parsing server Error object!\n" + string;
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("Error {");
        printWriter.println("    code = " + this.errorCode + ";");
        if (this.errorMessage.charAt(0) == '\"') {
            printWriter.println("    message = " + this.errorMessage + ";");
        } else {
            printWriter.println("    message = \"" + this.errorMessage + "\";");
        }
        printWriter.println("};");
    }

    public final void print(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        this.print(printWriter);
        printWriter.flush();
    }

    public DODSException() {
        super("DODSException");
    }

    public DODSException(String string) {
        this();
        this.errorCode = 0;
        this.errorMessage = string;
    }

    public DODSException(int n, String string) {
        this();
        this.errorCode = n;
        this.errorMessage = string;
    }
}

