/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.DConstructor;
import dods.dap.DataReadException;
import dods.dap.NoSuchVariableException;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DGrid
extends DConstructor
implements ClientIO {
    public static final int ARRAY = 1;
    public static final int MAPS = 2;
    protected DArray arrayVar;
    protected Vector mapVars = new Vector();

    public Object clone() {
        DGrid dGrid = (DGrid)super.clone();
        dGrid.arrayVar = (DArray)this.arrayVar.clone();
        dGrid.mapVars = new Vector();
        int n = 0;
        while (n < this.mapVars.size()) {
            BaseType baseType = (BaseType)this.mapVars.elementAt(n);
            dGrid.mapVars.addElement(baseType.clone());
            ++n;
        }
        return dGrid;
    }

    public String getTypeName() {
        return "Grid";
    }

    public int elementCount(boolean bl) {
        if (!bl) {
            return this.mapVars.size() + 1;
        }
        int n = 0;
        Enumeration enumeration = this.mapVars.elements();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            n += baseType.elementCount(bl);
        }
        return n += this.arrayVar.elementCount(bl);
    }

    public void addVariable(BaseType baseType, int n) {
        if (!(baseType instanceof DArray)) {
            throw new IllegalArgumentException("Grid `" + this.getName() + "'s' member `" + this.arrayVar.getName() + "' must be an array");
        }
        switch (n) {
            case 1: {
                this.arrayVar = (DArray)baseType;
                return;
            }
            case 2: {
                this.mapVars.addElement(baseType);
                return;
            }
        }
        throw new IllegalArgumentException("addVariable(): Unknown Grid part");
    }

    public BaseType getVariable(String string) throws NoSuchVariableException {
        int n = string.indexOf(46);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            BaseType baseType = this.getVariable(string2);
            if (baseType instanceof DConstructor) {
                return ((DConstructor)baseType).getVariable(string3);
            }
        } else {
            if (this.arrayVar.getName().equals(string)) {
                return this.arrayVar;
            }
            Enumeration enumeration = this.mapVars.elements();
            while (enumeration.hasMoreElements()) {
                BaseType baseType = (BaseType)enumeration.nextElement();
                if (!baseType.getName().equals(string)) continue;
                return baseType;
            }
        }
        throw new NoSuchVariableException("DGrid.getVariable() No such variable: '" + string + "'");
    }

    public BaseType getVar(int n) throws NoSuchVariableException {
        if (n == 0) {
            return this.arrayVar;
        }
        int n2 = n - 1;
        if (n2 < this.mapVars.size()) {
            return (BaseType)this.mapVars.elementAt(n2);
        }
        throw new NoSuchVariableException("DGrid.getVariable() No Such variable: " + n + " - 1)");
    }

    public Enumeration getVariables() {
        return new EnumerateDGrid();
    }

    public void checkSemantics(boolean bl) throws BadSemanticsException {
        super.checkSemantics(bl);
        Util.uniqueNames(this.mapVars, this.getName(), this.getTypeName());
        if (this.arrayVar == null) {
            throw new BadSemanticsException("DGrid.checkSemantics(): Null grid base array in `" + this.getName() + "'");
        }
        this.arrayVar.checkSemantics(bl);
        if (this.mapVars.size() != this.arrayVar.numDimensions()) {
            throw new BadSemanticsException("DGrid.checkSemantics(): The number of map variables for grid `" + this.getName() + "' does not match the number of dimensions of `" + this.arrayVar.getName() + "'");
        }
        Enumeration enumeration = this.mapVars.elements();
        Enumeration enumeration2 = this.arrayVar.getDimensions();
        int n = 0;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            DArray dArray = (DArray)enumeration.nextElement();
            Enumeration enumeration3 = dArray.getDimensions();
            DArrayDimension dArrayDimension = (DArrayDimension)enumeration3.nextElement();
            DArrayDimension dArrayDimension2 = (DArrayDimension)enumeration2.nextElement();
            if (dArrayDimension.getSize() != dArrayDimension2.getSize()) {
                throw new BadSemanticsException("In grid '" + this.getName() + " The size of dimension " + n + " in the array component '" + this.arrayVar.getName() + "is not equal to the size of the coresponding map vector '" + dArray.getName() + ".");
            }
            ++n;
        }
    }

    public void printDecl(PrintWriter printWriter, String string, boolean bl, boolean bl2) {
        printWriter.println(string + this.getTypeName() + " {");
        printWriter.println(string + " ARRAY:");
        this.arrayVar.printDecl(printWriter, string + "    ", true);
        printWriter.println(string + " MAPS:");
        Enumeration enumeration = this.mapVars.elements();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            baseType.printDecl(printWriter, string + "    ", true);
        }
        printWriter.print(string + "} " + this.getName());
        if (bl) {
            printWriter.println(";");
        }
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.print(" = ");
        }
        printWriter.print("{ ARRAY: ");
        this.arrayVar.printVal(printWriter, "", false);
        printWriter.print(" MAPS: ");
        Enumeration enumeration = this.mapVars.elements();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            baseType.printVal(printWriter, "", false);
            if (!enumeration.hasMoreElements()) continue;
            printWriter.print(", ");
        }
        printWriter.print(" }");
        if (bl) {
            printWriter.println(";");
        }
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, DataReadException {
        this.arrayVar.deserialize(dataInputStream, serverVersion, statusUI);
        Enumeration enumeration = this.mapVars.elements();
        while (enumeration.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("DGrid.deserialize(): User cancelled");
            }
            ClientIO clientIO = (ClientIO)enumeration.nextElement();
            clientIO.deserialize(dataInputStream, serverVersion, statusUI);
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        this.arrayVar.externalize(dataOutputStream);
        Enumeration enumeration = this.mapVars.elements();
        while (enumeration.hasMoreElements()) {
            ClientIO clientIO = (ClientIO)enumeration.nextElement();
            clientIO.externalize(dataOutputStream);
        }
    }

    public DGrid() {
        this(null);
    }

    public DGrid(String string) {
        super(string);
    }

    class EnumerateDGrid
    implements Enumeration {
        boolean array = false;
        Enumeration e;

        public boolean hasMoreElements() {
            return !this.array || this.e.hasMoreElements();
        }

        public Object nextElement() {
            if (!this.array) {
                this.array = true;
                return DGrid.this.arrayVar;
            }
            return this.e.nextElement();
        }

        EnumerateDGrid() {
            this.e = DGrid.this.mapVars.elements();
        }
    }
}

