/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.Float64PrimitiveVector;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class DFloat64
extends BaseType
implements ClientIO {
    private double val;

    public final double getValue() {
        return this.val;
    }

    public final void setValue(double d) {
        this.val = d;
    }

    public PrimitiveVector newPrimitiveVector() {
        return new Float64PrimitiveVector(this);
    }

    public String getTypeName() {
        return "Float64";
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.println(" = " + this.val + ";");
        } else {
            printWriter.print(this.val);
        }
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException {
        this.val = dataInputStream.readDouble();
        if (statusUI != null) {
            statusUI.incrementByteCount(8);
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeDouble(this.val);
    }

    public DFloat64() {
    }

    public DFloat64(String string) {
        super(string);
    }
}

