/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.Float32PrimitiveVector;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class DFloat32
extends BaseType
implements ClientIO {
    private float val;

    public final float getValue() {
        return this.val;
    }

    public final void setValue(float f) {
        this.val = f;
    }

    public PrimitiveVector newPrimitiveVector() {
        return new Float32PrimitiveVector(this);
    }

    public String getTypeName() {
        return "Float32";
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.println(" = " + this.val + ";");
        } else {
            printWriter.print(this.val);
        }
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException {
        this.val = dataInputStream.readFloat();
        if (statusUI != null) {
            statusUI.incrementByteCount(4);
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeFloat(this.val);
    }

    public DFloat32() {
    }

    public DFloat32(String string) {
        super(string);
    }
}

