/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.BaseTypeFactory;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.DConstructor;
import dods.dap.DDSException;
import dods.dap.DVector;
import dods.dap.DefaultFactory;
import dods.dap.NoSuchVariableException;
import dods.dap.Util;
import dods.dap.parser.DDSParser;
import dods.dap.parser.ParseException;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class DDS
implements Cloneable {
    protected String name;
    protected Vector vars;
    private BaseTypeFactory factory;

    public Object clone() {
        try {
            DDS dDS = (DDS)super.clone();
            dDS.vars = new Vector();
            int n = 0;
            while (n < this.vars.size()) {
                BaseType baseType = (BaseType)this.vars.elementAt(n);
                dDS.vars.addElement(baseType.clone());
                ++n;
            }
            dDS.name = new String(this.name);
            dDS.factory = this.factory;
            return dDS;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final BaseTypeFactory getFactory() {
        return this.factory;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final void addVariable(BaseType baseType) {
        this.vars.addElement(baseType);
    }

    public final void delVariable(String string) {
        try {
            BaseType baseType = this.getVariable(string);
            this.vars.removeElement(baseType);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
    }

    private DConstructor isVectorOfDConstructor(BaseType baseType) {
        if (!(baseType instanceof DVector)) {
            return null;
        }
        if (!(((DVector)baseType).getPrimitiveVector() instanceof BaseTypePrimitiveVector)) {
            return null;
        }
        BaseTypePrimitiveVector baseTypePrimitiveVector = (BaseTypePrimitiveVector)((DVector)baseType).getPrimitiveVector();
        if (baseTypePrimitiveVector.getTemplate() instanceof DConstructor) {
            return (DConstructor)baseTypePrimitiveVector.getTemplate();
        }
        return this.isVectorOfDConstructor(baseTypePrimitiveVector.getTemplate());
    }

    public BaseType getVariable(String string) throws NoSuchVariableException {
        Stack stack = new Stack();
        stack = this.search(string, stack);
        return (BaseType)stack.pop();
    }

    public Stack search(String string, Stack stack) throws NoSuchVariableException {
        DDSSearch dDSSearch = new DDSSearch(stack);
        if (dDSSearch.deepSearch(string)) {
            return dDSSearch.components;
        }
        throw new NoSuchVariableException("The variable `" + string + "' was not found in the dateset.");
    }

    public final Enumeration getVariables() {
        return this.vars.elements();
    }

    public final int numVariables() {
        return this.vars.size();
    }

    public void parse(InputStream inputStream) throws ParseException, DDSException {
        DDSParser dDSParser = new DDSParser(inputStream);
        dDSParser.Dataset(this, this.factory);
    }

    public void checkSemantics(boolean bl) throws BadSemanticsException {
        if (this.name == null) {
            System.err.println("A dataset must have a name");
            throw new BadSemanticsException("DDS.checkSemantics(): A dataset must have a name");
        }
        Util.uniqueNames(this.vars, this.name, "Dataset");
        if (bl) {
            Enumeration enumeration = this.vars.elements();
            while (enumeration.hasMoreElements()) {
                BaseType baseType = (BaseType)enumeration.nextElement();
                baseType.checkSemantics(true);
            }
        }
    }

    public final void checkSemantics() throws BadSemanticsException {
        this.checkSemantics(false);
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("Dataset {");
        Enumeration enumeration = this.vars.elements();
        while (enumeration.hasMoreElements()) {
            BaseType baseType = (BaseType)enumeration.nextElement();
            baseType.printDecl(printWriter);
        }
        printWriter.print("} ");
        if (this.name != null) {
            printWriter.print(this.name);
        }
        printWriter.println(";");
    }

    public final void print(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        this.print(printWriter);
        printWriter.flush();
    }

    public DDS() {
        this(null, new DefaultFactory());
    }

    public DDS(String string) {
        this(string, new DefaultFactory());
    }

    public DDS(BaseTypeFactory baseTypeFactory) {
        this(null, baseTypeFactory);
    }

    public DDS(String string, BaseTypeFactory baseTypeFactory) {
        this.name = string;
        this.vars = new Vector();
        this.factory = baseTypeFactory;
    }

    private final class DDSSearch {
        Stack components;

        /*
         * Enabled aggressive block sorting
         */
        BaseType simpleSearch(String string, BaseType baseType) {
            Enumeration enumeration = null;
            if (baseType == null) {
                enumeration = DDS.this.getVariables();
            } else if (baseType instanceof DConstructor) {
                enumeration = ((DConstructor)baseType).getVariables();
            } else {
                DConstructor dConstructor = DDS.this.isVectorOfDConstructor(baseType);
                if (dConstructor == null) {
                    return null;
                }
                enumeration = dConstructor.getVariables();
            }
            while (enumeration.hasMoreElements()) {
                BaseType baseType2 = (BaseType)enumeration.nextElement();
                if (!baseType2.getName().equals(string)) continue;
                return baseType2;
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean deepSearch(String string) throws NoSuchVariableException {
            Enumeration enumeration;
            BaseType baseType = this.components.empty() ? null : (BaseType)this.components.peek();
            BaseType baseType2 = this.simpleSearch(string, baseType);
            if (baseType2 != null) {
                this.components.push(baseType2);
                return true;
            }
            if (baseType == null) {
                enumeration = DDS.this.getVariables();
            } else if (baseType instanceof DConstructor) {
                enumeration = ((DConstructor)baseType).getVariables();
            } else {
                DConstructor dConstructor = DDS.this.isVectorOfDConstructor(baseType);
                if (dConstructor == null) {
                    return false;
                }
                enumeration = dConstructor.getVariables();
            }
            while (enumeration.hasMoreElements()) {
                BaseType baseType3 = (BaseType)enumeration.nextElement();
                this.components.push(baseType3);
                if (this.deepSearch(string)) {
                    return true;
                }
                this.components.pop();
            }
            return false;
        }

        DDSSearch(Stack stack) {
            this.components = stack;
        }
    }
}

