/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseTypeFactory;
import dods.dap.DAS;
import dods.dap.DASException;
import dods.dap.DDS;
import dods.dap.DDSException;
import dods.dap.DODSException;
import dods.dap.DataDDS;
import dods.dap.DefaultFactory;
import dods.dap.HeaderInputStream;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.parser.ParseException;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.InflaterInputStream;

public class DConnect {
    private InputStream fileStream;
    private URLConnection connection;
    private String urlString;
    private String projString;
    private String selString;
    private boolean acceptDeflate;
    private ServerVersion ver;

    public final boolean isLocal() {
        return this.fileStream != null;
    }

    public final String CE() {
        return this.projString + this.selString;
    }

    public final String URL() {
        return this.urlString;
    }

    private InputStream openConnection(URL uRL) throws IOException, DODSException {
        this.connection = uRL.openConnection();
        if (this.acceptDeflate) {
            this.connection.setRequestProperty("Accept-Encoding", "deflate");
        }
        this.connection.connect();
        InputStream inputStream = this.connection.getInputStream();
        String string = this.connection.getHeaderField("content-description");
        this.handleContentDesc(inputStream, string);
        this.ver = new ServerVersion(this.connection.getHeaderField("xdods-server"));
        String string2 = this.connection.getContentEncoding();
        return this.handleContentEncoding(inputStream, string2);
    }

    public DAS getDAS() throws MalformedURLException, IOException, ParseException, DASException, DODSException {
        Object object;
        InputStream inputStream;
        if (this.fileStream != null) {
            inputStream = this.parseMime(this.fileStream);
        } else {
            object = new URL(this.urlString + ".das" + this.projString + this.selString);
            inputStream = this.openConnection((URL)object);
        }
        object = new DAS();
        try {
            ((DAS)object).parse(inputStream);
        }
        finally {
            Object var4_3 = null;
            inputStream.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
        return object;
    }

    public DDS getDDS() throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        Object object;
        InputStream inputStream;
        if (this.fileStream != null) {
            inputStream = this.parseMime(this.fileStream);
        } else {
            object = new URL(this.urlString + ".dds" + this.projString + this.selString);
            inputStream = this.openConnection((URL)object);
        }
        object = new DDS();
        try {
            ((DDS)object).parse(inputStream);
        }
        finally {
            Object var4_3 = null;
            inputStream.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
        return object;
    }

    public DataDDS getData(String string, StatusUI statusUI, BaseTypeFactory baseTypeFactory) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        Object object;
        InputStream inputStream;
        if (this.fileStream != null) {
            inputStream = this.parseMime(this.fileStream);
        } else {
            String string2;
            int n = string.indexOf(38);
            if (n != -1) {
                object = string.substring(0, n);
                string2 = string.substring(n);
            } else {
                object = string;
                string2 = "";
            }
            URL uRL = new URL(this.urlString + ".dods" + this.projString + (String)object + this.selString + string2);
            inputStream = this.openConnection(uRL);
        }
        object = new DataDDS(this.ver, baseTypeFactory);
        try {
            ((DDS)object).parse(new HeaderInputStream(inputStream));
            ((DataDDS)object).readData(inputStream, statusUI);
        }
        finally {
            Object var7_6 = null;
            inputStream.close();
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
        }
        return object;
    }

    public DataDDS getData(String string, StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        return this.getData(string, statusUI, new DefaultFactory());
    }

    public final DataDDS getData(StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DODSException {
        return this.getData("", statusUI, new DefaultFactory());
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    private InputStream parseMime(InputStream inputStream) throws IOException, DODSException {
        String string;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string2 = null;
        String string3 = null;
        while (!(string = dataInputStream.readLine()).equals("")) {
            int n = string.indexOf(32);
            if (n == -1) continue;
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1);
            if (string4.equals("Server:")) {
                this.ver = new ServerVersion(string5);
                continue;
            }
            if (string4.equals("Content-Description:")) {
                string2 = string5;
                continue;
            }
            if (!string4.equals("Content-Encoding:")) continue;
            string3 = string5;
        }
        this.handleContentDesc(inputStream, string2);
        return this.handleContentEncoding(inputStream, string3);
    }

    private void handleContentDesc(InputStream inputStream, String string) throws IOException, DODSException {
        if (string != null && string.equals("dods_error")) {
            DODSException dODSException = new DODSException();
            dODSException.parse(inputStream);
            throw dODSException;
        }
    }

    private InputStream handleContentEncoding(InputStream inputStream, String string) {
        if (string != null && string.equals("deflate")) {
            return new InflaterInputStream(inputStream);
        }
        return inputStream;
    }

    public DConnect(String string) throws FileNotFoundException {
        this(string, true);
    }

    public DConnect(String string, boolean bl) throws FileNotFoundException {
        Object object;
        int n = string.indexOf(63);
        if (n != -1) {
            this.urlString = string.substring(0, n);
            object = string.substring(n);
            int n2 = ((String)object).indexOf(38);
            if (n2 != -1) {
                this.projString = ((String)object).substring(0, n2);
                this.selString = ((String)object).substring(n2);
            } else {
                this.projString = object;
                this.selString = "";
            }
        } else {
            this.urlString = string;
            this.selString = "";
            this.projString = "";
        }
        this.acceptDeflate = bl;
        try {
            object = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.fileStream = new FileInputStream(string);
        }
    }

    public DConnect(InputStream inputStream) {
        this.fileStream = inputStream;
    }
}

