/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.BytePrimitiveVector;
import dods.dap.ClientIO;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class DByte
extends BaseType
implements ClientIO {
    private byte val;

    public final byte getValue() {
        return this.val;
    }

    public final void setValue(byte by) {
        this.val = by;
    }

    public PrimitiveVector newPrimitiveVector() {
        return new BytePrimitiveVector(this);
    }

    public String getTypeName() {
        return "Byte";
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.println(" = " + (this.val & 0xFF) + ";");
        } else {
            printWriter.print(this.val & 0xFF);
        }
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException {
        int n = 0;
        while (n < 3) {
            byte by = dataInputStream.readByte();
            ++n;
        }
        this.val = dataInputStream.readByte();
        if (statusUI != null) {
            statusUI.incrementByteCount(4);
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        while (n < 3) {
            dataOutputStream.writeByte(0);
            ++n;
        }
        dataOutputStream.writeByte(this.val);
    }

    public DByte() {
    }

    public DByte(String string) {
        super(string);
    }
}

