/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.BooleanPrimitiveVector;
import dods.dap.ClientIO;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class DBoolean
extends BaseType
implements ClientIO {
    private boolean val;

    public final boolean getValue() {
        return this.val;
    }

    public final void setValue(boolean bl) {
        this.val = bl;
    }

    public PrimitiveVector newPrimitiveVector() {
        return new BooleanPrimitiveVector(this);
    }

    public String getTypeName() {
        return "Boolean";
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.println(" = " + this.val + ";");
        } else {
            printWriter.print(this.val);
        }
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException {
        this.val = dataInputStream.readBoolean();
        if (statusUI != null) {
            statusUI.incrementByteCount(1);
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(this.val);
    }

    public DBoolean() {
    }

    public DBoolean(String string) {
        super(string);
    }
}

