/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.Server.InvalidParameterException;

public final class DArrayDimension
implements Cloneable {
    private String name;
    private int size;
    private int start;
    private int stride;
    private int stop;

    public Object clone() {
        try {
            DArrayDimension dArrayDimension = (DArrayDimension)super.clone();
            return dArrayDimension;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setProjection(int n, int n2, int n3) throws InvalidParameterException {
        String string = "DArrayDimension.setProjection: Bad Projection Request: ";
        if (n >= this.size) {
            throw new InvalidParameterException(string + "start >= size");
        }
        if (n < 0) {
            throw new InvalidParameterException(string + "start < 0");
        }
        if (n2 <= 0) {
            throw new InvalidParameterException(string + "stride <= 0");
        }
        if (n3 >= this.size) {
            throw new InvalidParameterException(string + "stop >= size");
        }
        if (n3 < 0) {
            throw new InvalidParameterException(string + "stop < 0");
        }
        if (n3 < n) {
            throw new InvalidParameterException(string + "stop < start");
        }
        this.start = n;
        this.stride = n2;
        this.stop = n3;
        this.size = 1 + (n3 - n) / n2;
    }

    public int getStart() {
        return this.start;
    }

    public int getStride() {
        return this.stride;
    }

    public int getStop() {
        return this.stop;
    }

    public DArrayDimension(int n, String string) {
        this.size = n;
        this.name = string;
        this.start = 0;
        this.stride = 1;
        this.stop = n - 1;
    }
}

