/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.DArrayDimension;
import dods.dap.DVector;
import dods.dap.Server.InvalidParameterException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DArray
extends DVector
implements Cloneable {
    private Vector dimVector = new Vector();

    public Object clone() {
        DArray dArray = (DArray)super.clone();
        dArray.dimVector = new Vector();
        int n = 0;
        while (n < this.dimVector.size()) {
            DArrayDimension dArrayDimension = (DArrayDimension)this.dimVector.elementAt(n);
            dArray.dimVector.addElement(dArrayDimension.clone());
            ++n;
        }
        return dArray;
    }

    public String getTypeName() {
        return "Array";
    }

    public void checkSemantics(boolean bl) throws BadSemanticsException {
        super.checkSemantics(bl);
        if (this.dimVector.isEmpty()) {
            throw new BadSemanticsException("An array variable must have dimensions");
        }
    }

    public void printDecl(PrintWriter printWriter, String string, boolean bl, boolean bl2) {
        this.getPrimitiveVector().printDecl(printWriter, string, false, bl2);
        Enumeration enumeration = this.dimVector.elements();
        while (enumeration.hasMoreElements()) {
            DArrayDimension dArrayDimension = (DArrayDimension)enumeration.nextElement();
            printWriter.print("[");
            if (dArrayDimension.getName() != null) {
                printWriter.print(dArrayDimension.getName() + " = ");
            }
            printWriter.print(dArrayDimension.getSize() + "]");
        }
        if (bl) {
            printWriter.println(";");
        }
    }

    public void printVal(PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            this.printDecl(printWriter, string, false);
            printWriter.print(" = ");
        }
        int n = this.numDimensions();
        int[] nArray = new int[n];
        int n2 = 0;
        Enumeration enumeration = this.dimVector.elements();
        while (enumeration.hasMoreElements()) {
            DArrayDimension dArrayDimension = (DArrayDimension)enumeration.nextElement();
            nArray[n2++] = dArrayDimension.getSize();
        }
        this.printArray(printWriter, 0, n, nArray, 0);
        if (bl) {
            printWriter.println(";");
        }
    }

    private int printArray(PrintWriter printWriter, int n, int n2, int[] nArray, int n3) {
        if (n2 == 1) {
            printWriter.print("{");
            int n4 = 0;
            while (n4 < nArray[n3] - 1) {
                this.getPrimitiveVector().printSingleVal(printWriter, n++);
                printWriter.print(", ");
                ++n4;
            }
            this.getPrimitiveVector().printSingleVal(printWriter, n++);
            printWriter.print("}");
            return n;
        }
        printWriter.print("{");
        int n5 = 0;
        while (n5 < nArray[n3] - 1) {
            n = this.printArray(printWriter, n, n2 - 1, nArray, n3 + 1);
            printWriter.print(",");
            ++n5;
        }
        n = this.printArray(printWriter, n, n2 - 1, nArray, n3 + 1);
        printWriter.print("}");
        return n;
    }

    public void appendDim(int n, String string) {
        DArrayDimension dArrayDimension = new DArrayDimension(n, string);
        this.dimVector.addElement(dArrayDimension);
    }

    public void appendDim(int n) {
        this.appendDim(n, null);
    }

    public final Enumeration getDimensions() {
        return this.dimVector.elements();
    }

    public final int numDimensions() {
        return this.dimVector.size();
    }

    public DArrayDimension getDimension(int n) throws InvalidParameterException {
        if (n < this.dimVector.size()) {
            return (DArrayDimension)this.dimVector.get(n);
        }
        throw new InvalidParameterException("DArray.getDimension(): Bad dimension request: dimension > # of dimensions");
    }

    public DArrayDimension getFirstDimension() {
        return (DArrayDimension)this.dimVector.get(0);
    }

    public DArray() {
        this(null);
    }

    public DArray(String string) {
        super(string);
    }
}

