/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.AttributeTable;
import dods.dap.DASException;
import dods.dap.parser.DASParser;
import dods.dap.parser.ParseException;
import dods.util.SortedTable;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;

public class DAS
implements Cloneable {
    private SortedTable attr = new SortedTable();

    public Object clone() {
        try {
            DAS dAS = (DAS)super.clone();
            dAS.attr = new SortedTable();
            int n = 0;
            while (n < this.attr.size()) {
                String string = (String)this.attr.getKey(n);
                AttributeTable attributeTable = (AttributeTable)this.attr.elementAt(n);
                dAS.attr.put(string, attributeTable.clone());
                ++n;
            }
            return dAS;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final Enumeration getNames() {
        return this.attr.keys();
    }

    public final AttributeTable getAttributeTable(String string) {
        return (AttributeTable)this.attr.get(string);
    }

    public void addAttributeTable(String string, AttributeTable attributeTable) {
        this.attr.put(string, attributeTable);
    }

    public void parse(InputStream inputStream) throws ParseException, DASException {
        DASParser dASParser = new DASParser(inputStream);
        dASParser.Attributes(this);
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("Attributes {");
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            printWriter.println("    " + string + " {");
            this.getAttributeTable(string).print(printWriter, "        ");
            printWriter.println("    }");
        }
        printWriter.println("}");
        printWriter.flush();
    }

    public final void print(OutputStream outputStream) {
        this.print(new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream))));
    }
}

