/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.DataReadException;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class BytePrimitiveVector
extends PrimitiveVector
implements Cloneable {
    private byte[] vals;

    public Object clone() {
        BytePrimitiveVector bytePrimitiveVector = (BytePrimitiveVector)super.clone();
        if (this.vals != null) {
            bytePrimitiveVector.vals = new byte[this.vals.length];
            System.arraycopy(this.vals, 0, bytePrimitiveVector.vals, 0, this.vals.length);
        }
        return bytePrimitiveVector;
    }

    public int getLength() {
        return this.vals.length;
    }

    public void setLength(int n) {
        this.vals = new byte[n];
    }

    public final byte getValue(int n) {
        return this.vals[n];
    }

    public final void setValue(int n, byte by) {
        this.vals[n] = by;
    }

    public void printVal(PrintWriter printWriter, String string) {
        int n = this.vals.length;
        int n2 = 0;
        while (n2 < n - 1) {
            printWriter.print(this.vals[n2] & 0xFF);
            printWriter.print(", ");
            ++n2;
        }
        if (n > 0) {
            printWriter.print(this.vals[n - 1] & 0xFF);
        }
    }

    public void printSingleVal(PrintWriter printWriter, int n) {
        printWriter.print(this.vals[n] & 0xFF);
    }

    public synchronized void deserialize(DataInputStream dataInputStream, ServerVersion serverVersion, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int n = this.vals.length % 4;
        int n2 = n != 0 ? 4 - n : 0;
        int n3 = 0;
        while (n3 < this.vals.length) {
            this.vals[n3] = dataInputStream.readByte();
            if (statusUI != null) {
                statusUI.incrementByteCount(1);
                if (statusUI.userCancelled()) {
                    throw new DataReadException("User cancelled");
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            n3 = dataInputStream.readByte();
            ++n4;
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(n2);
        }
    }

    public void externalize(DataOutputStream dataOutputStream) throws IOException {
        int n = this.vals.length % 4;
        int n2 = n != 0 ? 4 - n : 0;
        int n3 = 0;
        while (n3 < this.vals.length) {
            dataOutputStream.writeByte(this.vals[n3]);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            dataOutputStream.writeByte(0);
            ++n3;
        }
    }

    public Object getInternalStorage() {
        return this.vals;
    }

    public BytePrimitiveVector(BaseType baseType) {
        super(baseType);
    }
}

