/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.Attribute;
import dods.dap.AttributeBadValueException;
import dods.dap.AttributeExistsException;
import dods.dap.NoSuchAttributeException;
import dods.util.SortedTable;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;

public class AttributeTable
implements Cloneable {
    private SortedTable attr = new SortedTable();

    public Object clone() {
        try {
            AttributeTable attributeTable = (AttributeTable)super.clone();
            attributeTable.attr = new SortedTable();
            int n = 0;
            while (n < this.attr.size()) {
                String string = (String)this.attr.getKey(n);
                Attribute attribute = (Attribute)this.attr.elementAt(n);
                attributeTable.attr.put(string, attribute.clone());
                ++n;
            }
            return attributeTable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final Enumeration getNames() {
        return this.attr.keys();
    }

    public final Attribute getAttribute(String string) {
        return (Attribute)this.attr.get(string);
    }

    public final void appendAttribute(String string, int n, String string2) throws AttributeExistsException, AttributeBadValueException {
        Attribute attribute = (Attribute)this.attr.get(string);
        if (attribute != null && n != attribute.getType()) {
            throw new AttributeExistsException("`" + string + "' previously defined.");
        }
        if (attribute != null) {
            attribute.appendValue(string2);
        } else {
            attribute = new Attribute(n, string2);
            this.attr.put(string, attribute);
        }
    }

    public final AttributeTable appendContainer(String string) {
        if (this.attr.get(string) != null) {
            return null;
        }
        AttributeTable attributeTable = new AttributeTable();
        Attribute attribute = new Attribute(attributeTable);
        this.attr.put(string, attribute);
        return attributeTable;
    }

    public final void addAlias(String string, String string2) throws NoSuchAttributeException, AttributeExistsException {
        if (this.attr.get(string) != null) {
            throw new AttributeExistsException("Could not alias `" + string2 + "' and `" + string + "'.");
        }
        Attribute attribute = (Attribute)this.attr.get(string2);
        if (attribute == null) {
            throw new NoSuchAttributeException("Could not alias `" + string2 + "' and `" + string + "'.");
        }
        Attribute attribute2 = new Attribute(string2, attribute);
        this.attr.put(string, attribute2);
    }

    public final void delAttribute(String string) {
        this.attr.remove(string);
    }

    public final void delAttribute(String string, int n) {
        if (n == -1) {
            this.attr.remove(string);
        } else {
            Attribute attribute = (Attribute)this.attr.get(string);
            if (attribute != null) {
                if (attribute.isContainer()) {
                    this.attr.remove(string);
                } else {
                    attribute.deleteValueAt(n);
                }
            }
        }
    }

    public void print(PrintWriter printWriter, String string) {
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Attribute attribute = this.getAttribute(string2);
            if (attribute.isAlias()) {
                printWriter.println(string + "Alias " + string2 + " " + attribute.getAliasedTo() + ";");
                continue;
            }
            if (attribute.isContainer()) {
                printWriter.println(string + string2 + " {");
                attribute.getContainer().print(printWriter, string + "    ");
                printWriter.println(string + "}");
                continue;
            }
            printWriter.print(string + attribute.getTypeString() + " " + string2 + " ");
            Enumeration enumeration2 = attribute.getValues();
            String string3 = (String)enumeration2.nextElement();
            while (enumeration2.hasMoreElements()) {
                printWriter.print(string3 + ", ");
                string3 = (String)enumeration2.nextElement();
            }
            printWriter.println(string3 + ";");
        }
        printWriter.flush();
    }

    public final void print(OutputStream outputStream, String string) {
        this.print(new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream))), string);
    }

    public final void print(PrintWriter printWriter) {
        this.print(printWriter, "    ");
    }

    public final void print(OutputStream outputStream) {
        this.print(outputStream, "    ");
    }
}

