/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.AttributeBadValueException;
import dods.dap.AttributeTable;
import java.util.Enumeration;
import java.util.Vector;

public class Attribute
implements Cloneable {
    public static final int UNKNOWN = 1;
    public static final int CONTAINER = 2;
    public static final int BYTE = 3;
    public static final int INT16 = 4;
    public static final int UINT16 = 5;
    public static final int INT32 = 6;
    public static final int UINT32 = 7;
    public static final int FLOAT32 = 8;
    public static final int FLOAT64 = 9;
    public static final int STRING = 10;
    public static final int URL = 11;
    private int type;
    private boolean is_alias;
    private String aliased_to;
    private Object attr;

    public Object clone() {
        try {
            Attribute attribute = (Attribute)super.clone();
            attribute.attr = this.type == 2 ? ((AttributeTable)this.attr).clone() : ((Vector)this.attr).clone();
            return attribute;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final String getTypeString() {
        switch (this.type) {
            case 2: {
                return "Container";
            }
            case 3: {
                return "Byte";
            }
            case 4: {
                return "Int16";
            }
            case 5: {
                return "UInt16";
            }
            case 6: {
                return "Int32";
            }
            case 7: {
                return "UInt32";
            }
            case 8: {
                return "Float32";
            }
            case 9: {
                return "Float64";
            }
            case 10: {
                return "String";
            }
            case 11: {
                return "Url";
            }
        }
        return "";
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isContainer() {
        return this.type == 2;
    }

    public final boolean isAlias() {
        return this.is_alias;
    }

    public final String getAliasedTo() {
        return this.aliased_to;
    }

    public final AttributeTable getContainer() {
        return (AttributeTable)this.attr;
    }

    public final Enumeration getValues() {
        return ((Vector)this.attr).elements();
    }

    public final String getValueAt(int n) {
        return (String)((Vector)this.attr).elementAt(n);
    }

    public final void appendValue(String string) throws AttributeBadValueException {
        Attribute.dispatchCheckValue(this.type, string);
        ((Vector)this.attr).addElement(string);
    }

    public final void deleteValueAt(int n) {
        ((Vector)this.attr).removeElementAt(n);
    }

    private static void dispatchCheckValue(int n, String string) throws AttributeBadValueException {
        switch (n) {
            case 3: {
                if (Attribute.checkByte(string)) break;
                throw new AttributeBadValueException("`" + string + "' is not a Byte value.");
            }
            case 4: {
                if (Attribute.checkShort(string)) break;
                throw new AttributeBadValueException("`" + string + "' is not an Int16 value.");
            }
            case 5: {
                if (Attribute.checkUShort(string)) break;
                throw new AttributeBadValueException("`" + string + "' is not an UInt16 value.");
            }
            case 6: {
                if (Attribute.checkInt(string)) break;
                throw new AttributeBadValueException("`" + string + "' is not an Int32 value.");
            }
            case 7: {
                if (Attribute.checkUInt(string)) break;
                throw new AttributeBadValueException("`" + string + "' is not an UInt32 value.");
            }
            case 8: {
                if (Attribute.checkFloat(string)) break;
                throw new AttributeBadValueException("`" + string + "' is not a Float32 value.");
            }
            case 9: {
                if (Attribute.checkDouble(string)) break;
                throw new AttributeBadValueException("`" + string + "' is not a Float64 value.");
            }
        }
    }

    private static final boolean checkByte(String string) {
        try {
            short s = Short.parseShort(string);
            return s <= 255;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static final boolean checkShort(String string) {
        try {
            Short.parseShort(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static final boolean checkUShort(String string) {
        try {
            long l = Long.parseLong(string);
            return l <= 65535L;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static final boolean checkInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static final boolean checkUInt(String string) {
        try {
            long l = Long.parseLong(string);
            return l <= 0xFFFFFFFFL;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static final boolean checkFloat(String string) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static final boolean checkDouble(String string) {
        try {
            Double.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public Attribute(int n, String string) throws AttributeBadValueException {
        Attribute.dispatchCheckValue(n, string);
        this.type = n;
        this.is_alias = false;
        this.attr = new Vector();
        ((Vector)this.attr).addElement(string);
    }

    public Attribute(AttributeTable attributeTable) {
        this.type = 2;
        this.is_alias = false;
        this.attr = attributeTable;
    }

    public Attribute(String string, Attribute attribute) {
        this.type = attribute.type;
        this.is_alias = true;
        this.aliased_to = string;
        this.attr = attribute.attr;
    }

    public Attribute(int n) throws IllegalArgumentException {
        this.type = n;
        if (n == 2) {
            throw new IllegalArgumentException("can't construct Attribute(CONTAINER)");
        }
        this.attr = new Vector();
    }
}

