/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.UnionSet;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class VisuTraj {
    int nbTrajectories = 60;
    float[][][] vectTrajectories;
    DataReferenceImpl referenceTrajectories;
    RealType latitude;
    RealType longitude;
    RealType profondeur;
    RealType trajectories;
    RealTupleType domain3D;

    DataImpl makeTrajectories() throws VisADException, RemoteException {
        SampledSet[] sampledSetArray = new SampledSet[this.nbTrajectories];
        int n = 0;
        while (n < this.nbTrajectories) {
            float[][] fArray = new float[3][5];
            int n2 = 0;
            while (n2 < 3) {
                int n3 = 0;
                while (n3 < 5) {
                    fArray[n2][n3] = this.vectTrajectories[n2][n3][n];
                    ++n3;
                }
                ++n2;
            }
            sampledSetArray[n] = new Gridded3DSet((MathType)this.domain3D, fArray, 5, null, null, null);
            ++n;
        }
        return new UnionSet((MathType)this.domain3D, sampledSetArray);
    }

    public void initVisad() {
        try {
            this.latitude = new RealType("latitude");
            this.longitude = new RealType("longitude");
            this.profondeur = new RealType("profondeur");
            this.trajectories = new RealType("trajectories");
            this.domain3D = new RealTupleType(this.latitude, this.longitude, this.profondeur);
            this.referenceTrajectories = new DataReferenceImpl("trajectories");
            DataImpl dataImpl = this.makeTrajectories();
            this.referenceTrajectories.setData(dataImpl);
            ScalarMap scalarMap = new ScalarMap(this.latitude, Display.YAxis);
            ScalarMap scalarMap2 = new ScalarMap(this.longitude, Display.XAxis);
            ScalarMap scalarMap3 = new ScalarMap(this.profondeur, Display.ZAxis);
            ScalarMap scalarMap4 = new ScalarMap(this.profondeur, Display.RGBA);
            DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display");
            displayImplJ3D.addMap(scalarMap);
            displayImplJ3D.addMap(scalarMap2);
            displayImplJ3D.addMap(scalarMap3);
            displayImplJ3D.addReference(this.referenceTrajectories);
            JFrame jFrame = new JFrame("VisAD Tutorial");
            jFrame.getContentPane().add(displayImplJ3D.getComponent());
            ((Component)jFrame).setSize(600, 600);
            ((Component)jFrame).setLocation(300, 300);
            ((Component)jFrame).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public void step(int n) {
        boolean bl = false;
        try {
            Thread.sleep(100L);
            this.setData();
            DataImpl dataImpl = this.makeTrajectories();
            this.referenceTrajectories.setData(dataImpl);
            System.out.println(" iteration " + n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public void initData() {
        this.vectTrajectories = new float[3][5][this.nbTrajectories];
        int n = 0;
        while (n < this.nbTrajectories) {
            int n2 = 0;
            while (n2 < 3) {
                this.vectTrajectories[n2][0][n] = (float)Math.random() * 50.1f;
                int n3 = 1;
                while (n3 < 5) {
                    this.vectTrajectories[n2][n3][n] = this.vectTrajectories[n2][n3 - 1][n] + ((float)Math.random() - 0.5f) * 4.0f;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setData() {
        int n = 0;
        while (n < this.nbTrajectories) {
            int n2 = 0;
            while (n2 < 3) {
                int n3 = 0;
                while (n3 < 4) {
                    this.vectTrajectories[n2][n3][n] = this.vectTrajectories[n2][n3 + 1][n];
                    ++n3;
                }
                float[] fArray = this.vectTrajectories[n2][4];
                int n4 = n;
                fArray[n4] = fArray[n4] + ((float)Math.random() - 0.5f) * 4.0f;
                ++n2;
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException {
        VisuTraj visuTraj = new VisuTraj();
        visuTraj.initData();
        visuTraj.initVisad();
        int n = 0;
        while (n < 500) {
            visuTraj.step(n);
            ++n;
        }
    }
}

