/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.install.ProgressMonitor;
import visad.util.CmdlineGenericConsumer;
import visad.util.CmdlineParser;

public class TestUtil
extends CmdlineGenericConsumer {
    private File fromFile;
    private File toFile;
    private String suffix;
    private boolean trackProgress;

    public TestUtil(String[] stringArray) {
        JFrame jFrame;
        CmdlineParser cmdlineParser = new CmdlineParser(this);
        if (!cmdlineParser.processArgs(stringArray)) {
            System.err.println("Exiting...");
            System.exit(1);
        }
        ProgressMonitor progressMonitor = null;
        if (this.trackProgress) {
            jFrame = new JFrame("Frame-o-licious");
            progressMonitor = new ProgressMonitor();
            jFrame.getContentPane().add(this.buildProgress("Copying " + this.fromFile + " to " + this.toFile, progressMonitor));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
        }
        jFrame = new MakeCopy(this, progressMonitor, this.fromFile, this.toFile, this.suffix);
        ((Thread)((Object)jFrame)).start();
        while (((Thread)((Object)jFrame)).isAlive()) {
            try {
                ((Thread)((Object)jFrame)).join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (!jFrame.getResult()) {
            System.err.println("Copy failed!");
            System.exit(1);
        }
        System.out.println("Copied \"" + this.fromFile + "\" to \"" + this.toFile + "\"");
        System.exit(0);
    }

    private JPanel buildProgress(String string, ProgressMonitor progressMonitor) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("North", new JLabel(string));
        jPanel.add("South", progressMonitor);
        return jPanel;
    }

    public int checkKeyword(String string, int n, String[] stringArray) {
        if (this.fromFile == null) {
            this.fromFile = new File(stringArray[n]);
            if (!this.fromFile.exists()) {
                System.err.println(String.valueOf(string) + ": File \"" + this.fromFile + "\" does not exist");
                return -1;
            }
            return 1;
        }
        if (this.toFile == null) {
            this.toFile = new File(stringArray[n]);
            return 1;
        }
        return super.checkKeyword(string, n, stringArray);
    }

    public int checkOption(String string, char c, String string2) {
        if (c == 'p') {
            this.trackProgress = true;
            return 1;
        }
        if (c == 's') {
            this.suffix = string2;
            return 2;
        }
        return super.checkOption(string, c, string2);
    }

    public boolean finalizeArgs(String string) {
        if (this.fromFile == null || this.toFile == null) {
            System.err.println(String.valueOf(string) + ": Please specify two file names!");
            return false;
        }
        return true;
    }

    public void initializeArgs() {
        this.toFile = null;
        this.fromFile = null;
        this.suffix = null;
        this.trackProgress = false;
    }

    public String keywordUsage() {
        return " fromFile toFile";
    }

    public static final void main(String[] stringArray) {
        new TestUtil(stringArray);
    }

    public String optionUsage() {
        return " [-p(rogressBar)]";
    }
}

