/*
 * Decompiled with CFR 0.152.
 */
import java.rmi.RemoteException;
import visad.DataReference;
import visad.DisplayImpl;
import visad.LocalDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.RemoteSourceListener;
import visad.VisADException;
import visad.util.ClientServer;
import visad.util.CmdlineConsumer;
import visad.util.CmdlineParser;

public abstract class TestSkeleton
extends Thread
implements CmdlineConsumer,
RemoteSourceListener {
    private static final int maximumWaitTime = 60;
    boolean startServer;
    String hostName;
    private CmdlineParser cmdline = new CmdlineParser(this);

    boolean hasClientServerMode() {
        return true;
    }

    public void initializeArgs() {
        this.startServer = false;
        this.hostName = null;
    }

    public int checkOption(String string, char c, String string2) {
        if (c == 'c') {
            if (string2 == null) {
                System.err.println(string + ": Missing hostname for \"-c\"");
                return -1;
            }
            if (!this.hasClientServerMode()) {
                System.err.println("Client/server mode not supported for " + string);
                return -1;
            }
            if (this.startServer) {
                System.err.println(string + ": Cannot specify both '-c' and '-s'!");
                return -1;
            }
            this.hostName = string2;
            return 2;
        }
        if (c == 's') {
            if (this.hostName != null) {
                System.err.println(string + ": Cannot specify both '-c' and '-s'!");
                return -1;
            }
            if (!this.hasClientServerMode()) {
                System.err.println("Client/server mode not supported for " + string);
                return -1;
            }
            this.startServer = true;
            return 1;
        }
        return 0;
    }

    public String optionUsage() {
        if (this.hasClientServerMode()) {
            return " [-c(lient) hostname] [-s(erver)]";
        }
        return "";
    }

    public int checkKeyword(String string, int n, String[] stringArray) {
        return 0;
    }

    public String keywordUsage() {
        return "";
    }

    public boolean finalizeArgs(String string) {
        return true;
    }

    boolean processArgs(String[] stringArray) {
        return this.cmdline.processArgs(stringArray);
    }

    boolean isServer() {
        return this.startServer && this.hostName == null;
    }

    boolean isClient() {
        return !this.startServer && this.hostName != null;
    }

    boolean isStandalone() {
        return !this.startServer && this.hostName == null;
    }

    String getClientServerTitle() {
        if (this.isServer()) {
            return " server";
        }
        if (this.isClient()) {
            return " client";
        }
        if (this.isStandalone()) {
            return " standalone";
        }
        return " unknown";
    }

    DataReference[] getClientDataReferences() throws RemoteException, VisADException {
        return null;
    }

    void finishClientSetup(RemoteServer remoteServer) throws RemoteException, VisADException {
    }

    public void dataSourceLost(String string) {
        System.err.println("Lost Data object \"" + string + "\"");
    }

    public void collabSourceLost(int n) {
        System.err.println("Lost collaboration source #" + n);
    }

    LocalDisplay[] setupClientData() throws RemoteException, VisADException {
        RemoteServer remoteServer;
        DataReference[] dataReferenceArray = this.getClientDataReferences();
        try {
            remoteServer = ClientServer.connectToServer(this.hostName, this.getClass().getName(), true);
        }
        catch (VisADException visADException) {
            System.err.println(visADException.getMessage());
            System.exit(1);
            remoteServer = null;
        }
        LocalDisplay[] localDisplayArray = ClientServer.getClientDisplays(remoteServer, dataReferenceArray);
        if (localDisplayArray == null) {
            throw new VisADException("No remote displays found!");
        }
        int n = 0;
        while (n < localDisplayArray.length) {
            ((DisplayImpl)localDisplayArray[n]).addRemoteSourceListener((RemoteSourceListener)this);
            ++n;
        }
        this.finishClientSetup(remoteServer);
        return localDisplayArray;
    }

    abstract DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException;

    abstract void setupServerData(LocalDisplay[] var1) throws RemoteException, VisADException;

    void setServerDataReferences(RemoteServerImpl remoteServerImpl) throws RemoteException, VisADException {
    }

    void setupUI(LocalDisplay[] localDisplayArray) throws RemoteException, VisADException {
    }

    public void startThreads() throws RemoteException, VisADException {
        LocalDisplay[] localDisplayArray;
        if (this.isClient()) {
            localDisplayArray = this.setupClientData();
        } else {
            RemoteServerImpl remoteServerImpl;
            DisplayImpl[] displayImplArray = this.setupServerDisplays();
            if (!this.startServer) {
                remoteServerImpl = null;
            } else {
                remoteServerImpl = ClientServer.startServer(this.getClass().getName());
                if (displayImplArray != null) {
                    int n = 0;
                    while (n < displayImplArray.length) {
                        remoteServerImpl.addDisplay(new RemoteDisplayImpl(displayImplArray[n]));
                        ++n;
                    }
                }
            }
            this.setServerDataReferences(remoteServerImpl);
            localDisplayArray = displayImplArray;
            this.setupServerData(localDisplayArray);
        }
        this.setupUI(localDisplayArray);
    }

    public String toString() {
        return null;
    }

    public TestSkeleton() {
    }

    public TestSkeleton(String[] stringArray) throws RemoteException, VisADException {
        this();
        if (!this.processArgs(stringArray)) {
            System.err.println("Exiting...");
            System.exit(1);
        }
        this.startThreads();
    }
}

